/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.data;

import com.mojang.serialization.MapCodec;
import eu.pb4.polyfactory.data.DataContainer;
import eu.pb4.polyfactory.data.DataType;
import eu.pb4.polyfactory.data.LongData;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public record ListData(List<DataContainer> list) implements DataContainer
{
    public static MapCodec<ListData> TYPE_CODEC = DataContainer.CODEC.listOf().xmap(ListData::new, ListData::list).fieldOf("list");

    public DataType<ListData> type() {
        return DataType.LIST;
    }

    @Override
    public String asString() {
        StringBuilder b = new StringBuilder();
        b.append("[ ");
        this.list.forEach(v -> b.append(v.asString()).append(' '));
        b.append(']');
        return b.toString();
    }

    @Override
    public long asLong() {
        return this.list.size();
    }

    @Override
    public double asDouble() {
        return this.asLong();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public DataContainer extract(String field) {
        if (field.equals("size")) {
            return new LongData(this.list.size());
        }
        if (field.startsWith("key:")) {
            String num = field.substring("key:".length());
            try {
                int index = Integer.parseInt(num);
                if (index >= 0 && index < this.list.size()) {
                    return this.list.get(index);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return DataContainer.super.extract(field);
    }

    @Override
    public int compareTo(@NotNull DataContainer o) {
        return this.asString().compareTo(o.asString());
    }

    public void forEachFlat(Consumer<DataContainer> consumer) {
        for (DataContainer e : this.list) {
            if (e instanceof ListData) {
                ListData listData = (ListData)e;
                listData.forEachFlat(consumer);
                continue;
            }
            consumer.accept(e);
        }
    }

    public boolean forEachFlatBool(Predicate<DataContainer> consumer) {
        boolean out = false;
        for (DataContainer e : this.list) {
            if (e instanceof ListData) {
                ListData listData = (ListData)e;
                out |= listData.forEachFlatBool(consumer);
                continue;
            }
            out |= consumer.test(e);
        }
        return out;
    }
}

