/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import eu.pb4.polyfactory.data.DataContainer;
import eu.pb4.polyfactory.data.DataType;
import org.jetbrains.annotations.NotNull;

public record ProgressData(float value) implements DataContainer
{
    public static MapCodec<ProgressData> TYPE_CODEC = Codec.FLOAT.xmap(ProgressData::new, ProgressData::value).fieldOf("value");

    public DataType<ProgressData> type() {
        return DataType.PROGRESS;
    }

    @Override
    public String asString() {
        return this.value * 100.0f + "%";
    }

    @Override
    public long asLong() {
        return (long)this.asDouble();
    }

    @Override
    public double asDouble() {
        return this.value * 100.0f;
    }

    @Override
    public float asProgress() {
        return this.value;
    }

    @Override
    public int compareTo(@NotNull DataContainer o) {
        return Double.compare(this.value, o.asDouble());
    }
}

