/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.entity;

import com.mojang.serialization.Codec;
import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.mechanical.ChainDriveBlock;
import eu.pb4.polyfactory.block.mechanical.ChainDriveBlockEntity;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.entity.EntityCatchingVehicle;
import eu.pb4.polyfactory.entity.FactoryEntities;
import eu.pb4.polyfactory.entity.configurable.ConfigurableEntity;
import eu.pb4.polyfactory.entity.configurable.EntityConfig;
import eu.pb4.polyfactory.entity.configurable.EntityConfigValue;
import eu.pb4.polyfactory.entity.configurable.EntityValueFormatter;
import eu.pb4.polyfactory.entity.configurable.WrenchModifyEntityValue;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1688;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5244;
import net.minecraft.class_8836;
import net.minecraft.class_9817;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import xyz.nucleoid.packettweaker.PacketContext;

public class ChainLiftEntity
extends class_8836
implements PolymerEntity,
ConfigurableEntity<ChainLiftEntity>,
EntityCatchingVehicle {
    private static final class_1799 MODEL = ItemDisplayElementUtil.getModel((class_2960)ModInit.id("entity/chain_lift"));
    private static final EntityConfig<Boolean, ChainLiftEntity> PLAYER_CONTROL_CONFIG = EntityConfig.of("player_control", Codec.BOOL, EntityConfigValue.of(x -> x.playerControllable, (x, y) -> {
        x.playerControllable = y;
    }), EntityValueFormatter.text(class_5244::method_36134), WrenchModifyEntityValue.iterate(List.of(Boolean.valueOf(false), Boolean.valueOf(true))));
    private static final List<EntityConfig<?, ChainLiftEntity>> CONFIGURATION = List.of(PLAYER_CONTROL_CONFIG, CATCH_ENTITIES_CONFIG.cast(), EntityConfig.DISMOUNT.cast());
    @Nullable
    private class_2338 sourcePos;
    @Nullable
    private class_2338 targetPos;
    @Nullable
    private class_243 attachedPos;
    private float progress = 0.0f;
    private float centerAngle = 0.0f;
    private int ticksSinceBounceEffect = -1;
    private int timeInCenter = 0;
    private int bounceAnimationTimes = -1;
    private int shakeAnimationTimer = -1;
    private boolean canCatchEntities = true;
    private boolean playerControllable = true;
    private static final class_2940<Quaternionf> ROTATION = class_2945.method_12791(ChainLiftEntity.class, (class_2941)class_2943.field_42235);

    public ChainLiftEntity(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
        EntityAttachment.ofTicking((ElementHolder)new Model(), (class_1297)this);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ROTATION, (Object)new Quaternionf());
    }

    public static class_1269 attach(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        ChainLiftEntity ent = new ChainLiftEntity(FactoryEntities.CHAIN_LIFT, world);
        ent.method_66652(stack);
        class_243 vec = hit.method_17784().method_1020(class_243.method_24953((class_2382)pos)).method_1029().method_22882();
        float angle = ChainLiftEntity.calculateAngle(vec, (class_2350.class_2351)state.method_11654(ChainDriveBlock.AXIS));
        Quaternionf facingRotFrom = (switch ((class_2350.class_2351)state.method_11654(ChainDriveBlock.AXIS)) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11052 -> class_2350.field_11036.method_23224();
            case class_2350.class_2351.field_11048 -> class_2350.field_11034.method_23224();
            case class_2350.class_2351.field_11051 -> class_2350.field_11035.method_23224();
        }).rotateY(angle);
        ent.attachedPos = class_243.method_24953((class_2382)pos).method_1019(new class_243(new Vector3f(0.0f, 0.0f, 0.5625f).rotate((Quaternionfc)facingRotFrom)));
        class_243 entPos = class_243.method_24953((class_2382)pos).method_1019(new class_243(new Vector3f(0.0f, 0.0f, 0.6625f).rotate((Quaternionfc)facingRotFrom))).method_1023(0.0, (double)ent.method_5864().method_17686(), 0.0);
        ent.method_33574(entPos);
        ent.sourcePos = pos;
        ent.centerAngle = angle;
        ent.method_36456(-angle * 57.295776f - 90.0f);
        class_238 box = new class_238(entPos.field_1352 - 0.4, entPos.field_1351, entPos.field_1350 - 0.4, entPos.field_1352 + 0.4, entPos.field_1351 + 1.5, entPos.field_1350 + 0.4);
        if (!world.method_8587((class_1297)ent, box)) {
            return class_1269.field_5814;
        }
        world.method_8649((class_1297)ent);
        stack.method_57008(1, (class_1309)player);
        return class_1269.field_52422;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (this.method_5782() && !this.method_5817()) {
            this.method_5772();
            this.shakeAnimationTimer = 10;
            return class_1269.field_52422;
        }
        player.method_5804((class_1297)this);
        return class_1269.field_52422;
    }

    public class_243 method_24829(class_1309 passenger) {
        return this.method_73189();
    }

    public void method_5773() {
        boolean bounced;
        class_243 pos;
        ChainDriveBlockEntity be;
        class_2586 class_25862;
        class_1937 class_19372 = this.method_73183();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        ChainDriveBlockEntity chainDrive = this.sourcePos != null && (class_25862 = this.method_73183().method_8321(this.sourcePos)) instanceof ChainDriveBlockEntity ? (be = (ChainDriveBlockEntity)class_25862) : null;
        ChainDriveBlock.Route route = this.targetPos != null && chainDrive != null ? chainDrive.getRoute(this.targetPos) : null;
        this.method_46396();
        if (chainDrive == null || route == null && this.attachedPos != null && class_243.method_24953((class_2382)this.sourcePos).method_1025(this.attachedPos) > 1.125) {
            this.sourcePos = null;
            this.targetPos = null;
            this.attachedPos = null;
            this.method_18799(this.method_18798().method_1021(0.98).method_1031(0.0, -0.06, 0.0));
            this.method_5784(class_1313.field_6308, this.method_18798());
            super.method_5773();
            if (this.method_24828()) {
                this.method_7516(world, world.method_48963().method_48827());
            }
            return;
        }
        if (this.attachedPos == null) {
            this.attachedPos = this.method_73189().method_1031(0.0, (double)this.method_5864().method_17686(), 0.0);
        }
        class_1297 passanger = this.method_31483();
        if (world.method_49803(this.method_24515()) || world.method_49803(this.method_24515().method_10084())) {
            if (this.method_5782()) {
                this.method_5772();
            }
            this.shakeAnimationTimer = 10;
            passanger = null;
        } else if (passanger == null && this.canCatchEntities) {
            class_1297 ent;
            pos = this.method_73189();
            class_238 box = new class_238(pos.field_1352 - 0.4, pos.field_1351, pos.field_1350 - 0.4, pos.field_1352 + 0.4, pos.field_1351 + 1.0, pos.field_1350 + 0.4);
            List ents = world.method_8333((class_1297)this, box, this::canPickupEntity);
            Iterator iterator = ents.iterator();
            while (iterator.hasNext() && !(passanger = (ent = (class_1297)iterator.next())).method_5873((class_1297)this, passanger instanceof class_1688, true)) {
                passanger = null;
            }
        }
        pos = this.method_73189();
        class_243 attachedPos = this.attachedPos;
        float rotMax = 1.0859648f;
        float moveSpeed = Math.clamp(RotationUser.getRotation((class_1937)world, this.sourcePos).speedRadians(), -rotMax, rotMax);
        boolean reverse = moveSpeed < 0.0f;
        float yaw = this.method_36454();
        class_243 centeredChainDrive = class_243.method_24953((class_2382)chainDrive.method_11016());
        boolean canMove = this.ticksSinceBounceEffect == -1 || this.ticksSinceBounceEffect > 4;
        boolean bl = bounced = !canMove;
        if (route == null && canMove) {
            class_2350.class_2351 axis = (class_2350.class_2351)chainDrive.method_11010().method_11654(ChainDriveBlock.AXIS);
            Quaternionf facingRotFrom = (switch (axis) {
                default -> throw new MatchException(null, null);
                case class_2350.class_2351.field_11052 -> class_2350.field_11036.method_23224();
                case class_2350.class_2351.field_11048 -> class_2350.field_11034.method_23224();
                case class_2350.class_2351.field_11051 -> class_2350.field_11035.method_23224();
            }).rotateY(this.centerAngle);
            class_243 offset = new class_243(new Vector3f(0.0f, 0.0f, 0.5625f).rotate((Quaternionfc)facingRotFrom));
            pos = centeredChainDrive.method_1023(0.0, (double)this.method_5864().method_17686(), 0.0).method_1019(new class_243(new Vector3f(0.0f, 0.0f, 0.6625f).rotate((Quaternionfc)facingRotFrom)));
            attachedPos = centeredChainDrive.method_1019(offset);
            float moved = this.checkMove(world, this.method_73189(), pos);
            pos = this.method_73189().method_35590(pos, (double)moved);
            attachedPos = this.attachedPos.method_35590(attachedPos, (double)moved);
            bounced = moved != 1.0f;
            class_3545<class_2338, ChainDriveBlock.Route> newTarget = this.findNewTarget(chainDrive, offset, reverse, moveSpeed * moved);
            double angle = 0.0;
            yaw = -this.centerAngle * 57.295776f - 90.0f;
            ++this.timeInCenter;
            if (newTarget != null) {
                if (reverse) {
                    this.targetPos = this.sourcePos;
                    this.sourcePos = (class_2338)newTarget.method_15442();
                    this.progress = (float)(((ChainDriveBlock.Route)newTarget.method_15441()).distance() - (double)((float)(((double)moveSpeed - angle) * 0.5625 * (double)moved)));
                } else {
                    this.targetPos = (class_2338)newTarget.method_15442();
                    this.progress = (float)(((double)moveSpeed - angle) * 0.5625 * (double)moved);
                }
                this.centerAngle = 0.0f;
            } else {
                this.centerAngle = (this.centerAngle + moveSpeed * moved) % ((float)Math.PI * 2);
            }
        } else if (route == null) {
            ++this.timeInCenter;
        } else if (canMove) {
            double mappedProgress;
            this.timeInCenter = 0;
            attachedPos = centeredChainDrive.method_1019(route.startPos().method_35590(route.startOffset(), (double)this.progress / route.distance()));
            pos = attachedPos.method_1023(0.0, (double)this.method_5864().method_17686(), 0.0);
            float moved = this.checkMove(world, this.method_73189(), pos);
            pos = this.method_73189().method_35590(pos, (double)moved);
            attachedPos = this.attachedPos.method_35590(attachedPos, (double)moved);
            bounced = moved != 1.0f;
            class_243 offset = route.startOffset().method_1020(route.startPos()).method_1029();
            yaw = (float)(class_3532.method_15349((double)offset.field_1350, (double)offset.field_1352) * 57.2957763671875) - 90.0f;
            double d = mappedProgress = reverse ? route.distance() - (double)this.progress : (double)this.progress;
            if (mappedProgress + (double)(Math.abs(moveSpeed * moved) * 0.5625f) >= route.distance() - 0.5625) {
                ChainDriveBlockEntity be2;
                class_2586 class_25863;
                ChainDriveBlockEntity chainDrive2;
                ChainDriveBlockEntity chainDriveBlockEntity = reverse ? chainDrive : (chainDrive2 = (class_25863 = this.method_73183().method_8321(this.targetPos)) instanceof ChainDriveBlockEntity ? (be2 = (ChainDriveBlockEntity)class_25863) : null);
                if (chainDrive2 == null) {
                    this.sourcePos = null;
                    this.targetPos = null;
                    return;
                }
                float angle = 0.0f;
                class_243 vec = class_243.method_24953((class_2382)(reverse ? this.sourcePos : this.targetPos)).method_1020(attachedPos);
                angle = ChainLiftEntity.calculateAngle(vec, (class_2350.class_2351)chainDrive2.method_11010().method_11654(ChainDriveBlock.AXIS));
                class_3545<class_2338, ChainDriveBlock.Route> newTarget = this.findNewTarget(chainDrive2, vec, reverse, (float)((mappedProgress + (double)Math.abs(moveSpeed * moved) - route.distance() + 0.5625) * (double)class_3532.method_17822((double)moveSpeed)));
                if (!reverse) {
                    this.sourcePos = this.targetPos;
                }
                this.progress = 0.0f;
                this.centerAngle = angle;
                this.targetPos = newTarget != null ? (class_2338)newTarget.method_15442() : null;
            } else {
                this.progress += moveSpeed * 0.5625f * moved;
            }
        }
        this.method_36456(class_3532.method_17821((float)0.3f, (float)this.method_36454(), (float)yaw));
        if (passanger != null) {
            if (passanger instanceof class_1688) {
                passanger.method_36456(this.method_36454() - 90.0f);
            } else if (!(passanger instanceof class_1309) || passanger instanceof class_1531) {
                passanger.method_36456(this.method_36454());
            }
        }
        if (bounced) {
            if (this.ticksSinceBounceEffect++ % 15 == 0) {
                this.method_5783(class_3417.field_24065, 0.5f, 0.8f);
                world.method_65096((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351 + 0.3, pos.field_1350, 5, 0.3, 0.3, 0.3, 0.0);
            } else if (this.ticksSinceBounceEffect % 5 == 0) {
                this.bounceAnimationTimes = 8;
            }
        } else {
            this.ticksSinceBounceEffect = -1;
        }
        Quaternionf rotation = new Quaternionf();
        if (this.shakeAnimationTimer > 0) {
            rotation.rotateY((float)(Math.sin((float)(this.field_6012 % 360) * ((float)Math.PI / 180) * 50.0f) * (double)((float)this.shakeAnimationTimer / 32.0f)));
            --this.shakeAnimationTimer;
        }
        if (this.bounceAnimationTimes > 0) {
            rotation.rotateX((float)(-this.bounceAnimationTimes) * 1.5f * ((float)Math.PI / 180));
            --this.bounceAnimationTimes;
        }
        this.field_6011.method_12778(ROTATION, (Object)rotation);
        if (!Objects.equals(this.attachedPos, attachedPos)) {
            this.attachedPos = attachedPos;
        }
        if (!this.method_73189().equals((Object)pos)) {
            this.method_18799(pos.method_1020(this.method_73189()));
            this.method_33574(pos);
            if (passanger instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)passanger;
                TriggerCriterion.trigger((class_3222)serverPlayer, (class_2960)FactoryTriggers.CHAIN_LIFT);
            }
        } else {
            this.method_23311();
        }
        super.method_5773();
    }

    private float checkMove(class_3218 world, class_243 currentPos, class_243 newPos) {
        float move = 1.0f;
        while (true) {
            class_238 box = new class_238(newPos.field_1352 - 0.2, newPos.field_1351 + 0.1, newPos.field_1350 - 0.2, newPos.field_1352 + 0.2, newPos.field_1351 + (double)1.4f, newPos.field_1350 + 0.2);
            class_238 entbox = new class_238(newPos.field_1352 - 0.35, newPos.field_1351, newPos.field_1350 - 0.35, newPos.field_1352 + 0.35, newPos.field_1351 + (double)1.4f, newPos.field_1350 + 0.35);
            class_243 finalNewPos = newPos;
            if (world.method_8587((class_1297)this, box) && world.method_8333((class_1297)this, entbox, x -> {
                if (!(x instanceof ChainLiftEntity)) {
                    return false;
                }
                ChainLiftEntity chainLift = (ChainLiftEntity)x;
                if (chainLift.method_73189().equals((Object)finalNewPos)) {
                    return this.method_5628() < chainLift.method_5628();
                }
                if (this.targetPos != null && this.targetPos.equals((Object)chainLift.targetPos)) {
                    return this.progress < chainLift.progress;
                }
                return this.timeInCenter < chainLift.timeInCenter;
            }).isEmpty()) {
                return move;
            }
            if (newPos.method_1025(currentPos) < 0.005) {
                return 0.0f;
            }
            newPos = currentPos.method_35590(newPos, 0.95);
            move *= 0.95f;
        }
    }

    public class_4048 method_18377(class_4050 pose) {
        float height;
        float width;
        class_4048 dim = super.method_18377(pose);
        if (this.method_5782()) {
            class_1297 passanger = this.method_31483();
            width = Math.max(passanger.method_17681() + 0.1f, dim.comp_2185() + 0.1f);
            height = Math.clamp(passanger.method_17682() - 0.1f, 0.2f, 0.5f);
        } else {
            width = dim.comp_2185() + 0.1f;
            height = 0.5f;
        }
        return new class_4048(width, height, height * 0.75f, dim.comp_2188(), false);
    }

    public boolean method_70667() {
        return true;
    }

    public boolean method_5863() {
        return true;
    }

    private boolean canPickupEntity(class_1297 entity) {
        class_9817 leashable;
        return !(entity instanceof class_1657) && !(entity instanceof ChainLiftEntity) && entity.method_17682() < 2.0f && !(entity instanceof class_1676) && (!(entity instanceof class_9817) || !(leashable = (class_9817)entity).method_60953()) && !entity.method_5765();
    }

    private static float calculateAngle(class_243 vec, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11052 -> (float)Math.atan2(-vec.field_1352, -vec.field_1350);
            case class_2350.class_2351.field_11048 -> (float)Math.atan2(vec.field_1350, vec.field_1351);
            case class_2350.class_2351.field_11051 -> (float)Math.atan2(-vec.field_1352, vec.field_1351);
        };
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private class_3545<class_2338, ChainDriveBlock.Route> findNewTarget(ChainDriveBlockEntity chainDrive, class_243 offset, boolean reverse, float moveSpeed) {
        var7_5 = this.method_31483();
        if (!(var7_5 instanceof class_3222)) ** GOTO lbl-1000
        player = (class_3222)var7_5;
        if (this.playerControllable) {
            conns = new ArrayList<E>();
            camera = player.method_5720();
            tmp = new ArrayList<class_3545>();
            for (class_2338 conn : chainDrive.connections()) {
                vec = class_243.method_24953((class_2382)conn).method_1020(player.method_33571()).method_1029();
                tmp.add(new class_3545((Object)conn, (Object)vec.method_1020(camera).method_1027()));
            }
            tmp.sort(Comparator.comparingDouble((ToDoubleFunction<class_3545>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, method_15441(), (Lnet/minecraft/class_3545;)D)()));
            if (!tmp.isEmpty() && (Double)((class_3545)tmp.getFirst()).method_15441() <= 0.25) {
                conns.add((class_2338)((class_3545)tmp.getFirst()).method_15442());
            } else {
                for (class_3545 t : tmp) {
                    conns.add((class_2338)t.method_15442());
                }
            }
        } else lbl-1000:
        // 2 sources

        {
            conns = new ArrayList<class_2338>(chainDrive.connections());
            conns.sort(Comparator.comparingDouble((ToDoubleFunction<class_2338>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, lambda$findNewTarget$3(eu.pb4.polyfactory.block.mechanical.ChainDriveBlockEntity boolean net.minecraft.class_243 net.minecraft.class_2338 ), (Lnet/minecraft/class_2338;)D)((ChainDriveBlockEntity)chainDrive, (boolean)reverse, (class_243)offset)));
        }
        for (class_2338 conn : conns) {
            if (conn.equals((Object)this.sourcePos) || conn.equals((Object)this.targetPos)) continue;
            route = chainDrive.getRoute(conn);
            shift = new class_243(new Vector3f(0.2625f, 0.0f, 0.0f).rotate((Quaternionfc)route.facingRotTo()));
            if (!reverse && route.startPos().method_1019(shift).method_1022(offset) <= (double)Math.max(moveSpeed, 0.3f)) {
                return new class_3545((Object)conn, (Object)route);
            }
            if (!reverse || !(route.endPos().method_1019(shift).method_1022(offset) <= (double)Math.max(-moveSpeed, 0.3f))) continue;
            return new class_3545((Object)conn, (Object)route);
        }
        return null;
    }

    public void method_54299(int damageWobbleTicks) {
        super.method_54299(damageWobbleTicks);
        this.shakeAnimationTimer = damageWobbleTicks;
    }

    protected class_1792 method_7557() {
        return FactoryItems.CHAIN_LIFT;
    }

    @Nullable
    public class_1799 method_31480() {
        return this.method_7557().method_7854();
    }

    protected void method_5749(class_11368 view) {
        this.sourcePos = view.method_71426("source_pos", class_2338.field_25064).orElse(null);
        this.targetPos = view.method_71426("target_pos", class_2338.field_25064).orElse(null);
        this.centerAngle = view.method_71423("center_angle", 0.0f);
        this.progress = view.method_71423("progress", 0.0f);
        this.attachedPos = view.method_71426("attached_pos", class_243.field_38277).orElse(null);
        this.timeInCenter = view.method_71424("time_in_center", 0);
        this.canCatchEntities = view.method_71433("can_catch_entities", true);
        this.playerControllable = view.method_71433("player_control", true);
    }

    protected void method_5652(class_11372 view) {
        view.method_71477("source_pos", class_2338.field_25064, (Object)this.sourcePos);
        view.method_71477("attached_pos", class_243.field_38277, (Object)this.attachedPos);
        if (this.targetPos != null) {
            view.method_71468("target_pos", class_2338.field_25064, (Object)this.targetPos);
            view.method_71464("progress", this.progress);
        } else if (this.sourcePos != null) {
            view.method_71464("center_angle", this.centerAngle);
            view.method_71465("time_in_center", this.timeInCenter);
        }
        view.method_71472("can_catch_entities", this.canCatchEntities);
        view.method_71472("player_control", this.playerControllable);
    }

    public void modifyRawTrackedData(List<class_2945.class_7834<?>> data, class_3222 player, boolean initial) {
        boolean interpolate = false;
        for (int i = 0; i < data.size(); ++i) {
            class_2945.class_7834<?> entry = data.get(i);
            if (entry.comp_1115() != ROTATION.comp_2327()) continue;
            data.set(i, class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.LEFT_ROTATION, (Object)((Quaternionf)entry.comp_1117())));
            interpolate = true;
        }
        if (initial) {
            data.add(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.TELEPORTATION_DURATION, (Object)3));
            data.add(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.INTERPOLATION_DURATION, (Object)2));
            data.add(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.TRANSLATION, (Object)new Vector3f(0.0f, 0.8125f, 0.0f)));
            data.add(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.Item.ITEM, (Object)MODEL));
        } else if (interpolate) {
            data.add(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.START_INTERPOLATION, (Object)0));
        }
        super.modifyRawTrackedData(data, player, initial);
    }

    public class_1299<?> getPolymerEntityType(PacketContext packetContext) {
        return class_1299.field_42456;
    }

    @Override
    public List<EntityConfig<?, ChainLiftEntity>> getEntityConfiguration(class_3222 player, class_243 targetPos) {
        return CONFIGURATION;
    }

    @Override
    public void writeMinimalConfigurationToStack(Consumer<EntityConfig<?, ChainLiftEntity>> consumer) {
        if (!this.canCatchEntities) {
            consumer.accept(CATCH_ENTITIES_CONFIG.cast());
        }
        if (!this.playerControllable) {
            consumer.accept(PLAYER_CONTROL_CONFIG);
        }
    }

    @Override
    public boolean polyfactory$canCatchEntities() {
        return this.canCatchEntities;
    }

    @Override
    public void polyfactory$setCatchEntities(boolean value) {
        this.canCatchEntities = value;
    }

    private static /* synthetic */ double lambda$findNewTarget$3(ChainDriveBlockEntity chainDrive, boolean reverse, class_243 offset, class_2338 conn) {
        ChainDriveBlock.Route route = chainDrive.getRoute(conn);
        class_243 shift = new class_243(new Vector3f(0.2625f, 0.0f, 0.0f).rotate((Quaternionfc)route.facingRotTo()));
        if (reverse) {
            return Math.abs(route.endPos().method_1019(shift).method_1022(offset));
        }
        return Math.abs(route.startPos().method_1019(shift).method_1022(offset));
    }

    private class Model
    extends ElementHolder {
        public final InteractionElement interaction;
        private boolean noTick = true;

        public Model() {
            VirtualElement.InteractionHandler interaction = VirtualElement.InteractionHandler.redirect((class_1297)ChainLiftEntity.this);
            this.interaction = new InteractionElement(interaction);
            this.interaction.setSendPositionUpdates(false);
            this.addPassengerElement((VirtualElement)this.interaction);
        }

        public boolean startWatching(class_3244 player) {
            if (this.noTick) {
                this.onTick();
            }
            return super.startWatching(player);
        }

        protected void onTick() {
            this.noTick = false;
            this.interaction.setCustomName(ChainLiftEntity.this.method_5797());
            this.interaction.setCustomNameVisible(ChainLiftEntity.this.method_5807());
            if (ChainLiftEntity.this.method_5817()) {
                this.interaction.setSize(0.0f, ChainLiftEntity.this.method_17682() - 0.1f);
            } else {
                this.interaction.setSize(ChainLiftEntity.this.method_17681(), ChainLiftEntity.this.method_17682());
            }
            super.onTick();
        }
    }
}

