/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.entity.configurable;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import eu.pb4.polyfactory.entity.configurable.EntityConfig;
import eu.pb4.polyfactory.item.configuration.ConfigurationData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3902;
import org.jetbrains.annotations.Nullable;

public interface ConfigurableEntity<E extends class_1297> {
    public List<EntityConfig<?, E>> getEntityConfiguration(@Nullable class_3222 var1, @Nullable class_243 var2);

    default public void wrenchTick(class_3222 player, class_243 targetPos) {
    }

    default public void writeMinimalConfigurationToStack(Consumer<EntityConfig<?, E>> consumer) {
    }

    public static void applyConfiguration(ConfigurableEntity<?> configurableEntity, ConfigurationData data) {
        class_1297 entity = (class_1297)configurableEntity;
        List<EntityConfig<?, ?>> configs = configurableEntity.getEntityConfiguration(null, null);
        Map<String, ConfigurationData.Entry> byId = data.byId();
        for (EntityConfig<?, ?> config : configs) {
            DataResult decoded;
            ConfigurationData.Entry entry = byId.get(config.id());
            if (entry == null || !(decoded = config.codec().decode((DynamicOps)JavaOps.INSTANCE, entry.value())).isSuccess()) continue;
            config.value().setValue(((Pair)decoded.getOrThrow()).getFirst(), entity, null);
        }
    }

    public static ConfigurationData extractConfiguration(ConfigurableEntity<?> configurableEntity, boolean copyAll) {
        class_1297 entity = (class_1297)configurableEntity;
        ConfigurableEntity<?> conf = configurableEntity;
        ArrayList<ConfigurationData.Entry> entries = new ArrayList<ConfigurationData.Entry>();
        Consumer consumer = c -> {
            EntityConfig config = c;
            if (c.codec() == class_3902.field_51563) {
                return;
            }
            Object val = config.value().getValue(entity, class_243.field_1353);
            entries.add(new ConfigurationData.Entry(config.name(), config.formatter().getDisplayValue(val, entity, class_243.field_1353), config.id(), config.codec().encodeStart((DynamicOps)JavaOps.INSTANCE, val).getOrThrow()));
        };
        if (copyAll) {
            conf.getEntityConfiguration(null, null).forEach(consumer);
        } else {
            conf.writeMinimalConfigurationToStack(consumer);
        }
        return new ConfigurationData(entries);
    }
}

