/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.fluid;

import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidStack;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;

public interface FluidContainer {
    public long get(FluidInstance<?> var1);

    public long set(FluidInstance<?> var1, long var2);

    default public boolean doesNotContain(FluidInstance<?> type) {
        return !this.contains(type);
    }

    default public boolean contains(FluidInstance<?> type) {
        return this.get(type) > 0L;
    }

    public boolean canInsert(FluidInstance<?> var1, long var2, boolean var4);

    public long insert(FluidInstance<?> var1, long var2, boolean var4);

    public boolean canExtract(FluidInstance<?> var1, long var2, boolean var4);

    public long extract(FluidInstance<?> var1, long var2, boolean var4);

    public long capacity();

    public long stored();

    public Object2LongMap<FluidInstance<?>> asMap();

    public List<FluidInstance<?>> fluids();

    public void clear();

    @Nullable
    default public FluidInstance<?> topFluid() {
        List<FluidInstance<?>> fluids = this.fluids();
        return fluids.isEmpty() ? null : fluids.getLast();
    }

    @Nullable
    default public FluidInstance<?> bottomFluid() {
        List<FluidInstance<?>> fluids = this.fluids();
        return fluids.isEmpty() ? null : fluids.getFirst();
    }

    default public void provideRender(BiConsumer<FluidInstance<?>, Float> consumer) {
        this.forEach((a, b) -> consumer.accept((FluidInstance<?>)a, Float.valueOf((float)((double)b.longValue() / (double)this.capacity()))));
    }

    default public void forEach(BiConsumer<FluidInstance<?>, Long> consumer) {
        for (FluidInstance<?> f : this.fluids()) {
            consumer.accept(f, this.get(f));
        }
    }

    default public void forEachReversed(BiConsumer<FluidInstance<?>, Long> consumer) {
        for (FluidInstance f : this.fluids().reversed()) {
            consumer.accept(f, this.get(f));
        }
    }

    default public boolean isEmpty() {
        return this.stored() == 0L;
    }

    default public boolean canInsert(FluidStack<?> stack, boolean strict) {
        return this.canInsert(stack.instance(), stack.amount(), strict);
    }

    default public boolean canExtract(FluidStack<?> stack, boolean strict) {
        return this.canExtract(stack.instance(), stack.amount(), strict);
    }

    default public void insertExact(FluidInstance<?> instance, long amount) {
        this.insert(instance, amount, true);
    }

    default public long insert(FluidStack<?> stack, boolean strict) {
        return this.insert(stack.instance(), stack.amount(), strict);
    }

    default public long extract(FluidStack<?> stack, boolean strict) {
        return this.extract(stack.instance(), stack.amount(), strict);
    }

    default public float getFilledPercentage() {
        return (float)((double)this.stored() / (double)this.capacity());
    }

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    default public boolean isFull() {
        return this.stored() >= this.capacity();
    }

    default public boolean isNotFull() {
        return !this.isFull();
    }

    default public long empty() {
        return Math.max(this.capacity() - this.stored(), 0L);
    }

    default public int updateId() {
        return System.identityHashCode(this);
    }
}

