/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.fluid;

import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidType;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class FluidContainerImpl
implements FluidContainer {
    private final Object2LongMap<FluidInstance<?>> storedFluids = new Object2LongOpenHashMap();
    private final List<FluidInstance<?>> fluids = new ArrayList();
    private final long capacity;
    private final Runnable markDirty;
    private final BiPredicate<FluidContainer, FluidInstance<?>> canInsert;
    private int updateId = 0;
    private long stored = 0L;
    private float fluidTemperature;

    public FluidContainerImpl(long maxStorage, Runnable markDirty) {
        this(maxStorage, markDirty, (a, x) -> true);
    }

    public FluidContainerImpl(long maxStorage, Runnable markDirty, BiPredicate<FluidContainer, FluidInstance<?>> canInsert) {
        this.capacity = maxStorage;
        this.canInsert = canInsert;
        this.markDirty = markDirty;
    }

    public static FluidContainerImpl singleFluid(long maxStorage, Runnable markDirty) {
        return new FluidContainerImpl(maxStorage, markDirty, (self, type) -> self.isEmpty() || self.contains((FluidInstance<?>)type));
    }

    public static FluidContainerImpl filtered(long maxStorage, Predicate<FluidInstance<?>> filter, Runnable markDirty) {
        return new FluidContainerImpl(maxStorage, markDirty, (self, type) -> filter.test((FluidInstance<?>)type));
    }

    public static FluidContainer onlyInTag(long maxStorage, class_6862<FluidType<?>> tag, Runnable markDirty) {
        return new FluidContainerImpl(maxStorage, markDirty, (self, type) -> type.isIn(tag));
    }

    @Override
    public long get(FluidInstance<?> type) {
        return this.storedFluids.getOrDefault(type, 0L);
    }

    @Override
    public long set(FluidInstance<?> type, long amount) {
        if (amount == 0L) {
            this.fluids.remove(type);
            long current = this.storedFluids.removeLong((Object)amount);
            this.stored -= current;
            this.updateTemperature();
            ++this.updateId;
            this.markDirty.run();
            return current;
        }
        long current = this.storedFluids.put(type, amount);
        this.stored += amount - current;
        if (current == 0L) {
            this.fluids.add(type);
            this.fluids.sort(FluidInstance.DENSITY_COMPARATOR_REVERSED);
        }
        this.updateTemperature();
        ++this.updateId;
        this.markDirty.run();
        return current;
    }

    @Override
    public boolean canInsert(FluidInstance<?> type, long amount, boolean exact) {
        return this.canInsert.test(this, type) && (exact ? this.stored + amount <= this.capacity : this.stored != this.capacity);
    }

    @Override
    public long insert(FluidInstance<?> type, long amount, boolean exact) {
        if (!this.canInsert(type, amount, exact) || amount == 0L) {
            return amount;
        }
        long next = Math.min(this.stored + amount, this.capacity);
        long inserted = next - this.stored;
        long current = this.storedFluids.getOrDefault(type, 0L);
        this.storedFluids.put(type, current + inserted);
        if (current == 0L) {
            this.fluids.add(type);
            this.fluids.sort(FluidInstance.DENSITY_COMPARATOR_REVERSED);
        }
        this.stored = next;
        ++this.updateId;
        this.updateTemperature();
        this.markDirty.run();
        return amount - inserted;
    }

    @Override
    public boolean canExtract(FluidInstance<?> type, long amount, boolean exact) {
        return exact ? this.get(type) >= amount : this.get(type) != 0L;
    }

    @Override
    public long extract(FluidInstance<?> type, long amount, boolean exact) {
        long extracted;
        if (!this.canExtract(type, amount, exact) || amount == 0L) {
            return 0L;
        }
        long current = this.get(type);
        if (current == (extracted = Math.min(current, amount))) {
            this.storedFluids.removeLong(type);
            this.fluids.remove(type);
        } else {
            this.storedFluids.put(type, current - extracted);
        }
        this.stored -= extracted;
        ++this.updateId;
        this.updateTemperature();
        this.markDirty.run();
        return extracted;
    }

    @Override
    @Nullable
    public FluidInstance<?> topFluid() {
        return this.fluids.isEmpty() ? null : this.fluids.getLast();
    }

    @Override
    @Nullable
    public FluidInstance<?> bottomFluid() {
        return this.fluids.isEmpty() ? null : this.fluids.getFirst();
    }

    @Override
    public void forEach(BiConsumer<FluidInstance<?>, Long> consumer) {
        for (FluidInstance<?> f : this.fluids) {
            consumer.accept(f, this.storedFluids.getOrDefault(f, 0L));
        }
    }

    @Override
    public void forEachReversed(BiConsumer<FluidInstance<?>, Long> consumer) {
        for (FluidInstance f : this.fluids.reversed()) {
            consumer.accept(f, this.storedFluids.getOrDefault((Object)f, 0L));
        }
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long stored() {
        return this.stored;
    }

    public float fluidTemperature() {
        return this.fluidTemperature;
    }

    public void writeData(class_11372 view, String key) {
        class_11372.class_11374 out = view.method_71476(key);
        this.storedFluids.forEach((a, b) -> {
            class_11372 x = out.method_71480();
            x.method_71460(FluidInstance.MAP_CODEC, a);
            x.method_71466("amount", b.longValue());
        });
    }

    public void readData(class_11368 view, String fluidKey) {
        class_11368.class_11370 nbt = view.method_71438(fluidKey);
        this.storedFluids.clear();
        this.fluids.clear();
        this.stored = 0L;
        for (class_11368 t : nbt) {
            long value;
            Optional type = t.method_71418(FluidInstance.MAP_CODEC);
            if (!type.isPresent() || (value = t.method_71425("amount", 0L)) == 0L) continue;
            this.storedFluids.put((Object)((FluidInstance)type.get()), value);
            this.stored += value;
        }
        this.updateTemperature();
        this.fluids.addAll((Collection<FluidInstance<?>>)this.storedFluids.keySet());
        this.fluids.sort(FluidInstance.DENSITY_COMPARATOR_REVERSED);
        ++this.updateId;
    }

    private void updateTemperature() {
        float temperature = 0.0f;
        for (FluidInstance<?> fluid : this.fluids) {
            temperature += fluid.heat() * (float)this.get(fluid) / (float)this.stored;
        }
        this.fluidTemperature = temperature;
    }

    @Override
    public int updateId() {
        return this.updateId;
    }

    @Override
    public Object2LongMap<FluidInstance<?>> asMap() {
        return Object2LongMaps.unmodifiable(this.storedFluids);
    }

    @Override
    public List<FluidInstance<?>> fluids() {
        return Collections.unmodifiableList(this.fluids);
    }

    @Override
    public void clear() {
        this.storedFluids.clear();
        this.fluids.clear();
        this.stored = 0L;
        this.markDirty.run();
    }
}

