/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.fluid;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.fluid.FluidType;
import eu.pb4.polyfactory.fluid.shooting.FluidShootingBehavior;
import eu.pb4.polyfactory.other.FactoryRegistries;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_2394;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3902;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_8104;
import org.jetbrains.annotations.Nullable;

public record FluidInstance<T>(FluidType<T> type, T data) {
    public static final Comparator<FluidInstance<?>> DENSITY_COMPARATOR = Comparator.comparingInt(FluidInstance::density);
    public static final Comparator<FluidInstance<?>> DENSITY_COMPARATOR_REVERSED = DENSITY_COMPARATOR.reversed();
    private static final Map<FluidType<?>, MapCodec<FluidInstance<?>>> BASE_CODECS = new IdentityHashMap();
    private static final Map<FluidType<?>, FluidInstance<Object>> DEFAULTS = new IdentityHashMap();
    public static final MapCodec<FluidInstance<?>> MAP_CODEC = FluidType.CODEC.dispatchMap(FluidInstance::type, BASE_CODECS::get);
    public static final Codec<FluidInstance<?>> CODEC = MAP_CODEC.codec();

    public static <T> FluidInstance<T> getDefault(FluidType<T> tFluidType) {
        return DEFAULTS.get(tFluidType);
    }

    public int density() {
        return this.type.density();
    }

    public boolean equals(FluidInstance<?> that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        return this.type == that.type && Objects.equals(this.data, that.data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidInstance that = (FluidInstance)o;
        return this.type == that.type && Objects.equals(this.data, that.data);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this.type) + 31 * this.data.hashCode();
    }

    private static void setup(FluidType<?> type) {
        DEFAULTS.put(type, new FluidInstance(type, type.defaultData()));
        if (type.dataCodec() == class_3902.field_51563) {
            BASE_CODECS.put(type, MapCodec.unit(type.defaultInstance()));
        } else {
            FluidType<?> x = type;
            BASE_CODECS.put(type, x.dataCodec().optionalFieldOf("data", x.defaultData()).xmap(x::toInstance, FluidInstance::data));
        }
    }

    public class_5250 toLabeledAmount(long amount) {
        return this.type.toLabeledAmount(amount, this.data);
    }

    public class_5250 getAmountText(long amount) {
        return this.type.getAmountText(amount, this.data);
    }

    public class_2561 getName() {
        return this.type.getName(this.data);
    }

    public boolean isDefault() {
        return Objects.equals(this.type.defaultData(), this.data);
    }

    public FluidStack<T> stackOf(long amount) {
        return new FluidStack(this, amount);
    }

    public FluidStack<T> ofBottle() {
        return new FluidStack(this, 27000L);
    }

    public FluidStack<T> ofBucket() {
        return new FluidStack(this, 81000L);
    }

    public class_2960 texture() {
        return this.type.texture();
    }

    public float heat() {
        return this.type.heat();
    }

    public class_2394 particle() {
        return this.type.particleGetter().apply(this);
    }

    public long getMaxFlow(class_3218 world) {
        return this.type.maxFlow().getMaxFlow(world, this.data);
    }

    public double getFlowSpeedMultiplier(class_3218 world) {
        return this.type.flowSpeedMultiplier().getSpeedMultiplier(world, this.data);
    }

    public Optional<class_8104> brightness() {
        return this.type.brightness();
    }

    public boolean isIn(class_6862<FluidType<?>> tag) {
        return FactoryRegistries.FLUID_TYPES.method_47983(this.type).method_40220(tag);
    }

    public FluidShootingBehavior<T> shootingBehavior() {
        return this.type.shootingBehavior();
    }

    public class_2520 toNbt(class_7225.class_7874 lookup) {
        return (class_2520)CODEC.encodeStart((DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), (Object)this).getOrThrow();
    }

    @Nullable
    public static FluidInstance<?> fromNbt(class_7225.class_7874 lookup, class_2520 element) {
        if (element == null) {
            return null;
        }
        return CODEC.decode((DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), (Object)element).result().map(Pair::getFirst).orElse(null);
    }

    static {
        for (FluidType type : FactoryRegistries.FLUID_TYPES) {
            FluidInstance.setup(type);
        }
        RegistryEntryAddedCallback.event(FactoryRegistries.FLUID_TYPES).register((rawId, id, object) -> FluidInstance.setup(object));
    }
}

