/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.fluid.shooting;

import eu.pb4.polyfactory.entity.splash.SplashEntity;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.shooting.FluidShootingBehavior;
import eu.pb4.polyfactory.fluid.shooting.ShooterContext;
import eu.pb4.polyfactory.mixin.ProjectileEntityAccessor;
import java.util.UUID;
import net.minecraft.class_10583;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.joml.Vector3f;

public record ShootProjectileEntity<T>(EntityCreator<T> entityCreator, int splashPerTick, AmountGetter<T> amount, float baseSpeed, float extraSpeed, float initialDivergence, float maxDivergence, class_6880<class_3414> soundEvent) implements FluidShootingBehavior<T>
{
    public static <T> FluidShootingBehavior<T> ofSplash(class_1299<? extends SplashEntity<T>> entityType, int splashPerTick, long amount, class_6880<class_3414> soundEvent) {
        return ShootProjectileEntity.ofSplash(entityType, splashPerTick, amount, 2.0f, 0.5f, 0.1f, 0.3f, soundEvent);
    }

    public static <T> FluidShootingBehavior<T> ofSplash(class_1299<? extends SplashEntity<T>> entityType, int splashPerTick, long amount, float baseSpeed, float extraSpeed, float initialDivergence, float maxDivergence, class_6880<class_3414> soundEvent) {
        return new ShootProjectileEntity((world, fluid, a) -> {
            SplashEntity splash = (SplashEntity)entityType.method_5883((class_1937)world, class_3730.field_16465);
            assert (splash != null);
            splash.setFluidData(fluid.data());
            return splash;
        }, splashPerTick, (w, a, b, c) -> amount, baseSpeed, extraSpeed, initialDivergence, maxDivergence, soundEvent);
    }

    public static <T> FluidShootingBehavior<T> ofEntity(class_1299<?> entityType, int splashPerTick, long amount, float baseSpeed, float extraSpeed, float initialDivergence, float maxDivergence, class_6880<class_3414> soundEvent) {
        return new ShootProjectileEntity((world, fluid, a) -> entityType.method_5883((class_1937)world, class_3730.field_16465), splashPerTick, (w, a, b, c) -> amount, baseSpeed, extraSpeed, initialDivergence, maxDivergence, soundEvent);
    }

    @Override
    public boolean canShoot(ShooterContext context, FluidInstance<T> fluidInstance, FluidContainer container) {
        return container.get(fluidInstance) >= this.amount.getAmount(context.world(), container, fluidInstance, true);
    }

    @Override
    public void startShooting(ShooterContext context, FluidInstance<T> fluidInstance, FluidContainer container) {
    }

    @Override
    public void continueShooting(ShooterContext context, FluidInstance<T> fluidInstance, int tick, FluidContainer container) {
        this.shoot(context, Math.min(this.initialDivergence + (float)tick / 100.0f, this.maxDivergence), fluidInstance, container);
    }

    private void shoot(ShooterContext context, float divergence, FluidInstance<T> fluidInstance, FluidContainer container) {
        long amount = this.amount.getAmount(context.world(), container, fluidInstance, false);
        container.extract(fluidInstance, amount, false);
        Vector3f vec = new Vector3f();
        class_243 pos = context.position();
        class_243 rotation = context.rotation();
        class_5819 random = context.random();
        divergence += context.extraSpread();
        class_3218 world = context.world();
        for (int i = 0; i < this.splashPerTick; ++i) {
            class_1297 entity = this.entityCreator.createEntity(world, fluidInstance, amount);
            if (entity instanceof class_1676) {
                class_1676 projectile = (class_1676)entity;
                ((ProjectileEntityAccessor)projectile).setOwner((class_10583<class_1297>)class_10583.method_73300((UUID)context.uuid()));
                if (!context.isEntity()) {
                    ((ProjectileEntityAccessor)projectile).setLeftOwner(true);
                }
            }
            entity.method_33574(pos);
            vec.set(rotation.field_1352, rotation.field_1351, rotation.field_1350);
            vec.add(random.method_62816(0.0f, divergence), random.method_62816(0.0f, divergence), random.method_62816(0.0f, divergence));
            vec.normalize();
            vec.mul((this.baseSpeed + random.method_43057() * this.extraSpeed) * context.force());
            entity.method_18800((double)vec.x, (double)vec.y, (double)vec.z);
            world.method_8649(entity);
        }
        world.method_60511(null, pos.field_1352, pos.field_1351, pos.field_1350, this.soundEvent, context.soundCategory(), 0.5f, (float)random.method_43385(1.0, 0.1));
    }

    @Override
    public void stopShooting(ShooterContext context, FluidInstance<T> fluidInstance) {
    }

    public static interface EntityCreator<T> {
        public class_1297 createEntity(class_3218 var1, FluidInstance<T> var2, long var3);
    }

    public static interface AmountGetter<T> {
        public long getAmount(class_3218 var1, FluidContainer var2, FluidInstance<T> var3, boolean var4);
    }
}

