/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.fluid.world;

import eu.pb4.polyfactory.block.fluids.FluidOutput;
import eu.pb4.polyfactory.block.fluids.transport.PipeBaseBlock;
import eu.pb4.polyfactory.fluid.FactoryFluids;
import eu.pb4.polyfactory.fluid.FluidBehaviours;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidStack;
import java.util.function.Supplier;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3545;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_3902;
import net.minecraft.class_4863;

public final class FluidWorldPullInteraction {
    private final double[] pullOverflow = new double[class_2350.values().length];
    private final class_2680[] pullState = new class_2680[this.pullOverflow.length];
    private final FluidContainer container;
    private final Supplier<class_3218> world;
    private final Supplier<class_2338> pos;

    public FluidWorldPullInteraction(FluidContainer container, Supplier<class_3218> world, Supplier<class_2338> pos) {
        this.container = container;
        this.world = world;
        this.pos = pos;
    }

    /*
     * WARNING - void declaration
     */
    public void pullFluid(class_2350 direction, double strength) {
        class_2338 pos = this.pos();
        class_3218 world = this.world();
        FluidContainer container = this.container();
        class_2338.class_2339 mut = pos.method_25503().method_10098(direction);
        class_2680 pulledBlockState = world.method_8320((class_2338)mut);
        FluidInstance<?> currentFluid = container.topFluid();
        FluidOutput fluidOutput = null;
        class_2248 class_22482 = pulledBlockState.method_26204();
        if (class_22482 instanceof FluidOutput.Getter) {
            FluidOutput.Getter getter = (FluidOutput.Getter)class_22482;
            fluidOutput = getter.getFluidOutput(world, (class_2338)mut, direction.method_10153());
        } else {
            class_22482 = world.method_8321((class_2338)mut);
            if (class_22482 instanceof FluidOutput) {
                FluidOutput fluidOutput2;
                fluidOutput = fluidOutput2 = (FluidOutput)class_22482;
            }
        }
        if (fluidOutput != null) {
            for (FluidInstance fluidInstance : fluidOutput.getContainedFluids(direction.method_10153())) {
                long leftover;
                long maxFlow;
                long amount;
                long extracted;
                if (fluidInstance == null || currentFluid != null && !currentFluid.equals(fluidInstance) || (extracted = fluidOutput.extractFluid(fluidInstance, amount = Math.min(Math.min((long)(strength * (double)(maxFlow = fluidInstance.getMaxFlow(world)) * fluidInstance.getFlowSpeedMultiplier(world)), maxFlow), container.empty()), direction.method_10153(), false)) == (leftover = container.insert(fluidInstance, extracted, false))) continue;
                fluidOutput.extractFluid(fluidInstance, extracted - leftover, direction.method_10153(), true);
                return;
            }
            return;
        }
        if (pulledBlockState == this.getPullState(direction)) {
            class_3545<FluidStack<class_3902>, class_2680> extract;
            if (!pulledBlockState.method_26227().method_15769() && !(pulledBlockState.method_26204() instanceof PipeBaseBlock)) {
                class_3609 stillFluid = null;
                Object var12_16 = null;
                FluidInstance<class_3902> fluidType = null;
                if (pulledBlockState.method_26227().method_15767(class_3486.field_15517)) {
                    fluidType = FactoryFluids.WATER.defaultInstance();
                    stillFluid = class_3612.field_15910;
                    class_3609 class_36092 = class_3612.field_15909;
                } else if (pulledBlockState.method_26227().method_15767(class_3486.field_15518)) {
                    fluidType = FactoryFluids.LAVA.defaultInstance();
                    stillFluid = class_3612.field_15908;
                    class_3609 class_36093 = class_3612.field_15907;
                }
                if (fluidType != null) {
                    long maxFlow = fluidType.getMaxFlow(world);
                    long amount = Math.min(Math.min((long)(strength * (double)maxFlow * fluidType.getFlowSpeedMultiplier(world)), maxFlow), container.empty());
                    this.setPullOverflow(direction, this.getPullOverflow(direction) + (double)amount);
                    if (this.getPullOverflow(direction) >= 81000.0) {
                        void var12_19;
                        class_2338.class_2339 mut2 = mut.method_25503();
                        class_2680 currentState = pulledBlockState;
                        while (currentState.method_26227().method_39360((class_3611)stillFluid) || currentState.method_26227().method_39360((class_3611)var12_19)) {
                            mut2.method_10101((class_2382)mut);
                            class_2680 nextState = world.method_8320((class_2338)mut2.method_10098(class_2350.field_11036));
                            if (nextState.method_26227().method_39360((class_3611)stillFluid) || nextState.method_26227().method_39360((class_3611)var12_19)) {
                                mut.method_10101((class_2382)mut2);
                                currentState = nextState;
                                continue;
                            }
                            if (!currentState.method_26227().method_39360((class_3611)var12_19)) break;
                            int level = currentState.method_26227().method_15761();
                            boolean found = false;
                            mut2.method_10101((class_2382)mut);
                            for (class_2350 testDir : class_2350.class_2353.field_11062) {
                                nextState = world.method_8320((class_2338)mut2.method_10098(testDir));
                                if ((nextState.method_26227().method_39360((class_3611)stillFluid) || nextState.method_26227().method_39360((class_3611)var12_19)) && level < nextState.method_26227().method_15761()) {
                                    mut.method_10101((class_2382)mut2);
                                    level = nextState.method_26227().method_15761();
                                    currentState = nextState;
                                    found = true;
                                }
                                mut2.method_10104(testDir, -1);
                            }
                            if (found) continue;
                        }
                        if (currentState.method_26227().method_15771()) {
                            boolean insert = false;
                            if (currentState.method_26204() instanceof class_3737 && fluidType.type() == FactoryFluids.WATER) {
                                world.method_8501((class_2338)mut, (class_2680)currentState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
                                insert = true;
                            } else if (currentState.method_26204() instanceof class_2404) {
                                world.method_8501((class_2338)mut, class_2246.field_10124.method_9564());
                                insert = true;
                            } else if (currentState.method_45474() || currentState.method_26204() instanceof class_4863) {
                                world.method_22352((class_2338)mut, true);
                                world.method_8501((class_2338)mut, class_2246.field_10124.method_9564());
                                insert = true;
                            }
                            if (insert) {
                                container.insert(fluidType, 81000L, false);
                            }
                        }
                        this.setPullOverflow(direction, 0.0);
                    }
                    return;
                }
            }
            if ((extract = FluidBehaviours.BLOCK_STATE_TO_FLUID_EXTRACT.get(pulledBlockState)) != null && container.canInsert((FluidStack)extract.method_15442(), true)) {
                long l = ((FluidStack)extract.method_15442()).instance().getMaxFlow(world);
                long amount = Math.min(Math.min((long)(strength * (double)l * ((FluidStack)extract.method_15442()).instance().getFlowSpeedMultiplier(world)), l), container.empty());
                this.setPullOverflow(direction, this.getPullOverflow(direction) + (double)amount);
                if (this.getPullOverflow(direction) >= (double)((FluidStack)extract.method_15442()).amount()) {
                    world.method_8501((class_2338)mut, (class_2680)extract.method_15441());
                    container.insert((FluidStack)extract.method_15442(), false);
                    this.setPullOverflow(direction, 0.0);
                }
            }
        } else {
            this.setPullState(direction, pulledBlockState);
            this.setPullOverflow(direction, 0.0);
        }
    }

    public double getPullOverflow(class_2350 dir) {
        return this.pullOverflow[dir.ordinal()];
    }

    public void setPullOverflow(class_2350 dir, double value) {
        this.pullOverflow[dir.ordinal()] = value;
    }

    public class_2680 getPullState(class_2350 direction) {
        return this.pullState[direction.ordinal()];
    }

    public void setPullState(class_2350 direction, class_2680 state) {
        this.pullState[direction.ordinal()] = state;
    }

    public class_3218 world() {
        return this.world.get();
    }

    public class_2338 pos() {
        return this.pos.get();
    }

    public FluidContainer container() {
        return this.container;
    }

    public void lowerProgress(double amount) {
        for (int i = 0; i < this.pullOverflow.length; ++i) {
            this.pullOverflow[i] = Math.max(0.0, this.pullOverflow[i] - amount);
        }
    }
}

