/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.fluid.world;

import eu.pb4.polyfactory.block.fluids.FluidInput;
import eu.pb4.polyfactory.fluid.FactoryFluids;
import eu.pb4.polyfactory.fluid.FluidBehaviours;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidStack;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3545;

public final class FluidWorldPushInteraction {
    private final double[] pushOverflow = new double[class_2350.values().length];
    private final int[] particleCounter = new int[]{1, 3, 5, 6, 8, 4};
    private final FluidContainer container;
    private final Supplier<class_3218> world;
    private final Supplier<class_2338> pos;
    private final class_2680[] pushState = new class_2680[this.pushOverflow.length];
    private long maxPush = 0L;

    public FluidWorldPushInteraction(FluidContainer container, Supplier<class_3218> world, Supplier<class_2338> pos) {
        this.container = container;
        this.world = world;
        this.pos = pos;
    }

    public void pushFluid(class_2350 direction, double strength) {
        class_2394 particle;
        FluidInstance<?> fluid;
        class_2338 pos = this.pos();
        class_3218 world = this.world();
        FluidContainer container = this.container();
        class_2338.class_2339 mut = this.pos().method_25503().method_10098(direction);
        class_2680 pushedBlockState = world.method_8320((class_2338)mut);
        FluidInput fluidInput = null;
        class_2248 class_22482 = pushedBlockState.method_26204();
        if (class_22482 instanceof FluidInput.Getter) {
            FluidInput.Getter getter = (FluidInput.Getter)class_22482;
            fluidInput = getter.getFluidInput(this.world(), (class_2338)mut, direction.method_10153());
        } else {
            class_22482 = world.method_8321((class_2338)mut);
            if (class_22482 instanceof FluidInput) {
                FluidInput f;
                fluidInput = f = (FluidInput)class_22482;
            }
        }
        if (fluidInput != null) {
            fluid = this.container().topFluid();
            if (fluid != null) {
                long maxFlow = fluid.getMaxFlow(this.world());
                long amount = Math.min(Math.min((long)(strength * (double)maxFlow * fluid.getFlowSpeedMultiplier(world)), maxFlow), this.maxPush());
                long extracted = container.extract(fluid, amount, false);
                long leftover = fluidInput.insertFluid(fluid, extracted, direction.method_10153());
                if (leftover != 0L) {
                    container.insert(fluid, leftover, false);
                }
                this.pushed(extracted - leftover);
                this.setPushOverflow(direction, 0.0);
            }
            return;
        }
        fluid = container.topFluid();
        if (pushedBlockState.method_26215() && fluid != null && fluid.type() == FactoryFluids.EXPERIENCE && container.get(fluid) >= 500L && world.field_9229.method_43056()) {
            int max = (int)Math.min(container.get(fluid) / 500L, 30L);
            int amount = max <= 1 ? 1 : world.field_9229.method_39332(1, max);
            container.extract(fluid, (long)amount * 500L, false);
            class_1303 x = new class_1303((class_1937)world, (double)pos.method_10263() + 0.5 + (double)direction.method_10148() * 0.7, (double)pos.method_10264() + 0.5 + (double)direction.method_10164() * 0.7, (double)pos.method_10260() + 0.5 + (double)direction.method_10165() * 0.7, amount);
            world.method_8649((class_1297)x);
        }
        if (pushedBlockState.method_26215() && this.particleCounter(direction) % 3 == 0 && fluid != null && (particle = fluid.particle()) != null) {
            world.method_65096(particle, (double)pos.method_10263() + 0.5 + (double)direction.method_10148() * 0.55, (double)pos.method_10264() + 0.5 + (double)direction.method_10164() * 0.55, (double)pos.method_10260() + 0.5 + (double)direction.method_10165() * 0.55, 0, (double)direction.method_10148() * 0.1, (double)direction.method_10164() * 0.1, (double)direction.method_10165() * 0.1, 0.4);
        }
        if (pushedBlockState == this.getPushState(direction)) {
            List<class_3545<FluidStack<?>, class_2680>> possibilities = FluidBehaviours.BLOCK_STATE_TO_FLUID_INSERT.get(pushedBlockState);
            if (possibilities != null) {
                for (class_3545<FluidStack<?>, class_2680> insert : possibilities) {
                    if (insert == null || !container.canExtract((FluidStack)insert.method_15442(), true)) continue;
                    long maxFlow = ((FluidStack)insert.method_15442()).instance().getMaxFlow(world);
                    long amount = Math.min(Math.min((long)(strength * (double)maxFlow * ((FluidStack)insert.method_15442()).instance().getFlowSpeedMultiplier(world)), maxFlow), this.maxPush());
                    this.setPushOverflow(direction, this.getPushOverflow(direction) + (double)amount);
                    if (!(this.getPushOverflow(direction) >= (double)((FluidStack)insert.method_15442()).amount())) continue;
                    world.method_8501((class_2338)mut, (class_2680)insert.method_15441());
                    container.extract((FluidStack)insert.method_15442(), false);
                    this.setPushOverflow(direction, 0.0);
                    break;
                }
            }
        } else {
            this.setPushState(direction, pushedBlockState);
            this.setPushOverflow(direction, 0.0);
        }
    }

    public long maxPush() {
        return this.maxPush;
    }

    public void setMaxPush(long maxPush) {
        this.maxPush = maxPush;
    }

    public long pushed(long amount) {
        return this.maxPush -= amount;
    }

    public double getPushOverflow(class_2350 dir) {
        return this.pushOverflow[dir.ordinal()];
    }

    public void setPushOverflow(class_2350 dir, double value) {
        this.pushOverflow[dir.ordinal()] = value;
    }

    public class_2680 getPushState(class_2350 direction) {
        return this.pushState[direction.ordinal()];
    }

    public void setPushState(class_2350 direction, class_2680 state) {
        this.pushState[direction.ordinal()] = state;
    }

    public int particleCounter(class_2350 direction) {
        int n = direction.ordinal();
        int n2 = this.particleCounter[n];
        this.particleCounter[n] = n2 + 1;
        return n2;
    }

    public class_3218 world() {
        return this.world.get();
    }

    public class_2338 pos() {
        return this.pos.get();
    }

    public FluidContainer container() {
        return this.container;
    }

    public void lowerProgress(double amount) {
        for (int i = 0; i < this.pushOverflow.length; ++i) {
            this.pushOverflow[i] = Math.max(0.0, this.pushOverflow[i] - amount);
        }
    }
}

