/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.item.block;

import eu.pb4.factorytools.api.item.FactoryBlockItem;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidContainerFromComponent;
import eu.pb4.polyfactory.fluid.FluidContainerUtil;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidType;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.component.FluidComponent;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.other.FactoryRegistries;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.extras.api.format.item.ItemAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.BasicItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.CompositeItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.EmptyItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.ItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.SelectItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.select.CustomModelDataStringProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.select.SelectProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.tint.CustomModelDataTintSource;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_2970;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class PortableFluidTankBlockItem
extends FactoryBlockItem {
    public <T extends class_2248> PortableFluidTankBlockItem(T block, class_1792.class_1793 settings) {
        super(block, settings);
        class_2315.method_10009((class_1935)this, (class_2357)new class_2970());
    }

    public static void createItemAsset(ResourcePackBuilder builder) {
        class_2960 id = class_7923.field_41178.method_10221((Object)FactoryItems.PORTABLE_FLUID_TANK);
        ArrayList<SelectItemModel.Case> list = new ArrayList<SelectItemModel.Case>();
        for (class_2960 fluidType : FactoryRegistries.FLUID_TYPES.method_10235()) {
            class_2960 modelId = FactoryModels.FLUID_PORTABLE_FLUID_TANK_ITEM.getModelId(fluidType);
            BasicItemModel model = ((FluidType)FactoryRegistries.FLUID_TYPES.method_63535(fluidType)).color().isPresent() ? new BasicItemModel(modelId, List.of(new CustomModelDataTintSource(0, -1))) : new BasicItemModel(modelId);
            list.add(new SelectItemModel.Case(List.of(fluidType.toString()), (ItemModel)model));
        }
        builder.addData(AssetPaths.itemAsset((class_2960)id), new ItemAsset((ItemModel)new CompositeItemModel(List.of(new BasicItemModel(id.method_45138("block/")), new SelectItemModel(new SelectItemModel.Switch((SelectProperty)new CustomModelDataStringProperty(0), list), Optional.of(EmptyItemModel.INSTANCE)))), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
    }

    private FluidInstance<?> getMainFluid(class_1799 itemStack) {
        List<FluidInstance<?>> fluids = ((FluidComponent)itemStack.method_58695(FactoryDataComponents.FLUID, (Object)FluidComponent.DEFAULT)).fluids();
        return fluids.isEmpty() ? null : fluids.getFirst();
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036() != null && context.method_8036().method_5998(context.method_20287() == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808).method_31574((class_1792)FactoryItems.PRESSURE_FLUID_GUN)) {
            return class_1269.field_5811;
        }
        return super.method_7884(context);
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        super.method_7888(stack, world, entity, slot);
        FluidContainerUtil.tick((FluidContainer)FluidContainerFromComponent.of(stack), world, entity.method_73189().method_1031(0.0, entity.method_23318() / 2.0, 0.0), 0.0f, FactoryUtil.getItemConsumer(entity));
    }

    public class_2561 method_7864(class_1799 stack) {
        FluidComponent container = (FluidComponent)stack.method_58695(FactoryDataComponents.FLUID, (Object)FluidComponent.DEFAULT);
        if (container.isEmpty()) {
            return class_2561.method_43471((String)(this.method_7876() + ".empty"));
        }
        if (container.fluids().size() == 1) {
            return class_2561.method_43469((String)(this.method_7876() + ".typed"), (Object[])new Object[]{container.fluids().getFirst().getName()});
        }
        return super.method_7864(stack);
    }

    public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
        class_1799 base = super.getPolymerItemStack(itemStack, tooltipType, context);
        if (itemStack.method_57826(FactoryDataComponents.FLUID)) {
            FluidInstance<?> x;
            FluidComponent fluids = (FluidComponent)itemStack.method_58694(FactoryDataComponents.FLUID);
            if (fluids != null && fluids.capacity() != -1L) {
                base.method_57379(class_9334.field_50072, (Object)((int)(fluids.capacity() / 100L)));
                base.method_57379(class_9334.field_49629, (Object)((int)((fluids.capacity() - fluids.stored()) / 100L)));
            }
            if ((x = this.getMainFluid(itemStack)) != null && x.type().color().isPresent()) {
                base.method_57379(class_9334.field_49637, (Object)new class_9280(List.of(), List.of(), List.of(FactoryRegistries.FLUID_TYPES.method_10221(x.type()).toString()), (List)IntList.of((int)x.type().color().get().getColor(x.data()))));
            } else if (x != null) {
                base.method_57379(class_9334.field_49637, (Object)new class_9280(List.of(), List.of(), List.of(FactoryRegistries.FLUID_TYPES.method_10221(x.type()).toString()), (List)IntList.of()));
            } else {
                base.method_57379(class_9334.field_49637, (Object)new class_9280(List.of(), List.of(), List.of(), (List)IntList.of()));
            }
        }
        return base;
    }
}

