/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.item.configuration;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.configurable.BlockConfig;
import eu.pb4.polyfactory.block.configurable.ConfigurableBlock;
import eu.pb4.polyfactory.entity.configurable.ConfigurableEntity;
import eu.pb4.polyfactory.entity.configurable.EntityConfig;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.configuration.ConfigurationData;
import eu.pb4.polyfactory.other.FactorySoundEvents;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.UiResourceCreator;
import eu.pb4.polyfactory.util.ServerPlayNetExt;
import eu.pb4.sidebars.api.Sidebar;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_9020;
import net.minecraft.class_9022;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class WrenchHandler {
    private final Sidebar sidebar = new Sidebar(Sidebar.Priority.HIGH);
    private final Map<Object, String> currentAction = new Reference2ObjectOpenHashMap();
    private class_2680 state = class_2246.field_10124.method_9564();
    @Nullable
    private class_2338 pos;
    @Nullable
    private class_1297 entity;
    private List<BlockConfig<?>> blockActions = List.of();
    private List<? extends EntityConfig<?, ?>> entityActions = List.of();
    private class_1799 currentStack = class_1799.field_8037;

    public WrenchHandler(class_3244 handler) {
        this.sidebar.addPlayer(handler);
        this.sidebar.setDefaultNumberFormat((class_9022)class_9020.field_47557);
    }

    public static WrenchHandler of(class_3222 player) {
        return ((ServerPlayNetExt)player.field_13987).polyFactory$getWrenchHandler();
    }

    public void tickDisplay(class_3222 player) {
        class_1799 stack = class_1799.field_8037;
        if (player.method_6047().method_31574((class_1792)FactoryItems.WRENCH) || player.method_6047().method_31574(FactoryItems.CLIPBOARD)) {
            stack = player.method_6047();
        } else if (player.method_6079().method_31574((class_1792)FactoryItems.WRENCH) || player.method_6079().method_31574(FactoryItems.CLIPBOARD)) {
            stack = player.method_6079();
        }
        if (stack.method_7960()) {
            this.entity = null;
            this.state = class_2246.field_10124.method_9564();
            this.pos = null;
            this.sidebar.hide();
            return;
        }
        boolean isWrench = stack.method_31574((class_1792)FactoryItems.WRENCH);
        class_239 hitResult = WrenchHandler.getTarget(player);
        if (hitResult.method_17783() == class_239.class_240.field_1333) {
            this.entity = null;
            this.state = class_2246.field_10124.method_9564();
            this.pos = null;
            this.sidebar.hide();
        } else if (hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            this.entity = null;
            this.entityActions = List.of();
            class_2680 state = player.method_51469().method_8320(blockHitResult.method_17777());
            if (state == this.state && blockHitResult.method_17777().equals((Object)this.pos) && class_1799.method_31577((class_1799)stack, (class_1799)this.currentStack)) {
                class_2248 class_22482 = this.state.method_26204();
                if (class_22482 instanceof ConfigurableBlock) {
                    ConfigurableBlock configurableBlock = (ConfigurableBlock)class_22482;
                    if (isWrench) {
                        configurableBlock.wrenchTick(player, blockHitResult, this.state);
                    }
                }
                return;
            }
            this.currentStack = stack.method_7972();
            this.state = state;
            this.pos = blockHitResult.method_17777();
            class_2248 class_22483 = this.state.method_26204();
            if (class_22483 instanceof ConfigurableBlock) {
                ConfigurableBlock configurableBlock = (ConfigurableBlock)class_22483;
                if (isWrench) {
                    configurableBlock.wrenchTick(player, blockHitResult, this.state);
                }
                this.blockActions = configurableBlock.getBlockConfiguration(player, blockHitResult.method_17777(), blockHitResult.method_17780(), this.state);
                String selected = this.currentAction.get(this.state.method_26204());
                HashMap<String, Object> diffMap = new HashMap<String, Object>();
                if (stack.method_57826(FactoryDataComponents.CONFIGURATION_DATA)) {
                    for (BlockConfig<?> config : this.blockActions) {
                        for (ConfigurationData.Entry entry : ((ConfigurationData)stack.method_58695(FactoryDataComponents.CONFIGURATION_DATA, (Object)ConfigurationData.EMPTY)).entries()) {
                            DataResult decoded;
                            if (!config.id().equals(entry.id()) || !(decoded = config.codec().decode((DynamicOps)JavaOps.INSTANCE, entry.value())).isSuccess()) continue;
                            diffMap.put(config.id(), ((Pair)decoded.getOrThrow()).getFirst());
                        }
                    }
                }
                this.sidebar.setTitle((class_2561)class_2561.method_43469((String)"item.polyfactory.wrench.title", (Object[])new Object[]{class_2561.method_43473()}).method_10862(class_2583.field_24360.method_10977(class_124.field_1065).method_10982(Boolean.valueOf(true))));
                try {
                    this.sidebar.set(b -> {
                        int size = Math.min(this.blockActions.size(), 15);
                        for (int i = 0; i < size; ++i) {
                            BlockConfig<?> action = this.blockActions.get(i);
                            class_5250 t = class_2561.method_43473();
                            if (isWrench) {
                                if (selected == null && i == 0 || action.id().equals(selected)) {
                                    t.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(GuiTextures.SPACE_1)).method_10862(UiResourceCreator.STYLE));
                                    t.method_10852((class_2561)class_2561.method_43470((String)"\u00bb ").method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
                                } else {
                                    t.method_27693("   ");
                                }
                            }
                            t.method_10852(action.name()).method_27693(": ");
                            Object value = action.value().getValue((class_1937)player.method_51469(), blockHitResult.method_17777(), blockHitResult.method_17780(), state);
                            class_2561 valueFrom = action.formatter().getDisplayValue(value, (class_1937)player.method_51469(), blockHitResult.method_17777(), blockHitResult.method_17780(), state);
                            if (isWrench) {
                                b.add((class_2561)t, (class_2561)class_2561.method_43473().method_10852(valueFrom).method_27692(class_124.field_1054));
                                continue;
                            }
                            if (diffMap.containsKey(action.id()) && !Objects.equals(diffMap.get(action.id()), value)) {
                                class_2561 diff = action.formatter().getDisplayValue(diffMap.get(action.id()), (class_1937)player.method_51469(), blockHitResult.method_17777(), blockHitResult.method_17780(), state);
                                b.add((class_2561)t, (class_2561)class_2561.method_43473().method_10852(valueFrom).method_10852((class_2561)class_2561.method_43470((String)" -> ").method_27692(class_124.field_1065)).method_10852(diff).method_27692(class_124.field_1054));
                                continue;
                            }
                            b.add((class_2561)t.method_27692(class_124.field_1080), (class_2561)class_2561.method_43473().method_10852(valueFrom).method_54663(class_9848.method_61321((int)class_124.field_1054.method_532(), (float)0.7f)));
                        }
                    });
                }
                catch (Throwable e) {
                    ModInit.LOGGER.error("Failed to create wrench display!", e);
                }
                this.sidebar.show();
            } else {
                this.blockActions = List.of();
                this.sidebar.hide();
            }
        } else if (hitResult instanceof class_3966) {
            class_3966 entityHitResult = (class_3966)hitResult;
            this.state = class_2246.field_10124.method_9564();
            this.pos = null;
            if (this.entity == entityHitResult.method_17782() && class_1799.method_31577((class_1799)stack, (class_1799)this.currentStack)) {
                class_1297 configurableBlock = this.entity;
                if (configurableBlock instanceof ConfigurableEntity) {
                    ConfigurableEntity configurableEntity = (ConfigurableEntity)configurableBlock;
                    if (isWrench) {
                        configurableEntity.wrenchTick(player, entityHitResult.method_17784());
                    }
                }
                return;
            }
            this.currentStack = stack.method_7972();
            this.entity = entityHitResult.method_17782();
            class_1297 configurableBlock = this.entity;
            if (configurableBlock instanceof ConfigurableEntity) {
                ConfigurableEntity configurableEntity = (ConfigurableEntity)configurableBlock;
                if (isWrench) {
                    configurableEntity.wrenchTick(player, entityHitResult.method_17784());
                }
                this.entityActions = configurableEntity.getEntityConfiguration(player, entityHitResult.method_17784());
                String selected = this.currentAction.get(this.entity.method_5864());
                HashMap<String, Object> diffMap = new HashMap<String, Object>();
                if (stack.method_57826(FactoryDataComponents.CONFIGURATION_DATA)) {
                    for (EntityConfig<?, ?> config : this.entityActions) {
                        for (ConfigurationData.Entry entry : ((ConfigurationData)stack.method_58695(FactoryDataComponents.CONFIGURATION_DATA, (Object)ConfigurationData.EMPTY)).entries()) {
                            DataResult decoded;
                            if (!config.id().equals(entry.id()) || !(decoded = config.codec().decode((DynamicOps)JavaOps.INSTANCE, entry.value())).isSuccess()) continue;
                            diffMap.put(config.id(), ((Pair)decoded.getOrThrow()).getFirst());
                        }
                    }
                }
                this.sidebar.setTitle((class_2561)class_2561.method_43469((String)"item.polyfactory.wrench.title", (Object[])new Object[]{class_2561.method_43473()}).method_10862(class_2583.field_24360.method_10977(class_124.field_1065).method_10982(Boolean.valueOf(true))));
                try {
                    this.sidebar.set(b -> {
                        int size = Math.min(this.entityActions.size(), 15);
                        for (int i = 0; i < size; ++i) {
                            EntityConfig<?, ?> action = this.entityActions.get(i);
                            class_5250 t = class_2561.method_43473();
                            if (isWrench) {
                                if (selected == null && i == 0 || action.id().equals(selected)) {
                                    t.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(GuiTextures.SPACE_1)).method_10862(UiResourceCreator.STYLE));
                                    t.method_10852((class_2561)class_2561.method_43470((String)"\u00bb ").method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
                                } else {
                                    t.method_27693("   ");
                                }
                            }
                            t.method_10852(action.name()).method_27693(": ");
                            Object value = action.value().getValue(this.entity, entityHitResult.method_17784());
                            class_2561 valueFrom = action.formatter().getDisplayValue(value, this.entity, entityHitResult.method_17784());
                            if (isWrench) {
                                b.add((class_2561)t, (class_2561)class_2561.method_43473().method_10852(valueFrom).method_27692(class_124.field_1054));
                                continue;
                            }
                            if (diffMap.containsKey(action.id()) && !Objects.equals(diffMap.get(action.id()), value)) {
                                class_2561 diff = action.formatter().getDisplayValue(diffMap.get(action.id()), this.entity, entityHitResult.method_17784());
                                b.add((class_2561)t, (class_2561)class_2561.method_43473().method_10852(valueFrom).method_10852((class_2561)class_2561.method_43470((String)" -> ").method_27692(class_124.field_1065)).method_10852(diff).method_27692(class_124.field_1054));
                                continue;
                            }
                            b.add((class_2561)t.method_27692(class_124.field_1080), (class_2561)class_2561.method_43473().method_10852(valueFrom).method_54663(class_9848.method_61321((int)class_124.field_1054.method_532(), (float)0.7f)));
                        }
                    });
                }
                catch (Throwable e) {
                    ModInit.LOGGER.error("Failed to create wrench display!", e);
                }
                this.sidebar.show();
            } else {
                this.entityActions = List.of();
                this.sidebar.hide();
            }
        }
    }

    public static class_239 getTarget(class_3222 camera) {
        return WrenchHandler.findCrosshairTarget((class_1297)camera, camera.method_55754(), camera.method_55755(), 0.0f);
    }

    private static class_239 findCrosshairTarget(class_1297 camera, double blockInteractionRange, double entityInteractionRange, float tickProgress) {
        class_238 cameraBox;
        double maxRange = Math.max(blockInteractionRange, entityInteractionRange);
        double sqrMaxRange = class_3532.method_33723((double)maxRange);
        class_243 vec3d = camera.method_5836(tickProgress);
        class_239 hitResult = camera.method_5745(maxRange, tickProgress, false);
        double squaredDistanceToBlock = hitResult.method_17784().method_1025(vec3d);
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            sqrMaxRange = squaredDistanceToBlock;
            maxRange = Math.sqrt(squaredDistanceToBlock);
        }
        class_243 rotation = camera.method_5828(tickProgress);
        class_243 endPos = vec3d.method_1031(rotation.field_1352 * maxRange, rotation.field_1351 * maxRange, rotation.field_1350 * maxRange);
        class_3966 entityHitResult = class_1675.method_18075((class_1297)camera, (class_243)vec3d, (class_243)endPos, (class_238)(cameraBox = camera.method_5829().method_18804(rotation.method_1021(maxRange)).method_1009(1.0, 1.0, 1.0)), (Predicate)class_1301.field_52443, (double)sqrMaxRange);
        return entityHitResult != null && entityHitResult.method_17784().method_1025(vec3d) < squaredDistanceToBlock ? WrenchHandler.ensureTargetInRange((class_239)entityHitResult, vec3d, entityInteractionRange) : WrenchHandler.ensureTargetInRange(hitResult, vec3d, blockInteractionRange);
    }

    private static class_239 ensureTargetInRange(class_239 hitResult, class_243 cameraPos, double interactionRange) {
        class_243 pos = hitResult.method_17784();
        if (!pos.method_24802((class_2374)cameraPos, interactionRange)) {
            class_243 hitPos = hitResult.method_17784();
            class_2350 direction = class_2350.method_10142((double)(hitPos.field_1352 - cameraPos.field_1352), (double)(hitPos.field_1351 - cameraPos.field_1351), (double)(hitPos.field_1350 - cameraPos.field_1350));
            return class_3965.method_17778((class_243)hitPos, (class_2350)direction, (class_2338)class_2338.method_49638((class_2374)hitPos));
        }
        return hitResult;
    }

    public class_1269 useBlockAction(class_3222 player, class_1937 world, class_2338 pos, class_2350 side, boolean alt) {
        class_2680 state = world.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof ConfigurableBlock)) {
            return class_1269.field_5811;
        }
        ConfigurableBlock configurableBlock = (ConfigurableBlock)class_22482;
        List<BlockConfig<?>> actions = configurableBlock.getBlockConfiguration(player, pos, side, this.state);
        if (actions.isEmpty()) {
            return class_1269.field_5811;
        }
        String current = this.currentAction.get(state.method_26204());
        if (current == null) {
            current = actions.get(0).id();
        }
        for (BlockConfig<?> act : actions) {
            BlockConfig<?> action = act;
            if (!action.id().equals(current)) continue;
            Object newValue = (alt ? action.alt() : action.action()).modifyValue(action.value().getValue(world, pos, side, state), !player.method_5715(), (class_1657)player, world, pos, side, state);
            if (action.value().setValue(newValue, world, pos, side, state)) {
                this.pos = null;
                TriggerCriterion.trigger((class_3222)player, (class_2960)FactoryTriggers.WRENCH);
                player.method_17356(FactorySoundEvents.ITEM_WRENCH_USE, class_3419.field_15248, 0.3f, player.method_59922().method_43057() * 0.1f + 0.95f);
                return class_1269.field_52422;
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public void attackBlockAction(class_3222 player, class_1937 world, class_2338 pos, class_2350 side) {
        class_2680 state = world.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof ConfigurableBlock)) {
            return;
        }
        ConfigurableBlock configurableBlock = (ConfigurableBlock)class_22482;
        List<BlockConfig<?>> actions = configurableBlock.getBlockConfiguration(player, pos, side, this.state);
        if (actions.isEmpty()) {
            return;
        }
        String current = this.currentAction.get(state.method_26204());
        if (current == null) {
            current = actions.getFirst().id();
        }
        boolean foundCurrent = false;
        String nextAction = actions.getFirst().id();
        String previousAction = actions.getLast().id();
        for (BlockConfig<?> action : actions) {
            if (foundCurrent) {
                nextAction = action.id();
                break;
            }
            if (action.id().equals(current)) {
                foundCurrent = true;
                continue;
            }
            previousAction = action.id();
        }
        if (foundCurrent) {
            this.currentAction.put(state.method_26204(), player.method_5715() ? previousAction : nextAction);
            player.method_17356(FactorySoundEvents.ITEM_WRENCH_SWITCH, class_3419.field_15248, 0.3f, 1.0f);
            this.pos = null;
        }
    }

    public class_1269 useEntityAction(class_3222 player, class_1297 entity, class_243 pos, boolean alt) {
        if (!(entity instanceof ConfigurableEntity)) {
            return class_1269.field_5811;
        }
        ConfigurableEntity configurableEntity = (ConfigurableEntity)entity;
        List actions = configurableEntity.getEntityConfiguration(player, pos);
        if (actions.isEmpty()) {
            return class_1269.field_5811;
        }
        String current = this.currentAction.get(entity.method_5864());
        if (current == null) {
            current = actions.get(0).id();
        }
        for (EntityConfig act : actions) {
            EntityConfig action = act;
            if (!action.id().equals(current)) continue;
            Object newValue = (alt ? action.alt() : action.action()).modifyValue(action.value().getValue(entity, pos), !player.method_5715(), (class_1657)player, entity, pos);
            if (action.value().setValue(newValue, entity, pos)) {
                this.entity = null;
                TriggerCriterion.trigger((class_3222)player, (class_2960)FactoryTriggers.WRENCH);
                player.method_17356(FactorySoundEvents.ITEM_WRENCH_USE, class_3419.field_15248, 0.3f, player.method_59922().method_43057() * 0.1f + 0.95f);
                return class_1269.field_52422;
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5814;
    }

    public void attackEntityAction(class_3222 player, class_1297 entity, class_243 pos) {
        if (!(entity instanceof ConfigurableEntity)) {
            return;
        }
        ConfigurableEntity configurableEntity = (ConfigurableEntity)entity;
        List actions = configurableEntity.getEntityConfiguration(player, pos);
        if (actions.isEmpty()) {
            return;
        }
        String current = this.currentAction.get(entity.method_5864());
        if (current == null) {
            current = actions.getFirst().id();
        }
        boolean foundCurrent = false;
        String nextAction = actions.getFirst().id();
        String previousAction = actions.getLast().id();
        for (EntityConfig action : actions) {
            if (foundCurrent) {
                nextAction = action.id();
                break;
            }
            if (action.id().equals(current)) {
                foundCurrent = true;
                continue;
            }
            previousAction = action.id();
        }
        if (foundCurrent) {
            this.currentAction.put(entity.method_5864(), player.method_5715() ? previousAction : nextAction);
            player.method_17356(FactorySoundEvents.ITEM_WRENCH_SWITCH, class_3419.field_15248, 0.3f, 1.0f);
            this.entity = null;
        }
    }
}

