/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.mixin.machines;

import eu.pb4.polyfactory.block.other.CustomBlockEntityCalls;
import eu.pb4.polyfactory.block.other.FilteredBlockEntity;
import eu.pb4.polyfactory.models.HopperModel;
import eu.pb4.polyfactory.util.filter.FilterData;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.ChunkAttachment;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2614.class})
public abstract class HopperBlockEntityMixin
extends class_2621
implements FilteredBlockEntity,
CustomBlockEntityCalls {
    @Unique
    private class_1799 filterStack = class_1799.field_8037;
    @Unique
    private FilterData filter = FilterData.EMPTY_TRUE;
    @Unique
    @Nullable
    private HopperModel model;

    protected HopperBlockEntityMixin(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Inject(method={"writeData"}, at={@At(value="TAIL")})
    private void writeFilterNbt(class_11372 view, CallbackInfo ci) {
        if (!this.filterStack.method_7960()) {
            view.method_71468("polyfactory:filter", class_1799.field_24671, (Object)this.filterStack);
        }
    }

    @Inject(method={"readData"}, at={@At(value="TAIL")})
    private void readFilterNbt(class_11368 view, CallbackInfo ci) {
        this.polyfactory$setFilter(view.method_71426("polyfactory:filter", class_1799.field_49266).orElse(view.method_71426("polydex:filter", class_1799.field_49266).orElse(class_1799.field_8037)));
    }

    @Inject(method={"transfer(Lnet/minecraft/inventory/Inventory;Lnet/minecraft/inventory/Inventory;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/math/Direction;)Lnet/minecraft/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void cancelUnfiltered(class_1263 from, class_1263 to, class_1799 stack, class_2350 side, CallbackInfoReturnable<class_1799> cir) {
        FilteredBlockEntity filteredHopper;
        if (to instanceof FilteredBlockEntity && !(filteredHopper = (FilteredBlockEntity)to).polyfactory$matchesFilter(stack)) {
            cir.setReturnValue((Object)stack);
        }
    }

    @Inject(method={"canExtract"}, at={@At(value="HEAD")}, cancellable=true)
    private static void cancelUnfiltered2(class_1263 hopperInventory, class_1263 fromInventory, class_1799 stack, int slot, class_2350 facing, CallbackInfoReturnable<Boolean> cir) {
        FilteredBlockEntity filteredHopper;
        if (hopperInventory instanceof FilteredBlockEntity && !(filteredHopper = (FilteredBlockEntity)hopperInventory).polyfactory$matchesFilter(stack)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"serverTick"}, at={@At(value="HEAD")})
    private static void setupModel(class_1937 world, class_2338 pos, class_2680 state, class_2614 blockEntity, CallbackInfo ci) {
        HopperBlockEntityMixin self = (HopperBlockEntityMixin)blockEntity;
        if (self.model == null && !self.filterStack.method_7960()) {
            self.createModel();
        }
    }

    @Override
    public void polyfactory$markRemoved() {
        if (this.model != null) {
            this.model.destroy();
            this.model = null;
        }
    }

    @Override
    public void polyfactory$setCachedState(class_2680 state) {
        if (this.model != null) {
            this.model.updateRotation(state);
        }
    }

    @Override
    public class_1799 polyfactory$getFilter() {
        return this.filterStack;
    }

    @Override
    public void polyfactory$setFilter(class_1799 stack) {
        this.filterStack = stack;
        this.filter = FilterData.of(stack, true);
        if (this.model == null && !this.filterStack.method_7960()) {
            this.createModel();
        } else if (this.model != null && this.filterStack.method_7960()) {
            this.model.destroy();
            this.model = null;
        } else if (this.model != null) {
            this.model.setFilter(this.filter);
            this.model.tick();
        }
        this.method_5431();
    }

    @Unique
    private void createModel() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        HopperModel model = new HopperModel(this.method_11010());
        model.setFilter(this.filter);
        ChunkAttachment.of((ElementHolder)model, (class_3218)serverWorld, (class_2338)this.field_11867);
        this.model = model;
    }

    @Override
    public boolean polyfactory$matchesFilter(class_1799 itemStack) {
        return this.filter.test(itemStack);
    }
}

