/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.mixin.machines;

import eu.pb4.factorytools.api.block.MultiBlock;
import eu.pb4.polyfactory.block.FactoryBlocks;
import eu.pb4.polyfactory.block.data.DataProvider;
import eu.pb4.polyfactory.block.data.output.GaugeBlock;
import eu.pb4.polyfactory.block.data.providers.DataProviderBlock;
import eu.pb4.polyfactory.block.other.FilledStateProvider;
import eu.pb4.polyfactory.data.CapacityData;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5000;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1937.class})
public abstract class WorldMixin
implements class_1936 {
    @Shadow
    public abstract class_2680 method_8320(class_2338 var1);

    @Shadow
    @Nullable
    public abstract class_2586 method_8321(class_2338 var1);

    @Shadow
    public abstract boolean method_8652(class_2338 var1, class_2680 var2, int var3);

    @Inject(method={"updateComparators"}, at={@At(value="HEAD")})
    private void polyfactory$onComparatorUpdate(class_2338 pos, class_2248 block, CallbackInfo ci) {
        WorldMixin worldMixin = this;
        if (worldMixin instanceof class_3218) {
            class_3218 world = (class_3218)worldMixin;
            this.updateItemCounter(world, pos);
        }
    }

    @Unique
    private void updateItemCounter(class_3218 world, class_2338 pos) {
        long count = 0L;
        long max = 0L;
        class_2338 originalPos = pos;
        class_2680 state = world.method_8320(pos);
        class_2350[] class_2350Array = state.method_26204();
        if (class_2350Array instanceof MultiBlock) {
            MultiBlock multiBlock = (MultiBlock)class_2350Array;
            pos = multiBlock.getCenter(state, pos);
        }
        if ((class_2350Array = world.method_8321(pos)) instanceof FilledStateProvider) {
            FilledStateProvider provider = (FilledStateProvider)class_2350Array;
            count = provider.getFilledAmount();
            max = provider.getFillCapacity();
        } else {
            Storage storage = (Storage)ItemStorage.SIDED.find((class_1937)world, pos, null);
            if (storage == null) {
                return;
            }
            for (StorageView x : storage) {
                count += x.getAmount();
                max += x.getCapacity();
            }
        }
        CapacityData data = new CapacityData(count, max);
        for (class_2350 dir : class_2350.values()) {
            class_2338 selfPos = originalPos.method_10093(dir);
            if (!this.method_8393(class_4076.method_18675((int)selfPos.method_10263()), class_4076.method_18675((int)selfPos.method_10260()))) continue;
            class_2680 selfState = this.method_8320(selfPos);
            if (selfState.method_27852((class_2248)FactoryBlocks.ITEM_COUNTER) && selfState.method_11654((class_2769)DataProviderBlock.FACING) == dir.method_10153()) {
                DataProvider.sendData((class_4538)world, selfPos, data);
                continue;
            }
            if (!selfState.method_27852((class_2248)FactoryBlocks.GAUGE) || ((class_5000)selfState.method_11654(GaugeBlock.ORIENTATION)).method_26426() != dir) continue;
            FactoryBlocks.GAUGE.receiveData(world, selfPos, selfState, -2, data, null, originalPos, null);
        }
    }
}

