/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.models;

import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import net.minecraft.class_10182;
import net.minecraft.class_10264;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2684;
import net.minecraft.class_3244;
import net.minecraft.class_811;

public class ChainItemDisplayElement
extends LodItemDisplayElement {
    private int updateTick;
    private class_243 lastSyncedPosMid;
    private boolean forceSync = false;
    private boolean forceSyncMid = false;
    private final class_243 start;
    private final class_243 middle;
    private final class_243 end;

    private ChainItemDisplayElement(class_243 start, class_243 middle, class_243 end) {
        this.start = start;
        this.middle = middle;
        this.end = end;
        this.addLodData(DisplayTrackedData.TELEPORTATION_DURATION);
    }

    public void forceSync() {
        this.forceSync = true;
        this.forceSyncMid = true;
    }

    protected void sendPositionUpdates() {
        if (this.getHolder() == null) {
            return;
        }
        class_2596 nearPacket = null;
        class_2596 mediumPacket = null;
        class_243 pos = this.getCurrentPos();
        if (!pos.equals((Object)this.lastSyncedPos)) {
            if (this.lastSyncedPos == null || this.forceSync) {
                nearPacket = new class_10264(this.getEntityId(), new class_10182(pos, class_243.field_1353, this.getYaw(), this.getPitch()), false);
                this.forceSync = false;
            } else {
                nearPacket = VirtualEntityUtils.createMovePacket((int)this.getEntityId(), (class_243)this.lastSyncedPos, (class_243)pos, (boolean)this.isRotationDirty(), (float)this.getYaw(), (float)this.getPitch());
            }
            if (!(nearPacket instanceof class_2684.class_2687)) {
                this.lastSyncedPos = pos;
            }
        }
        if (this.farDistanceSquared != 0.0f && !pos.equals((Object)this.lastSyncedPosMid) && this.updateTick++ % 10 == 0) {
            if (this.lastSyncedPosMid == null || this.forceSyncMid) {
                mediumPacket = new class_10264(this.getEntityId(), new class_10182(pos, class_243.field_1353, this.getYaw(), this.getPitch()), false);
                this.forceSyncMid = false;
            } else {
                mediumPacket = VirtualEntityUtils.createMovePacket((int)this.getEntityId(), (class_243)this.lastSyncedPosMid, (class_243)pos, (boolean)this.isRotationDirty(), (float)this.getYaw(), (float)this.getPitch());
            }
            if (!(nearPacket instanceof class_2684.class_2687)) {
                this.lastSyncedPosMid = pos;
            }
        }
        if (nearPacket == null && mediumPacket == null) {
            return;
        }
        for (class_3244 player : this.getHolder().getWatchingPlayers()) {
            double d = this.getSquaredDistance(player);
            if (d < this.nearDistanceSquared) {
                if (nearPacket == null) continue;
                player.method_14364(nearPacket);
                continue;
            }
            if (!(d < (double)this.farDistanceSquared) || mediumPacket == null) continue;
            player.method_14364(mediumPacket);
        }
    }

    protected double getSquaredDistance(class_3244 player) {
        class_243 pos = player.field_14140.method_73189();
        return Math.min(this.middle.method_1025(pos), Math.min(this.start.method_1025(pos), this.end.method_1025(pos)));
    }

    public static ChainItemDisplayElement create(class_1799 model, int updateRate, class_243 start, class_243 middle, class_243 end) {
        ChainItemDisplayElement element = new ChainItemDisplayElement(start, middle, end);
        element.setDisplaySize(2.0f, 2.0f);
        element.setViewRange(0.8f);
        element.setItemDisplayContext(class_811.field_4319);
        element.setTeleportDuration(updateRate);
        element.setInterpolationDuration(updateRate);
        element.setInvisible(true);
        element.setItem(model);
        element.nearDistanceSquared = 784.0;
        element.farDistanceSquared = 0.0f;
        return element;
    }
}

