/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.models.fluid;

import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidType;
import eu.pb4.polyfactory.other.FactoryRegistries;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.ModelRenderType;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.extras.api.ResourcePackExtras;
import eu.pb4.polymer.resourcepack.extras.api.format.item.ItemAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.BasicItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.ItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.tint.CustomModelDataTintSource;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class FluidModel {
    private static final String BASE_MODEL = "{\n  \"parent\": \"|BASE|\",\n  \"textures\": {\n    \"texture\": \"|ID|\"\n  }\n}\n".replace(" ", "").replace("\n", "");
    protected final class_2960 baseModel;
    protected final List<Texture> textures = new ArrayList<Texture>();
    protected final Map<FluidType<?>, class_1799> model = new IdentityHashMap();
    private final Function<ModelRenderType, class_1792> function;
    protected boolean alwaysColored;

    public FluidModel(class_2960 model) {
        this(model, FactoryUtil::requestModelBase);
    }

    public FluidModel(class_2960 model, Function<ModelRenderType, class_1792> function) {
        this(model, function, false);
    }

    public FluidModel(class_2960 model, Function<ModelRenderType, class_1792> function, boolean alwaysColored) {
        this.baseModel = model;
        this.alwaysColored = alwaysColored;
        this.function = function;
        this.runStuff();
    }

    protected void runStuff() {
        for (class_2960 fluid : FactoryRegistries.FLUID_TYPES.method_10235()) {
            this.handleFluidTexture(fluid, Objects.requireNonNull((FluidType)FactoryRegistries.FLUID_TYPES.method_63535(fluid)), this.function);
        }
        RegistryEntryAddedCallback.event(FactoryRegistries.FLUID_TYPES).register((rawId, id, object) -> this.handleFluidTexture(id, (FluidType<?>)object, this.function));
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(b -> this.generateAssets((arg_0, arg_1) -> ((ResourcePackBuilder)b).addData(arg_0, arg_1)));
    }

    protected void handleFluidTexture(class_2960 id, FluidType<?> fluidType, Function<ModelRenderType, class_1792> function) {
        this.addTextures(id, fluidType, function);
    }

    public <T> class_1799 get(FluidType<T> fluid, T data) {
        class_1799 stack = this.model.getOrDefault(fluid, class_1799.field_8037);
        if (fluid.color().isEmpty() && !this.alwaysColored) {
            return stack;
        }
        stack = stack.method_7972();
        stack.method_57379(class_9334.field_49637, (Object)new class_9280(List.of(), List.of(), List.of(), (List)IntList.of((int)fluid.color().get().getColor(data))));
        return stack;
    }

    public <T> class_1799 get(@Nullable FluidInstance<T> type) {
        if (type == null) {
            return class_1799.field_8037;
        }
        return this.get(type.type(), type.data());
    }

    protected void addTextures(class_2960 id, FluidType<?> object, Function<ModelRenderType, class_1792> function) {
        this.textures.add(new Texture(id, object.texture(), object.color().isPresent() || this.alwaysColored));
        class_1799 stack = new class_1799((class_1935)function.apply(this.alwaysColored ? ModelRenderType.COLORED : object.modelRenderType()));
        stack.method_57379(class_9334.field_54199, (Object)ResourcePackExtras.bridgeModelNoItem((class_2960)this.baseModel.method_48331("/" + id.method_12836() + "/" + id.method_12832())));
        this.model.put(object, stack);
    }

    protected void generateAssets(BiConsumer<String, byte[]> assetWriter) {
        for (Texture fluid : this.textures) {
            class_2960 modelId = ResourcePackExtras.bridgeModelNoItem((class_2960)this.baseModel.method_48331("/" + fluid.id().method_12836() + "/" + fluid.id().method_12832()));
            assetWriter.accept(AssetPaths.model((class_2960)modelId) + ".json", BASE_MODEL.replace("|BASE|", this.baseModel.toString()).replace("|ID|", fluid.texture().toString()).getBytes(StandardCharsets.UTF_8));
            if (fluid.colored || this.alwaysColored) {
                assetWriter.accept(AssetPaths.itemAsset((class_2960)modelId), new ItemAsset((ItemModel)new BasicItemModel(modelId, List.of(new CustomModelDataTintSource(0, -1))), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
                continue;
            }
            assetWriter.accept(AssetPaths.itemAsset((class_2960)modelId), new ItemAsset((ItemModel)new BasicItemModel(modelId), ItemAsset.Properties.DEFAULT).toJson().getBytes(StandardCharsets.UTF_8));
        }
    }

    public class_1799 getRaw(FluidInstance<?> x) {
        return this.model.get(x.type());
    }

    public class_2960 getModelId(class_2960 type) {
        return ResourcePackExtras.bridgeModelNoItem((class_2960)this.baseModel.method_48331("/" + type.method_12836() + "/" + type.method_12832()));
    }

    protected record Texture(class_2960 id, class_2960 texture, boolean colored) {
    }
}

