/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.models.fluid;

import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import net.minecraft.class_1799;
import net.minecraft.class_8104;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TopFluidViewModel
extends RotationAwareModel {
    private final ItemDisplayElement fluid = ItemDisplayElementUtil.createSimple();
    private final float startOffset;
    private final float maxHeight;
    private FluidInstance<?> currentFluid = null;
    private float positionFluid = -1.0f;

    public TopFluidViewModel(ElementHolder holder, float startOffset, float maxHeight, float viewRange) {
        this.fluid.setViewRange(viewRange);
        this.startOffset = startOffset;
        this.maxHeight = maxHeight;
        holder.addElement((VirtualElement)this.fluid);
    }

    public void destroy() {
        if (this.fluid.getHolder() != null) {
            this.fluid.getHolder().removeElement((VirtualElement)this.fluid);
        }
    }

    public ItemDisplayElement fluidDisplay() {
        return this.fluid;
    }

    public void setFluid(@Nullable FluidInstance<?> type, float position) {
        if (type == null || (double)position < 0.01) {
            this.fluid.setItem(class_1799.field_8037);
            this.currentFluid = null;
            this.positionFluid = -1.0f;
        }
        if (this.currentFluid != type) {
            this.fluid.setItem(FactoryModels.FLUID_FLAT_FULL.get(type));
            this.fluid.setBrightness((class_8104)type.brightness().orElse(null));
            this.currentFluid = type;
        }
        if (this.positionFluid != position) {
            this.fluid.setTranslation((Vector3fc)new Vector3f(0.0f, this.startOffset + position * this.maxHeight, 0.0f));
            this.positionFluid = position;
        }
    }
}

