/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.nodes.electric;

import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphEntityContext;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.GraphEntity;
import com.kneelawk.graphlib.api.graph.user.GraphEntityType;
import com.mojang.serialization.Codec;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.block.electric.EnergyUser;
import eu.pb4.polyfactory.nodes.generic.FunctionalDirectionNode;
import eu.pb4.polyfactory.nodes.generic.FunctionalNode;
import java.util.Collection;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

public class EnergyData
implements GraphEntity<EnergyData> {
    public static EnergyData EMPTY = new EnergyData(){

        @Override
        public void update(class_3218 world, BlockGraph graph) {
        }
    };
    public static final GraphEntityType<EnergyData> TYPE = GraphEntityType.of((class_2960)ModInit.id("energy_info"), (Codec)Codec.unit(EnergyData::new), EnergyData::new, EnergyData::split);
    private long speed;
    private int lastTick = -1;
    private long stressCapacity;
    private GraphEntityContext ctx;

    public long current() {
        return this.speed;
    }

    public double stressCapacity() {
        return this.stressCapacity;
    }

    public void update(class_3218 world, BlockGraph graph) {
        int currentTick = world.method_8503().method_3780();
        if (this.lastTick == currentTick) {
            return;
        }
        this.lastTick = currentTick;
        Collection list = graph.getCachedNodes(FunctionalDirectionNode.CACHE);
        if (list.isEmpty()) {
            this.speed = 0L;
            this.stressCapacity = 0L;
            return;
        }
        State state = new State(this);
        for (NodeHolder entries : list) {
            class_2680 blockState = world.method_8320(entries.getBlockPos());
            Object object = ((FunctionalNode)entries.getNode()).getTargetFunctional(world, entries.getBlockPos(), blockState);
            if (!(object instanceof EnergyUser)) continue;
            EnergyUser rotationalSource = (EnergyUser)object;
            rotationalSource.updateEnergyData(state, blockState, world, entries.getBlockPos());
        }
        if (state.count == 0) {
            this.stressCapacity = 0L;
            this.speed = 0L;
            return;
        }
        state.stressCapacity += state.power;
        if (state.stressCapacity <= 0L) {
            this.stressCapacity = 0L;
            this.speed = 0L;
        } else {
            this.speed = state.power;
            this.stressCapacity = state.stressCapacity;
        }
    }

    public void onInit(@NotNull GraphEntityContext ctx) {
        this.ctx = ctx;
    }

    @NotNull
    public GraphEntityContext getContext() {
        return this.ctx;
    }

    @NotNull
    public GraphEntityType<?> getType() {
        return TYPE;
    }

    public void onUnload() {
    }

    public void merge(@NotNull EnergyData other) {
    }

    @NotNull
    private EnergyData split(@NotNull BlockGraph originalGraph, @NotNull BlockGraph newGraph) {
        EnergyData data = new EnergyData();
        data.speed = this.speed;
        return data;
    }

    public boolean powered() {
        return this.speed > 0L;
    }

    public static class State {
        public final EnergyData data;
        protected long power;
        protected long stressCapacity;
        protected int count;

        public State(EnergyData data) {
            this.data = data;
        }

        public void provide(long value) {
            this.power += value;
            ++this.count;
        }

        public void use(long value) {
            this.stressCapacity -= value;
        }
    }
}

