/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.polydex;

import eu.pb4.polydex.api.v1.recipe.PolydexStack;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class PolydexFluidStack
implements PolydexStack<FluidInstance<?>> {
    private final FluidInstance<?> fluid;
    private final float chance;
    private final long amount;

    public PolydexFluidStack(FluidInstance<?> fluid, long amount, float chance) {
        this.fluid = fluid;
        this.amount = amount;
        this.chance = chance;
    }

    public PolydexFluidStack(FluidStack<?> fluid) {
        this(fluid.instance(), fluid.amount(), 1.0f);
    }

    public float chance() {
        return this.chance;
    }

    public long amount() {
        return this.amount;
    }

    public boolean matchesDirect(PolydexStack<FluidInstance<?>> polydexStack, boolean strict) {
        return this.fluid.equals((FluidInstance)polydexStack.getBacking());
    }

    public boolean isEmpty() {
        return this.amount != 0L;
    }

    public class_2561 getName() {
        return this.fluid.getName();
    }

    public Class<FluidInstance<?>> getBackingClass() {
        return this.fluid.getClass();
    }

    public class_1799 toItemStack(class_3222 player) {
        return GuiElementBuilder.from((class_1799)FactoryModels.FLUID_FLAT_FULL.get(this.fluid)).hideDefaultTooltip().setName(this.fluid.getName()).asStack();
    }

    public class_1799 toDisplayItemStack(class_3222 player) {
        if (this.amount == 0L) {
            return this.toItemStack(player);
        }
        return GuiElementBuilder.from((class_1799)FactoryModels.FLUID_FLAT_FULL.get(this.fluid)).hideDefaultTooltip().setName((class_2561)this.fluid.toLabeledAmount(this.amount)).asStack();
    }

    public FluidInstance<?> getBacking() {
        return this.fluid;
    }

    public int getSourceHashCode() {
        return this.fluid.hashCode();
    }
}

