/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.polydex.pages;

import eu.pb4.polydex.api.v1.recipe.PageBuilder;
import eu.pb4.polydex.api.v1.recipe.PolydexEntry;
import eu.pb4.polydex.api.v1.recipe.PolydexIngredient;
import eu.pb4.polydex.api.v1.recipe.PolydexStack;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.polydex.PolydexCompatImpl;
import eu.pb4.polyfactory.polydex.PolydexTextures;
import eu.pb4.polyfactory.polydex.pages.PrioritizedRecipePage;
import eu.pb4.polyfactory.recipe.press.GenericPressRecipe;
import eu.pb4.polyfactory.ui.FluidTextures;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.UiResourceCreator;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PressRecipePage
extends PrioritizedRecipePage<GenericPressRecipe> {
    private static final class_1799 ICON = FactoryItems.PRESS.method_7854();
    private static final class_1799 DRAIN_ICON = new GuiElementBuilder(FactoryItems.DRAIN).setName((class_2561)class_2561.method_43471((String)"text.polyfactory.polydex.drain_required")).asStack();
    private final List<PolydexIngredient<?>> ingredients;
    private final PolydexStack<?>[] output;

    public PressRecipePage(class_8786<GenericPressRecipe> recipe) {
        super(recipe);
        this.ingredients = PolydexCompatImpl.createIngredients(((GenericPressRecipe)this.recipe).inputA(), ((GenericPressRecipe)this.recipe).inputB());
        this.output = PolydexCompatImpl.createOutput(((GenericPressRecipe)this.recipe).output(), ((GenericPressRecipe)this.recipe).outputFluids());
    }

    public class_1799 getOutput(@Nullable PolydexEntry polydexEntry, MinecraftServer minecraftServer) {
        return ((GenericPressRecipe)this.recipe).output().getFirst().stack().method_7972();
    }

    @Nullable
    public class_2561 texture(class_3222 player) {
        return ((GenericPressRecipe)this.recipe).outputFluids().isEmpty() ? PolydexTextures.PRESS : class_2561.method_43473().method_10852(PolydexTextures.PRESS_FLUID).method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.POLYDEX_OFFSET_N + GuiTextures.PRESS_POLYDEX_FLUID_OFFSET)).method_10862(UiResourceCreator.STYLE)).method_10852(FluidTextures.PRESS_POLYDEX.render(a -> {
            for (FluidStack<?> x : ((GenericPressRecipe)this.recipe).outputFluids()) {
                a.accept(x.instance(), Float.valueOf((float)((double)x.amount() / 81000.0)));
            }
        })).method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.PRESS_POLYDEX_FLUID_OFFSET_N + GuiTextures.POLYDEX_OFFSET)).method_10862(UiResourceCreator.STYLE));
    }

    public boolean isOwner(MinecraftServer server, PolydexEntry entry) {
        for (PolydexStack<?> i : this.output) {
            if (!entry.isPartOf(i)) continue;
            return true;
        }
        return false;
    }

    public class_1799 entryIcon(@Nullable PolydexEntry entry, class_3222 player) {
        return ((GenericPressRecipe)this.recipe).output().get(0).stack();
    }

    public class_1799 typeIcon(class_3222 player) {
        return ICON;
    }

    public List<PolydexIngredient<?>> ingredients() {
        return this.ingredients;
    }

    public void createPage(@Nullable PolydexEntry entry, class_3222 player, PageBuilder layer) {
        layer.setIngredient(3, 1, this.ingredients.get(0));
        layer.setIngredient(5, 1, this.ingredients.get(1));
        layer.setOutput(4, 3, this.output);
        if (!((GenericPressRecipe)this.recipe).outputFluids().isEmpty()) {
            layer.set(5, 2, DRAIN_ICON);
            GuiElementBuilder fluid = GuiTextures.EMPTY_BUILDER.get();
            fluid.setName((class_2561)class_2561.method_43471((String)"text.polyfactory.polydex.required_fluids"));
            for (FluidStack<?> stack : ((GenericPressRecipe)this.recipe).outputFluids()) {
                fluid.addLoreLine((class_2561)stack.toTextRequired().method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(false))));
            }
            layer.set(5, 3, fluid);
        }
    }
}

