/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.util.ColoredItem;
import eu.pb4.polyfactory.recipe.FactoryRecipeSerializers;
import eu.pb4.polyfactory.util.DyeColorExtra;
import eu.pb4.polyfactory.util.FactoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_10295;
import net.minecraft.class_10301;
import net.minecraft.class_10302;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3955;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9887;

public record ColoringCraftingRecipe(String group, class_1792 input, class_1856 dye, int maxCount) implements class_3955
{
    public static final MapCodec<ColoringCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(x -> x.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ColoringCraftingRecipe::group), (App)class_7923.field_41178.method_39673().fieldOf("input").forGetter(ColoringCraftingRecipe::input), (App)class_1856.field_46095.fieldOf("dyes").forGetter(ColoringCraftingRecipe::dye), (App)Codec.INT.optionalFieldOf("max_count", (Object)8).forGetter(ColoringCraftingRecipe::maxCount)).apply((Applicative)x, ColoringCraftingRecipe::new));

    public static class_8786<ColoringCraftingRecipe> of(class_7225.class_7226<class_1792> itemWrap, String id, class_1792 item) {
        return new class_8786(FactoryUtil.recipeKey("crafting/" + id), (class_1860)new ColoringCraftingRecipe("polyfactory:crafting/" + id, item, ColoringCraftingRecipe.defaultDyes(itemWrap), 8));
    }

    public static class_8786<ColoringCraftingRecipe> of(class_7225.class_7226<class_1792> itemWrap, String id, class_1792 item, int count) {
        return new class_8786(FactoryUtil.recipeKey("crafting/" + id), (class_1860)new ColoringCraftingRecipe("polyfactory:crafting/" + id, item, ColoringCraftingRecipe.defaultDyes(itemWrap), count));
    }

    private static class_1856 defaultDyes(class_7871<class_1792> itemWrap) {
        return class_1856.method_8106((class_6885)itemWrap.method_46735(ConventionalItemTags.DYES));
    }

    public String method_8112() {
        return this.group;
    }

    public class_7710 method_45441() {
        return class_7710.field_40251;
    }

    public boolean matches(class_9694 inventory, class_1937 world) {
        boolean hasDye = false;
        int count = 0;
        for (class_1799 stack : inventory.method_59989()) {
            if (stack.method_31573(ConventionalItemTags.DYES)) {
                if (hasDye) {
                    return false;
                }
                hasDye = true;
                continue;
            }
            if (stack.method_31574(this.input)) {
                ++count;
                continue;
            }
            if (stack.method_7960()) continue;
            return false;
        }
        return hasDye && count > 0 && count <= this.maxCount;
    }

    public class_1799 craft(class_9694 inventory, class_7225.class_7874 registryManager) {
        int color = -1;
        int count = 0;
        class_1799 og = class_1799.field_8037;
        for (class_1799 stack : inventory.method_59989()) {
            if (stack.method_31573(ConventionalItemTags.DYES)) {
                color = DyeColorExtra.getColor(stack);
                continue;
            }
            if (!stack.method_31574(this.input)) continue;
            ++count;
            og = stack;
        }
        class_1799 out = ColoredItem.stackCrafting(this.input, count, color);
        if (this.maxCount == 1) {
            Integer c = (Integer)out.method_58694(FactoryDataComponents.COLOR);
            out.method_59692(og.method_57380());
            out.method_57379(FactoryDataComponents.COLOR, (Object)c);
        }
        return out;
    }

    public class_1865<ColoringCraftingRecipe> method_8119() {
        return FactoryRecipeSerializers.CRAFTING_COLORING;
    }

    public List<class_10295> method_64664() {
        int[] nArray;
        ArrayList<class_10295> list = new ArrayList<class_10295>();
        ArrayList<class_10302.class_10307> anyColorBase = new ArrayList<class_10302.class_10307>();
        for (class_6880 dye : this.dye.method_8105().toList()) {
            anyColorBase.add(new class_10302.class_10307(ColoredItem.stackCrafting(this.input, 1, DyeColorExtra.getColor(((class_1792)dye.comp_349()).method_7854()))));
        }
        if (this.maxCount != 1) {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
            nArray2[1] = this.maxCount;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        for (Object count : (Object)nArray) {
            for (class_6880 dye : this.dye.method_8105().toList()) {
                ArrayList<Object> t = new ArrayList<Object>();
                t.add(new class_10302.class_10306(dye));
                for (int i = 0; i < count; ++i) {
                    t.add(new class_10302.class_10304(anyColorBase));
                }
                list.add((class_10295)new class_10301(t, (class_10302)new class_10302.class_10307(ColoredItem.stackCrafting(this.input, (int)count, DyeColorExtra.getColor(((class_1792)dye.comp_349()).method_7854()))), (class_10302)new class_10302.class_10306(class_1802.field_8465)));
            }
        }
        return list;
    }

    public class_9887 method_61671() {
        return class_9887.method_61686(List.of(class_1856.method_8101((class_1935)this.input), this.dye));
    }
}

