/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.recipe.casting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.factorytools.api.recipe.CountedIngredient;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.other.FactorySoundEvents;
import eu.pb4.polyfactory.recipe.FactoryRecipeSerializers;
import eu.pb4.polyfactory.recipe.casting.CastingRecipe;
import eu.pb4.polyfactory.recipe.input.SingleItemWithFluid;
import eu.pb4.polyfactory.util.FactoryUtil;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public record SimpleCastingRecipe(Optional<CountedIngredient> item, FluidStack<?> fluidInput, class_1799 output, boolean copyComponents, int itemDamage, class_6880<class_3414> soundEvent, double time, double coolingTime) implements CastingRecipe
{
    public static final MapCodec<SimpleCastingRecipe> CODEC = RecordCodecBuilder.mapCodec(x -> x.group((App)CountedIngredient.CODEC.optionalFieldOf("item").forGetter(SimpleCastingRecipe::item), (App)FluidStack.CODEC.fieldOf("fluid_input").forGetter(SimpleCastingRecipe::fluidInput), (App)class_1799.field_49747.fieldOf("result").forGetter(SimpleCastingRecipe::output), (App)Codec.BOOL.optionalFieldOf("copy_components", (Object)false).forGetter(SimpleCastingRecipe::copyComponents), (App)Codec.INT.optionalFieldOf("item_damage", (Object)0).forGetter(SimpleCastingRecipe::itemDamage), (App)class_3414.field_41699.optionalFieldOf("sound", FactorySoundEvents.BLOCK_SPOUT_METAL_COOLED).forGetter(SimpleCastingRecipe::soundEvent), (App)Codec.DOUBLE.fieldOf("time").forGetter(SimpleCastingRecipe::time), (App)Codec.DOUBLE.fieldOf("cooling_ticks").forGetter(SimpleCastingRecipe::coolingTime)).apply((Applicative)x, SimpleCastingRecipe::new));

    public static SimpleCastingRecipe fluid(FluidStack<?> stack, class_1792 out, class_3414 sound, int coolingTime) {
        return new SimpleCastingRecipe(Optional.empty(), stack, out.method_7854(), false, 0, (class_6880<class_3414>)class_7923.field_41172.method_47983((Object)sound), CastingRecipe.getTime(stack.instance(), stack.amount()), coolingTime);
    }

    public static SimpleCastingRecipe toItem(class_1792 item, FluidStack<?> stack, class_1792 out, class_3414 sound, int coolingTime) {
        return new SimpleCastingRecipe(Optional.of(CountedIngredient.ofItems((int)1, (class_1935[])new class_1935[]{item})), stack, out.method_7854(), false, 0, (class_6880<class_3414>)class_7923.field_41172.method_47983((Object)sound), CastingRecipe.getTime(stack.instance(), stack.amount()), coolingTime);
    }

    public static SimpleCastingRecipe toItem(class_6862<class_1792> item, FluidStack<?> stack, class_1792 out, class_3414 sound, int coolingTime) {
        return new SimpleCastingRecipe(Optional.of(CountedIngredient.fromTag((int)1, FactoryUtil.fakeTagList(item))), stack, out.method_7854(), false, 0, (class_6880<class_3414>)class_7923.field_41172.method_47983((Object)sound), CastingRecipe.getTime(stack.instance(), stack.amount()), coolingTime);
    }

    public static SimpleCastingRecipe templateDamaged(class_6862<class_1792> template, FluidStack<?> stack, class_1792 out, class_3414 sound, double coolingTicks) {
        return new SimpleCastingRecipe(Optional.of(CountedIngredient.fromTag((int)0, FactoryUtil.fakeTagList(template))), stack, out.method_7854(), false, 1, (class_6880<class_3414>)class_7923.field_41172.method_47983((Object)sound), CastingRecipe.getTime(stack.instance(), stack.amount()), coolingTicks);
    }

    public static SimpleCastingRecipe templateDamaged(class_1792 template, FluidStack<?> stack, class_1792 out, class_3414 sound, double coolingTicks) {
        return new SimpleCastingRecipe(Optional.of(CountedIngredient.ofItems((int)0, (class_1935[])new class_1935[]{template})), stack, out.method_7854(), false, 1, (class_6880<class_3414>)class_7923.field_41172.method_47983((Object)sound), CastingRecipe.getTime(stack.instance(), stack.amount()), coolingTicks);
    }

    @Override
    public int decreasedInputItemAmount(SingleItemWithFluid input) {
        return this.item.isPresent() ? this.item.get().count() : 0;
    }

    @Override
    public int damageInputItemAmount(SingleItemWithFluid input) {
        return this.itemDamage;
    }

    @Override
    public double coolingTime(SingleItemWithFluid input) {
        return this.coolingTime;
    }

    public boolean matches(SingleItemWithFluid input, class_1937 world) {
        if (this.item.isPresent() && !this.item.get().test(input.stack()) || this.item.isEmpty() && !input.stack().method_7960()) {
            return false;
        }
        return input.getFluid(this.fluidInput.instance()) >= this.fluidInput.amount();
    }

    public class_1799 craft(SingleItemWithFluid input, class_7225.class_7874 lookup) {
        class_1799 out = this.output.method_7972();
        if (this.copyComponents) {
            out.method_59692(input.stack().method_57380());
        }
        return out;
    }

    public class_1865<SimpleCastingRecipe> method_8119() {
        return FactoryRecipeSerializers.CASTING_SIMPLE;
    }

    @Override
    public FluidStack<?> fluidInput(SingleItemWithFluid input) {
        return this.fluidInput;
    }

    @Override
    public double time(SingleItemWithFluid input) {
        return this.time;
    }
}

