/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.recipe.fluid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.factorytools.api.recipe.OutputStack;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.recipe.FactoryRecipeSerializers;
import eu.pb4.polyfactory.recipe.fluid.FluidInteractionRecipe;
import eu.pb4.polyfactory.recipe.input.FluidContainerInput;
import eu.pb4.polyfactory.recipe.input.FluidInputStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3414;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public record SimpleFluidInteractionRecipe(List<FluidInputStack> fluidInput, List<FluidStack<?>> fluidOutput, List<OutputStack> itemOutput, Optional<class_2394> particleEffect, Optional<class_6880<class_3414>> soundEvent, float particleChance, float minTemperature, float maxTemperature, int maxApplyPerTick) implements FluidInteractionRecipe
{
    public static final MapCodec<SimpleFluidInteractionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidInputStack.CODEC.listOf().fieldOf("fluid_input").forGetter(SimpleFluidInteractionRecipe::fluidInput), (App)FluidStack.CODEC.listOf().fieldOf("fluid_output").forGetter(SimpleFluidInteractionRecipe::fluidOutput), (App)OutputStack.CODEC.listOf().fieldOf("item_output").forGetter(SimpleFluidInteractionRecipe::itemOutput), (App)class_2398.field_25125.optionalFieldOf("particle").forGetter(SimpleFluidInteractionRecipe::particleEffect), (App)class_3414.field_41699.optionalFieldOf("sound_event").forGetter(SimpleFluidInteractionRecipe::soundEvent), (App)Codec.FLOAT.optionalFieldOf("particle_chance", (Object)Float.valueOf(0.0f)).forGetter(SimpleFluidInteractionRecipe::particleChance), (App)Codec.FLOAT.optionalFieldOf("min_temperature", (Object)Float.valueOf(Float.NEGATIVE_INFINITY)).forGetter(SimpleFluidInteractionRecipe::minTemperature), (App)Codec.FLOAT.optionalFieldOf("max_temperature", (Object)Float.valueOf(Float.POSITIVE_INFINITY)).forGetter(SimpleFluidInteractionRecipe::maxTemperature), (App)Codec.INT.optionalFieldOf("max_apply_per_tick", (Object)1).forGetter(SimpleFluidInteractionRecipe::maxApplyPerTick)).apply((Applicative)instance, SimpleFluidInteractionRecipe::new));

    @Override
    public List<FluidInputStack> fluidInput(FluidContainerInput input, class_7225.class_7874 lookup) {
        return this.fluidInput;
    }

    @Override
    public List<FluidStack<?>> fluidOutput(FluidContainerInput input, class_7225.class_7874 lookup) {
        return this.fluidOutput;
    }

    @Override
    public List<OutputStack> itemOutput(FluidContainerInput input, class_7225.class_7874 lookup) {
        return this.itemOutput;
    }

    public boolean matches(FluidContainerInput input, class_1937 world) {
        if (input.temperature() < this.minTemperature || input.temperature() > this.maxTemperature) {
            return false;
        }
        long empty = input.capacity() - input.stored();
        for (FluidInputStack fluidInputStack : this.fluidInput) {
            if (input.get(fluidInputStack.instance()) < fluidInputStack.required()) {
                return false;
            }
            empty += fluidInputStack.used();
        }
        for (FluidStack fluidStack : this.fluidOutput) {
            empty -= fluidStack.amount();
        }
        return empty >= 0L;
    }

    @Override
    @Nullable
    public class_2394 particle(FluidContainerInput input, class_5819 random) {
        return this.particleEffect.orElse(null);
    }

    @Override
    @Nullable
    public class_6880<class_3414> soundEvent(FluidContainerInput input, class_5819 random) {
        return this.soundEvent.orElse(null);
    }

    @Override
    public float particleChance(FluidContainerInput input) {
        return this.particleChance;
    }

    public class_1865<SimpleFluidInteractionRecipe> method_8119() {
        return FactoryRecipeSerializers.FLUID_INTERACTION_SIMPLE;
    }
}

