/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.recipe.grinding;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.factorytools.api.recipe.OutputStack;
import eu.pb4.polyfactory.recipe.FactoryRecipeSerializers;
import eu.pb4.polyfactory.recipe.GrindingRecipe;
import eu.pb4.polyfactory.recipe.input.GrindingInput;
import eu.pb4.polyfactory.util.FactoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public record StrippingGrindingRecipe(String group, Optional<class_1856> input, List<OutputStack> output, double grindTime, double minimumSpeed, double optimalSpeed) implements GrindingRecipe
{
    public static final MapCodec<StrippingGrindingRecipe> CODEC = RecordCodecBuilder.mapCodec(x -> x.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(StrippingGrindingRecipe::group), (App)class_1856.field_46095.optionalFieldOf("input").forGetter(StrippingGrindingRecipe::input), (App)OutputStack.LIST_CODEC.optionalFieldOf("output", List.of()).forGetter(StrippingGrindingRecipe::output), (App)Codec.DOUBLE.fieldOf("time").forGetter(StrippingGrindingRecipe::grindTime), (App)Codec.DOUBLE.optionalFieldOf("minimum_speed", (Object)0.0).forGetter(StrippingGrindingRecipe::minimumSpeed), (App)Codec.DOUBLE.optionalFieldOf("optimal_speed", (Object)0.0).forGetter(StrippingGrindingRecipe::optimalSpeed)).apply((Applicative)x, StrippingGrindingRecipe::new));

    public static class_8786<StrippingGrindingRecipe> of(String string, class_1856 ingredient, double grindTime, double minimumSpeed, double optimalSpeed, OutputStack ... outputs) {
        return new class_8786(FactoryUtil.recipeKey("grinding/" + string), (class_1860)new StrippingGrindingRecipe("", Optional.ofNullable(ingredient), List.of(outputs), grindTime, minimumSpeed, optimalSpeed));
    }

    @Override
    public List<class_1799> output(GrindingInput input, class_7225.class_7874 registryManager, @Nullable class_5819 random) {
        class_2680 stripped;
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        class_1792 class_17922 = input.stack().method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            v0 = StrippableBlockRegistry.getStrippedBlockState((class_2680)blockItem.method_7711().method_9564());
        } else {
            v0 = stripped = null;
        }
        if (stripped != null) {
            items.add(stripped.method_26204().method_8389().method_7854());
        }
        for (OutputStack out : this.output) {
            for (int a = 0; a < out.roll(); ++a) {
                if (random != null && !(random.method_43057() < out.chance())) continue;
                items.add(out.stack().method_7972());
            }
        }
        return items;
    }

    @Override
    public double grindTime(GrindingInput input) {
        return this.grindTime;
    }

    @Override
    public double minimumSpeed(GrindingInput input) {
        return this.minimumSpeed;
    }

    @Override
    public double optimalSpeed(GrindingInput input) {
        return this.optimalSpeed;
    }

    public boolean matches(GrindingInput input, class_1937 world) {
        class_1747 blockItem;
        class_1792 class_17922;
        return (this.input.isEmpty() || this.input.get().method_8093(input.stack())) && (class_17922 = input.stack().method_7909()) instanceof class_1747 && StrippableBlockRegistry.getStrippedBlockState((class_2680)(blockItem = (class_1747)class_17922).method_7711().method_9564()) != null;
    }

    public class_1865<StrippingGrindingRecipe> method_8119() {
        return FactoryRecipeSerializers.GRINDING_STRIPPING;
    }
}

