/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.recipe.mixing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polyfactory.block.mechanical.machines.crafting.MixerBlockEntity;
import eu.pb4.polyfactory.item.ArtificialDyeItem;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.recipe.FactoryRecipeSerializers;
import eu.pb4.polyfactory.recipe.input.MixingInput;
import eu.pb4.polyfactory.recipe.mixing.MixingRecipe;
import eu.pb4.polyfactory.util.DyeColorExtra;
import java.util.Collections;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_9848;

public record ArtificialDyeMixingRecipe(double time, double minimumSpeed, double optimalSpeed) implements MixingRecipe
{
    public static final MapCodec<ArtificialDyeMixingRecipe> CODEC = RecordCodecBuilder.mapCodec(x -> x.group((App)Codec.DOUBLE.fieldOf("time").forGetter(artificialDyeMixingRecipe -> artificialDyeMixingRecipe.time()), (App)Codec.DOUBLE.optionalFieldOf("minimum_speed", (Object)1.0).forGetter(artificialDyeMixingRecipe -> artificialDyeMixingRecipe.minimumSpeed()), (App)Codec.DOUBLE.optionalFieldOf("optimal_speed", (Object)1.0).forGetter(artificialDyeMixingRecipe -> artificialDyeMixingRecipe.optimalSpeed())).apply((Applicative)x, ArtificialDyeMixingRecipe::new));

    @Override
    public Iterable<class_1799> remainders(MixingInput input) {
        return Collections.emptyList();
    }

    @Override
    public float minimumTemperature(MixingInput input) {
        return 0.2f;
    }

    @Override
    public float maxTemperature(MixingInput input) {
        return 1.0f;
    }

    public boolean matches(MixingInput inventory, class_1937 world) {
        if (!inventory.fluids().isEmpty()) {
            return false;
        }
        boolean hasBase = false;
        int dyeCount = 0;
        int ingridCount = 0;
        for (int i = 0; i < 6; ++i) {
            class_1799 stack = inventory.method_59984(i);
            if (stack.method_31574(FactoryItems.SAW_DUST)) {
                hasBase = true;
                continue;
            }
            if (stack.method_31574(FactoryItems.ARTIFICIAL_DYE)) {
                hasBase = true;
                ++dyeCount;
                ++ingridCount;
                continue;
            }
            if (stack.method_7909() instanceof class_1769) {
                ++dyeCount;
                ++ingridCount;
                continue;
            }
            if (stack.method_31574(class_1802.field_8725) || stack.method_31574(class_1802.field_8777) || stack.method_31574(class_1802.field_8759) || stack.method_31574(FactoryItems.COAL_DUST) || stack.method_31574(class_1802.field_8324)) {
                ++ingridCount;
                continue;
            }
            if (stack.method_7960()) continue;
            return false;
        }
        return hasBase && (dyeCount > 1 || ingridCount > 1 && dyeCount == 1);
    }

    public class_1799 craft(MixingInput inventory, class_7225.class_7874 registryManager) {
        int i;
        int[] rgb = new int[3];
        int[] rgbDye = new int[3];
        int maxColor = 0;
        int colorCount = 0;
        int delta = 32;
        for (i = 0; i < 6; ++i) {
            if (!inventory.method_59984(i).method_31574(FactoryItems.SAW_DUST)) continue;
            delta /= 2;
        }
        for (i = 0; i < 6; ++i) {
            class_1799 itemStack = inventory.method_59984(i);
            int color = DyeColorExtra.getColor(itemStack);
            if (color != -1) {
                int r = class_9848.method_61327((int)color);
                int g = class_9848.method_61329((int)color);
                int b = class_9848.method_61331((int)color);
                rgb[0] = rgb[0] + r;
                rgb[1] = rgb[1] + g;
                rgb[2] = rgb[2] + b;
                rgbDye[0] = rgbDye[0] + r;
                rgbDye[1] = rgbDye[1] + g;
                rgbDye[2] = rgbDye[2] + b;
                maxColor += Math.max(r, Math.max(g, b));
                ++colorCount;
                continue;
            }
            if (itemStack.method_31574(class_1802.field_8725)) {
                rgb[1] = Math.max(rgb[1] - delta, 0);
                rgb[2] = Math.max(rgb[2] - delta, 0);
                continue;
            }
            if (itemStack.method_31574(class_1802.field_8777)) {
                rgb[0] = Math.max(rgb[0] - delta, 0);
                rgb[2] = Math.max(rgb[2] - delta, 0);
                continue;
            }
            if (itemStack.method_31574(class_1802.field_8759)) {
                rgb[1] = Math.max(rgb[1] - delta, 0);
                rgb[2] = Math.max(rgb[2] - delta, 0);
                continue;
            }
            if (itemStack.method_31574(class_1802.field_8324)) {
                rgb[0] = rgb[0] + delta;
                rgb[1] = rgb[1] + delta;
                rgb[2] = rgb[2] + delta;
                continue;
            }
            if (!itemStack.method_31574(FactoryItems.COAL_DUST)) continue;
            rgb[0] = Math.max(rgb[0] - delta, 0);
            rgb[1] = Math.max(rgb[1] - delta, 0);
            rgb[2] = Math.max(rgb[2] - delta, 0);
        }
        int r = rgb[0] / colorCount;
        int g = rgb[1] / colorCount;
        int b = rgb[2] / colorCount;
        float scale = (float)maxColor / (float)colorCount;
        float maxValue = Math.max(rgbDye[0] / colorCount, Math.max(rgbDye[1] / colorCount, rgbDye[2] / colorCount));
        r = (int)((float)r * scale / maxValue);
        g = (int)((float)g * scale / maxValue);
        b = (int)((float)b * scale / maxValue);
        int color = Math.min(r, 255);
        color = (color << 8) + Math.min(g, 255);
        color = (color << 8) + Math.min(b, 255);
        return ArtificialDyeItem.of(color);
    }

    @Override
    public void applyRecipeUse(MixerBlockEntity inventory, class_1937 world) {
        for (int i = 0; i < 6; ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (DyeColorExtra.getColor(stack) == -1 && !stack.method_31574(class_1802.field_8725) && !stack.method_31574(class_1802.field_8777) && !stack.method_31574(class_1802.field_8759) && !stack.method_31574(FactoryItems.COAL_DUST) && !stack.method_31574(class_1802.field_8324)) continue;
            stack.method_7934(1);
            if (!stack.method_7960()) continue;
            inventory.method_5447(i, class_1799.field_8037);
        }
    }

    public class_1865<ArtificialDyeMixingRecipe> method_8119() {
        return FactoryRecipeSerializers.MIXING_ARTIFICIAL_DYE;
    }

    @Override
    public double optimalSpeed(MixingInput input) {
        return this.optimalSpeed;
    }

    @Override
    public double minimumSpeed(MixingInput input) {
        return this.minimumSpeed;
    }

    @Override
    public double time(MixingInput input) {
        return this.time;
    }
}

