/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.recipe.mixing;

import com.google.common.collect.Iterators;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.factorytools.api.recipe.CountedIngredient;
import eu.pb4.factorytools.api.util.ItemComponentPredicate;
import eu.pb4.polyfactory.block.mechanical.machines.crafting.MixerBlockEntity;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.recipe.FactoryRecipeSerializers;
import eu.pb4.polyfactory.recipe.input.FluidInputStack;
import eu.pb4.polyfactory.recipe.input.MixingInput;
import eu.pb4.polyfactory.recipe.mixing.MixingRecipe;
import eu.pb4.polyfactory.util.FactoryUtil;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_8786;

public record GenericMixingRecipe(String group, List<CountedIngredient> input, Optional<List<FluidInputStack>> fluidInputs, class_1799 output, List<FluidStack<?>> fluidOutput, double time, double minimumSpeed, double optimalSpeed, float minimumTemperature, float maxTemperature) implements MixingRecipe
{
    public static final MapCodec<GenericMixingRecipe> CODEC = RecordCodecBuilder.mapCodec(x -> x.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(GenericMixingRecipe::group), (App)CountedIngredient.LIST_CODEC.fieldOf("input").forGetter(GenericMixingRecipe::input), (App)FluidInputStack.CODEC.listOf().optionalFieldOf("fluid_input").forGetter(GenericMixingRecipe::fluidInputs), (App)class_1799.field_49266.fieldOf("output").forGetter(GenericMixingRecipe::output), (App)FluidStack.CODEC.listOf().fieldOf("output_fluid").forGetter(GenericMixingRecipe::fluidOutput), (App)Codec.DOUBLE.fieldOf("time").forGetter(GenericMixingRecipe::time), (App)Codec.DOUBLE.optionalFieldOf("minimum_speed", (Object)1.0).forGetter(GenericMixingRecipe::minimumSpeed), (App)Codec.DOUBLE.optionalFieldOf("optimal_speed", (Object)1.0).forGetter(GenericMixingRecipe::optimalSpeed), (App)Codec.FLOAT.optionalFieldOf("minimal_temperature", (Object)Float.valueOf(Float.NEGATIVE_INFINITY)).forGetter(GenericMixingRecipe::minimumTemperature), (App)Codec.FLOAT.optionalFieldOf("max_temperature", (Object)Float.valueOf(Float.POSITIVE_INFINITY)).forGetter(GenericMixingRecipe::maxTemperature)).apply((Applicative)x, GenericMixingRecipe::new));

    public static class_8786<GenericMixingRecipe> ofCounted(String string, List<CountedIngredient> ingredient, double mixingTime, double minimumSpeed, double optimalSpeed, class_1799 output) {
        return new class_8786(FactoryUtil.recipeKey("mixing/" + string), (class_1860)new GenericMixingRecipe("", ingredient, Optional.of(List.of()), output, List.of(), mixingTime, minimumSpeed, optimalSpeed, -0.1f, Float.POSITIVE_INFINITY));
    }

    public static class_8786<GenericMixingRecipe> ofCounted(String string, List<CountedIngredient> ingredient, double mixingTime, double minimumSpeed, double optimalSpeed, float minTemperature, class_1799 output) {
        return new class_8786(FactoryUtil.recipeKey("mixing/" + string), (class_1860)new GenericMixingRecipe("", ingredient, Optional.of(List.of()), output, List.of(), mixingTime, minimumSpeed, optimalSpeed, minTemperature, Float.POSITIVE_INFINITY));
    }

    public static class_8786<GenericMixingRecipe> ofCounted(String string, String group, List<CountedIngredient> ingredient, double mixingTime, double minimumSpeed, double optimalSpeed, class_1799 output) {
        return new class_8786(FactoryUtil.recipeKey("mixing/" + string), (class_1860)new GenericMixingRecipe(group, ingredient, Optional.of(List.of()), output, List.of(), mixingTime, minimumSpeed, optimalSpeed, -0.1f, Float.POSITIVE_INFINITY));
    }

    public static class_8786<GenericMixingRecipe> ofCounted(String string, String group, List<CountedIngredient> ingredient, List<FluidInputStack> fluids, double mixingTime, double minimumSpeed, double optimalSpeed, float minTemperature, class_1799 output) {
        return new class_8786(FactoryUtil.recipeKey("mixing/" + string), (class_1860)new GenericMixingRecipe(group, ingredient, Optional.ofNullable(fluids), output, List.of(), mixingTime, minimumSpeed, optimalSpeed, minTemperature, Float.POSITIVE_INFINITY));
    }

    public static class_8786<GenericMixingRecipe> ofCounted(String string, String group, List<CountedIngredient> ingredient, List<FluidInputStack> fluidInput, double mixingTime, double minimumSpeed, double optimalSpeed, float minTemperature, class_1799 output, List<FluidStack<?>> fluidOutput) {
        return new class_8786(FactoryUtil.recipeKey("mixing/" + string), (class_1860)new GenericMixingRecipe(group, ingredient, Optional.ofNullable(fluidInput), output, fluidOutput, mixingTime, minimumSpeed, optimalSpeed, minTemperature, Float.POSITIVE_INFINITY));
    }

    public static class_8786<GenericMixingRecipe> ofCounted(String string, String group, List<CountedIngredient> ingredient, List<FluidInputStack> fluidInput, double mixingTime, double minimumSpeed, double optimalSpeed, float minTemperature, float maxTemperature, class_1799 output, List<FluidStack<?>> fluidOutput) {
        return new class_8786(FactoryUtil.recipeKey("mixing/" + string), (class_1860)new GenericMixingRecipe(group, ingredient, Optional.ofNullable(fluidInput), output, fluidOutput, mixingTime, minimumSpeed, optimalSpeed, minTemperature, maxTemperature));
    }

    @Override
    public Iterable<class_1799> remainders(MixingInput input) {
        return () -> Iterators.transform(this.input.iterator(), a -> a.leftOver().method_7972());
    }

    public static class_8786<GenericMixingRecipe> of(String string, List<class_1856> ingredient, double mixingTime, double minimumSpeed, double optimalSpeed, class_1799 output) {
        ArrayList<CountedIngredient> list = new ArrayList<CountedIngredient>();
        for (class_1856 x : ingredient) {
            CountedIngredient countedIngredient = new CountedIngredient(Optional.of(x), ItemComponentPredicate.EMPTY, 1, CountedIngredient.tryGettingLeftover((class_1856)x));
            list.add(countedIngredient);
        }
        return new class_8786(FactoryUtil.recipeKey("mixing/" + string), (class_1860)new GenericMixingRecipe("", list, Optional.of(List.of()), output, List.of(), mixingTime, minimumSpeed, optimalSpeed, -1.0f, 2.0f));
    }

    public static class_8786<GenericMixingRecipe> of(String string, String group, List<class_1856> ingredient, double mixingTime, double minimumSpeed, double optimalSpeed, class_1799 output) {
        ArrayList<CountedIngredient> list = new ArrayList<CountedIngredient>();
        for (class_1856 x : ingredient) {
            CountedIngredient countedIngredient = new CountedIngredient(Optional.of(x), ItemComponentPredicate.EMPTY, 1, CountedIngredient.tryGettingLeftover((class_1856)x));
            list.add(countedIngredient);
        }
        return new class_8786(FactoryUtil.recipeKey("mixing/" + string), (class_1860)new GenericMixingRecipe(group, list, Optional.of(List.of()), output, List.of(), mixingTime, minimumSpeed, optimalSpeed, -1.0f, 2.0f));
    }

    public String method_8112() {
        return this.group;
    }

    public boolean matches(MixingInput inventory, class_1937 world) {
        if (this.fluidInputs.isPresent()) {
            for (FluidInputStack fluid : this.fluidInputs.get()) {
                if (inventory.getFluid(fluid.instance()) >= fluid.required()) continue;
                return false;
            }
        }
        if (!this.input.isEmpty() && !this.input.getFirst().ingredient().isEmpty()) {
            Object2IntArrayMap map = new Object2IntArrayMap();
            for (int i = 0; i < 6; ++i) {
                class_1799 stack = inventory.method_59984(i);
                if (stack.method_7960()) continue;
                boolean notFound = true;
                for (CountedIngredient ig : this.input) {
                    if (!ig.test(stack)) continue;
                    map.put((Object)ig, map.getInt((Object)ig) + stack.method_7947());
                    notFound = false;
                    break;
                }
                if (!notFound) continue;
                return false;
            }
            if (this.input.size() != map.size()) {
                return false;
            }
            for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
                if (((CountedIngredient)entry.getKey()).count() <= entry.getIntValue()) continue;
                return false;
            }
        } else if (!inventory.isSlotEmpty()) {
            return false;
        }
        return true;
    }

    @Override
    public void applyRecipeUse(MixerBlockEntity inventory, class_1937 world) {
        ArrayList<CountedIngredient> list = new ArrayList<CountedIngredient>(this.input);
        FluidContainer container = inventory.getFluidContainer();
        if (this.fluidInputs.isPresent()) {
            for (FluidInputStack fluid : this.fluidInputs.get()) {
                container.extract(fluid.instance(), fluid.used(), false);
            }
        }
        block1: for (CountedIngredient ig : list) {
            int count = ig.count();
            if (count == 0) continue;
            for (int i = 0; i < 6; ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (stack.method_7960() || !ig.test(stack)) continue;
                if (stack.method_7947() >= count) {
                    stack.method_7934(count);
                    inventory.method_5447(i, stack);
                    continue block1;
                }
                count -= stack.method_7947();
                stack.method_7939(0);
                inventory.method_5447(i, class_1799.field_8037);
            }
        }
    }

    public List<FluidInputStack> fluidInput() {
        if (this.fluidInputs.isPresent()) {
            return this.fluidInputs.get();
        }
        return List.of();
    }

    public class_1799 craft(MixingInput inventory, class_7225.class_7874 registryManager) {
        return this.output.method_7972();
    }

    public class_1865<GenericMixingRecipe> method_8119() {
        return FactoryRecipeSerializers.MIXING_GENERIC;
    }

    @Override
    public double optimalSpeed(MixingInput input) {
        return this.optimalSpeed;
    }

    @Override
    public double minimumSpeed(MixingInput input) {
        return this.minimumSpeed;
    }

    @Override
    public float minimumTemperature(MixingInput input) {
        return this.minimumTemperature;
    }

    @Override
    public float maxTemperature(MixingInput input) {
        return this.maxTemperature;
    }

    @Override
    public List<FluidStack<?>> fluidOutput(MixingInput input) {
        return this.fluidOutput;
    }

    @Override
    public List<FluidInputStack> fluidInput(MixingInput input) {
        return this.fluidInputs.isPresent() ? this.fluidInputs.get() : List.of();
    }

    @Override
    public double time(MixingInput input) {
        return this.time;
    }
}

