/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.ui;

import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidType;
import eu.pb4.polyfactory.ui.FluidUiPositionCreator;
import eu.pb4.polyfactory.ui.FluidUiTextureCreator;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.apache.commons.lang3.mutable.MutableInt;

public record FluidTextures(Map<FluidType<?>, char[]> textures, FluidUiPositionCreator uiPositionCreator, char back) {
    private static final Int2ObjectOpenHashMap<FluidUiTextureCreator> TEXTURE_CREATORS = new Int2ObjectOpenHashMap();
    public static final FluidTextures MIXER = FluidTextures.of("mixer", 10, 48, 19);
    public static final FluidTextures MIXER_POLYDEX = FluidTextures.of("mixer_polydex", 10, 48, 37);
    public static final FluidTextures PRESS_POLYDEX = FluidTextures.of("press_polydex", 10, 16, 71);
    public static final FluidTextures SMELTERY = FluidTextures.of("smeltery", 48, 80, 21);
    public static final FluidTextures PRIMITIVE_SMELTERY = FluidTextures.of("primitive_smeltery", 48, 44, 21);

    public class_2561 render(Consumer<BiConsumer<FluidInstance<?>, Float>> provider) {
        class_5250 out = class_2561.method_43473().method_10862(this.uiPositionCreator.style);
        MutableInt line = new MutableInt(0);
        provider.accept((type, amount) -> {
            StringBuilder b = new StringBuilder();
            char[] lines = this.textures.get(type.type());
            if (lines == null) {
                return;
            }
            Integer start = line.getValue();
            int count = Math.min(class_3532.method_15386((float)(amount.floatValue() * (float)this.uiPositionCreator.height())) + start, lines.length);
            for (int i = start.intValue(); i < count; ++i) {
                b.append(lines[i]);
                b.append(this.back);
            }
            class_5250 t = class_2561.method_43470((String)b.toString());
            if (type.type().color().isPresent()) {
                t.method_54663(type.type().color().get().getColor(type.data()));
            }
            out.method_10852((class_2561)t);
            line.setValue(count);
        });
        return out;
    }

    public static FluidTextures of(String name, int width, int height, int offsetY) {
        TEXTURE_CREATORS.computeIfAbsent(width, w -> {
            FluidUiTextureCreator creator = new FluidUiTextureCreator(w);
            creator.setup();
            return creator;
        });
        FluidUiPositionCreator creator = new FluidUiPositionCreator(name, width, height, offsetY);
        FluidTextures textures = new FluidTextures(new IdentityHashMap(), creator, creator.space(-width - 1));
        creator.setup(textures.textures);
        return textures;
    }

    public static void setup() {
    }
}

