/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.ui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.pb4.polyfactory.fluid.FluidType;
import eu.pb4.polyfactory.other.FactoryRegistries;
import eu.pb4.polyfactory.ui.UiResourceCreator;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import it.unimi.dsi.fastutil.chars.Char2IntMap;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_11719;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public class FluidUiPositionCreator {
    public final class_2583 style;
    private final Char2IntMap spaces = new Char2IntOpenHashMap();
    private final List<UiResourceCreator.FontTexture> fontTextures = new ArrayList<UiResourceCreator.FontTexture>();
    private final int width;
    private final int height;
    private final int textureHeight;
    private final int offsetY;
    private final class_2960 id;
    private final String name;
    private char character = (char)256;

    public FluidUiPositionCreator(String name, int width, int height, int offsetY) {
        this.id = FactoryUtil.id("fluid/" + name);
        this.name = name;
        this.width = width;
        this.height = height;
        this.offsetY = offsetY;
        this.textureHeight = Math.min(height, 16);
        this.style = class_2583.field_24360.method_36139(0xFFFFFF).method_27704((class_11719)new class_11719.class_11721(this.id));
    }

    public char[] registerTextures(class_2960 identifier) {
        identifier = identifier.method_45138("gen/fluids_" + this.width + "/").method_48331("/");
        char[] chars = new char[this.height];
        for (int i = 0; i < this.height; ++i) {
            chars[i] = this.singleChar(identifier.method_48331("" + i % this.textureHeight), 13 - this.height + i - this.offsetY, 1);
        }
        return chars;
    }

    public char singleChar(class_2960 path, int ascent, int height) {
        char c = this.character;
        this.character = (char)(c + '\u0001');
        char c2 = c;
        UiResourceCreator.FontTexture texture = new UiResourceCreator.FontTexture(path, ascent, height, new char[][]{{c2}});
        this.fontTextures.add(texture);
        return c2;
    }

    public char space(int width) {
        char c = this.character;
        this.character = (char)(c + '\u0001');
        char c2 = c;
        this.spaces.put(c2, width);
        return c2;
    }

    public void setup(Map<FluidType<?>, char[]> textures) {
        for (class_2960 fluid : FactoryRegistries.FLUID_TYPES.method_10235()) {
            textures.put((FluidType)FactoryRegistries.FLUID_TYPES.method_63535(fluid), this.registerTextures(fluid));
        }
        RegistryEntryAddedCallback.event(FactoryRegistries.FLUID_TYPES).register((rawId, id, object) -> textures.put((FluidType<?>)object, this.registerTextures(id)));
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(b -> this.generateAssets((arg_0, arg_1) -> ((ResourcePackBuilder)b).addData(arg_0, arg_1)));
    }

    public void generateAssets(BiConsumer<String, byte[]> assetWriter) {
        JsonObject fontBase = new JsonObject();
        JsonArray providers = new JsonArray();
        JsonObject spaces = new JsonObject();
        spaces.addProperty("type", "space");
        JsonObject advances = new JsonObject();
        this.spaces.char2IntEntrySet().stream().sorted(Comparator.comparing(Char2IntMap.Entry::getCharKey)).forEach(c -> advances.addProperty(Character.toString(c.getCharKey()), (Number)c.getIntValue()));
        spaces.add("advances", (JsonElement)advances);
        providers.add((JsonElement)spaces);
        this.fontTextures.forEach(entry -> {
            JsonObject bitmap = new JsonObject();
            bitmap.addProperty("type", "bitmap");
            bitmap.addProperty("file", String.valueOf(entry.path()) + ".png");
            bitmap.addProperty("ascent", (Number)entry.ascent());
            bitmap.addProperty("height", (Number)entry.height());
            JsonArray chars = new JsonArray();
            for (char[] a : entry.chars()) {
                StringBuilder builder = new StringBuilder();
                for (char b : a) {
                    builder.append(b);
                }
                chars.add(builder.toString());
            }
            bitmap.add("chars", (JsonElement)chars);
            providers.add((JsonElement)bitmap);
        });
        fontBase.add("providers", (JsonElement)providers);
        assetWriter.accept("assets/polyfactory/font/fluid/" + this.name + ".json", fontBase.toString().getBytes(StandardCharsets.UTF_8));
    }

    public int height() {
        return this.height;
    }
}

