/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class PolyFactoryConfig {
    @SerializedName(value="use_fast_stete_limited_blocks")
    public boolean useFastFullBlocks = true;
    private static PolyFactoryConfig instance = null;

    public static PolyFactoryConfig get() {
        if (instance == null) {
            PolyFactoryConfig.loadConfig();
        }
        return instance;
    }

    private static void loadConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Path path = FabricLoader.getInstance().getConfigDir().resolve("polyfactory.json");
        if (Files.exists(path, new LinkOption[0])) {
            try {
                instance = (PolyFactoryConfig)gson.fromJson(Files.readString(path), PolyFactoryConfig.class);
            }
            catch (Throwable e) {
                instance = new PolyFactoryConfig();
            }
        } else {
            instance = new PolyFactoryConfig();
        }
        try {
            Files.writeString(path, (CharSequence)gson.toJson((Object)instance), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

