/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.util.movingitem;

import eu.pb4.polyfactory.util.movingitem.ContainerHolder;
import eu.pb4.polyfactory.util.movingitem.MovingItem;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public class SimpleContainer
implements ContainerHolder {
    private static final AddedCallback NOOP_ADD = (a, b, c) -> {};
    private static final RemovedCallback NOOP_REMOVE = (a, b) -> {};
    private final int id;
    @Nullable
    private MovingItem movingItem;
    private AddedCallback added;
    private RemovedCallback removed;

    public SimpleContainer() {
        this(-1, NOOP_ADD, NOOP_REMOVE);
    }

    public SimpleContainer(int id, AddedCallback added, RemovedCallback removed) {
        this.id = id;
        this.added = added;
        this.removed = removed;
    }

    public static void readArray(SimpleContainer[] containers, class_11368.class_11370 listView) {
        if (listView.method_71444()) {
            for (SimpleContainer x : containers) {
                x.clearContainer();
            }
        } else {
            int i = 0;
            for (class_11368 view : listView) {
                containers[i].readData(view);
                if (i++ < containers.length) continue;
                break;
            }
        }
    }

    public static void writeArray(SimpleContainer[] containers, class_11372.class_11373<class_1799> appender) {
        for (SimpleContainer container : containers) {
            appender.method_71484((Object)container.getStack());
        }
    }

    public void writeData(class_11372 view) {
        if (this.movingItem != null && !this.movingItem.method_32327().method_7960()) {
            view.method_71460(class_1799.field_55709, (Object)this.getStack());
        }
    }

    public void readData(class_11368 view) {
        if (view.method_71428("id", "").isEmpty()) {
            this.clearContainer();
        } else {
            Optional stack = view.method_71418(class_1799.field_55709);
            if (stack.isEmpty()) {
                this.clearContainer();
                return;
            }
            if (this.movingItem != null) {
                this.movingItem.method_32332((class_1799)stack.get());
            } else {
                this.setContainer(new MovingItem((class_1799)stack.get()));
            }
        }
    }

    public static SimpleContainer[] createArray(int size, AddedCallback added, RemovedCallback removed) {
        SimpleContainer[] arr = new SimpleContainer[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = new SimpleContainer(i, added, removed);
        }
        return arr;
    }

    @Override
    @Nullable
    public MovingItem getContainer() {
        return this.movingItem;
    }

    @Override
    public void setContainer(@Nullable MovingItem container) {
        if (container == null) {
            this.removed.accept(this.movingItem, true);
            this.movingItem = null;
        } else {
            if (this.movingItem != null) {
                this.removed.accept(this.movingItem, true);
            }
            this.movingItem = container;
            this.added.accept(this.id, container, true);
        }
    }

    @Override
    @Nullable
    public MovingItem pullAndRemove() {
        MovingItem x = this.movingItem;
        this.movingItem = null;
        this.removed.accept(x, false);
        return x;
    }

    @Override
    public void pushAndAttach(MovingItem container) {
        if (this.movingItem != null) {
            this.removed.accept(this.movingItem, true);
        }
        this.movingItem = container;
        if (container != null) {
            this.added.accept(this.id, container, false);
        } else {
            this.setContainer(null);
        }
    }

    public void maybeAdd(ElementHolder model) {
        if (!this.isContainerEmpty()) {
            model.addElement((VirtualElement)this.getContainer());
        }
    }

    public class_1799 getStack() {
        if (this.movingItem != null) {
            return this.movingItem.method_32327();
        }
        return class_1799.field_8037;
    }

    @Nullable
    public class_243 getPos() {
        if (this.movingItem != null) {
            return this.movingItem.getCurrentPos();
        }
        return null;
    }

    public void tick() {
        if (this.movingItem != null) {
            this.movingItem.tick();
        }
    }

    public static interface AddedCallback {
        public void accept(int var1, MovingItem var2, boolean var3);
    }

    public static interface RemovedCallback {
        public void accept(MovingItem var1, boolean var2);
    }
}

