/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.util.storage;

import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public interface WrappingStorage<T>
extends Storage<T> {
    public Storage<T> storage();

    default public boolean supportsInsertion() {
        return this.storage().supportsInsertion();
    }

    default public long insert(T resource, long maxAmount, TransactionContext transaction) {
        return this.storage().insert(resource, maxAmount, transaction);
    }

    default public boolean supportsExtraction() {
        return this.storage().supportsExtraction();
    }

    default public long extract(T resource, long maxAmount, TransactionContext transaction) {
        return this.storage().extract(resource, maxAmount, transaction);
    }

    default public Iterator<StorageView<T>> iterator() {
        return this.storage().iterator();
    }

    default public Iterator<StorageView<T>> nonEmptyIterator() {
        return this.storage().nonEmptyIterator();
    }

    default public Iterable<StorageView<T>> nonEmptyViews() {
        return this.storage().nonEmptyViews();
    }

    default public long getVersion() {
        return this.storage().getVersion();
    }

    @Nullable
    public static <T> Storage<T> withModifyCallback(final @Nullable Storage<T> storage, final Runnable onInsertOrExtract) {
        if (storage == null) {
            return null;
        }
        if (storage instanceof SlottedStorage) {
            final SlottedStorage slottedStorage = (SlottedStorage)storage;
            return new Slotted<T>(){

                @Override
                public SlottedStorage<T> storage() {
                    return slottedStorage;
                }

                @Override
                public long insert(T resource, long maxAmount, TransactionContext transaction) {
                    long i = Slotted.super.insert(resource, maxAmount, transaction);
                    if (i > 0L) {
                        onInsertOrExtract.run();
                    }
                    return i;
                }

                @Override
                public long extract(T resource, long maxAmount, TransactionContext transaction) {
                    long i = Slotted.super.extract(resource, maxAmount, transaction);
                    if (i > 0L) {
                        onInsertOrExtract.run();
                    }
                    return i;
                }
            };
        }
        return new WrappingStorage<T>(){

            @Override
            public Storage<T> storage() {
                return storage;
            }

            @Override
            public long insert(T resource, long maxAmount, TransactionContext transaction) {
                long i = WrappingStorage.super.insert(resource, maxAmount, transaction);
                if (i > 0L) {
                    onInsertOrExtract.run();
                }
                return i;
            }

            @Override
            public long extract(T resource, long maxAmount, TransactionContext transaction) {
                long i = WrappingStorage.super.extract(resource, maxAmount, transaction);
                if (i > 0L) {
                    onInsertOrExtract.run();
                }
                return i;
            }
        };
    }

    public static interface Slotted<T>
    extends WrappingStorage<T>,
    SlottedStorage<T> {
        @Override
        public SlottedStorage<T> storage();

        default public int getSlotCount() {
            return this.storage().getSlotCount();
        }

        default public SingleSlotStorage<T> getSlot(int slot) {
            return this.storage().getSlot(slot);
        }

        default public @UnmodifiableView List<SingleSlotStorage<T>> getSlots() {
            return this.storage().getSlots();
        }
    }
}

