/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.eu.smileyik.luaInMinecraftBukkitII.JsonUtil;
import org.eu.smileyik.luaInMinecraftBukkitII.LuaStateManager;
import org.eu.smileyik.luaInMinecraftBukkitII.NativeLoader;
import org.eu.smileyik.luaInMinecraftBukkitII.UpdateChecker;
import org.eu.smileyik.luaInMinecraftBukkitII.api.ILuaStateManager;
import org.eu.smileyik.luaInMinecraftBukkitII.bstats.bukkit.Metrics;
import org.eu.smileyik.luaInMinecraftBukkitII.command.LuacageCommand;
import org.eu.smileyik.luaInMinecraftBukkitII.command.RootCommand;
import org.eu.smileyik.luaInMinecraftBukkitII.config.Config;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.command.LuaCommandRegister;
import org.eu.smileyik.luaInMinecraftBukkitII.scheduler.Scheduler;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.CommandService;
import org.eu.smileyik.luaInMinecraftBukkitII.simpledebug.DebugLogger;
import org.eu.smileyik.luaInMinecraftBukkitII.tools.LuacageDatabaseGenerator;
import org.eu.smileyik.luaInMinecraftBukkitII.util.BStatsMetrics;
import org.eu.smileyik.luaInMinecraftBukkitII.util.ResourcesExtractor;
import org.eu.smileyik.luajava.LuaJavaAPI;
import org.eu.smileyik.luajava.LuaState;
import org.eu.smileyik.luajava.reflect.ReflectUtil;

public final class LuaInMinecraftBukkit
extends JavaPlugin {
    public static final String NATIVES_FOLDER = "natives";
    public static final String LUA_STATE_FOLDER = "luaState";
    public static final String LUA_LIB_FOLDER = "luaLibrary";
    public static final String LUA_PKG_FOLDER = "package";
    private static final int BSTATS_CODE = 26298;
    private static final String[] FOLDERS = new String[]{"luaState", "natives", "luaLibrary", "package", "scripts"};
    private static final AtomicBoolean LOADED_NATIVES = new AtomicBoolean(false);
    private static LuaInMinecraftBukkit plugin;
    private ILuaStateManager luaStateManager = null;
    private final Scheduler scheduler = Scheduler.newInstance();
    private Metrics metrics;

    public LuaInMinecraftBukkit() {
        plugin = this;
    }

    public void onEnable() {
        this.getScheduler().runTaskAsynchronously((Plugin)this, LuacageDatabaseGenerator::run);
        try {
            CommandService.newInstance(LuaCommandRegister.DEFAULT_TRANSLATOR, LuaCommandRegister.DEFAULT_FORMAT, RootCommand.class).registerToBukkit((Plugin)this);
            LuacageCommand.register(this);
        }
        catch (Exception e) {
            this.getLogger().warning("Cannot register command!");
            DebugLogger.debug(e);
        }
        this.reload();
    }

    public void onDisable() {
        this.close();
        HandlerList.unregisterAll((Plugin)this);
        this.scheduler.cancel((Plugin)this);
    }

    private void close() {
        if (this.luaStateManager != null) {
            this.luaStateManager.close();
            this.luaStateManager = null;
        }
        this.getServer().getServicesManager().unregisterAll((Plugin)this);
        try {
            DebugLogger.closeLogger();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    public void reload() {
        Config config;
        this.close();
        for (String folder : FOLDERS) {
            if (new File(this.getDataFolder(), folder).exists()) continue;
            new File(this.getDataFolder(), folder).mkdirs();
        }
        if (!new File(this.getDataFolder(), "config.json").exists()) {
            this.saveResource("config.json", false);
            ResourcesExtractor.extractResources(LUA_STATE_FOLDER, new File(this.getDataFolder(), LUA_STATE_FOLDER));
        }
        try {
            config = this.loadConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            if (LOADED_NATIVES.compareAndSet(false, true)) {
                this.getLogger().info("Loading lua native libraries...");
                try {
                    NativeLoader.load((Plugin)this, config);
                }
                catch (Exception e) {
                    this.getPluginLoader().disablePlugin((Plugin)this);
                    throw new RuntimeException("Could not init lua state event: ", e);
                }
                this.getLogger().info("Successfully loaded lua native libraries, lua version: " + LuaState.LUA_VERSION);
            }
            CompletableFuture future = new CompletableFuture();
            this.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                this.asyncInit(config);
                future.complete(null);
            });
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                DebugLogger.debug(2, (Object)"Failed to waiting 'asyncInit' method complete.");
                DebugLogger.debug(e);
            }
            this.getScheduler().runTask((Plugin)this, () -> this.init(config));
        });
    }

    private synchronized void asyncInit(Config config) {
        ReflectUtil reflectUtil;
        if (config.getLuaReflection() != null && (reflectUtil = config.getLuaReflection().toReflectUtil()) != null) {
            LuaJavaAPI.setReflectUtil(reflectUtil);
            DebugLogger.debug("Current using reflection util is %s", reflectUtil);
        }
        this.getLogger().info("Extract resources: luaLibrary");
        ResourcesExtractor.extractResources(LUA_LIB_FOLDER, new File(this.getDataFolder(), LUA_LIB_FOLDER));
        if (config.isDebug()) {
            try {
                DebugLogger.closeLogger();
                DebugLogger.init(this.getLogger(), new File(this.getDataFolder(), "debug.log"), 65535);
                this.getLogger().info("Successfully initialized debug log");
            }
            catch (IOException e) {
                this.getLogger().warning("Could not init debug log!");
            }
        }
        if (config.isBStats()) {
            this.metrics = BStatsMetrics.newInstance(26298);
        }
        if (config.isCheckUpdates()) {
            this.getScheduler().runTaskAsynchronously((Plugin)this, () -> new UpdateChecker().checkForUpdates(LuaInMinecraftBukkit.logger()));
        }
        this.luaStateManager = new LuaStateManager(config);
        this.luaStateManager.preLoad();
    }

    private synchronized void init(Config config) {
        this.getServer().getServicesManager().register(ILuaStateManager.class, (Object)this.luaStateManager, (Plugin)this, ServicePriority.Normal);
        this.luaStateManager.initialization();
    }

    public Config loadConfig() throws IOException {
        List<String> strings = Files.readAllLines(new File(this.getDataFolder(), "config.json").toPath());
        String json = String.join((CharSequence)"\n", strings);
        json = JsonUtil.stripComments(json);
        return (Config)new Gson().fromJson(json, Config.class);
    }

    public static LuaInMinecraftBukkit instance() {
        return plugin;
    }

    public static Logger logger() {
        return plugin.getLogger();
    }

    public File getLuaStateFolder() {
        return new File(this.getDataFolder(), LUA_STATE_FOLDER);
    }

    public ClassLoader classLoader() {
        return this.getClassLoader();
    }

    public String version() {
        String version = this.getDescription().getVersion();
        int i = version.indexOf(43);
        return i == -1 ? version : version.substring(0, i);
    }

    public File getFolder(String folder) {
        return new File(this.getDataFolder(), folder);
    }

    public File getFile(String folder, String ... paths) {
        return new File(this.getFolder(folder), String.join((CharSequence)File.separator, paths));
    }

    public ILuaStateManager getLuaStateManager() {
        return this.luaStateManager;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

