/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import org.bukkit.plugin.Plugin;
import org.eu.smileyik.luaInMinecraftBukkitII.LuaInMinecraftBukkit;
import org.eu.smileyik.luaInMinecraftBukkitII.config.Config;
import org.eu.smileyik.luaInMinecraftBukkitII.config.NativeLibraryConfig;
import org.eu.smileyik.luaInMinecraftBukkitII.module.NativeModule;
import org.eu.smileyik.luaInMinecraftBukkitII.util.HashUtil;

public class NativeLoader {
    public static final String OS_LINUX = "linux";
    public static final String OS_WINDOWS = "windows";
    public static final String OS_MACOS = "macos";
    public static final String OS_OTHERS = "others";
    public static final String ARCH_X64 = "amd64";
    public static final String ARCH_ARM64 = "arm64";
    public static final String ARCH_OTHERS = "others";
    public static final String[] DYNAMIC_FILE_TYPE_LINUX = new String[]{".so"};
    public static final String[] DYNAMIC_FILE_TYPE_WINDOWS = new String[]{".dll"};
    public static final String[] DYNAMIC_FILE_TYPE_MACOS = new String[]{".dylib", ".so"};
    public static final String OS;
    public static final String ARCH;
    private static final int BUFFER_SIZE = 4096;
    private static final String VERSION_FILE = "VERSION";
    private static final String FALLBACK_BASE_URL = "https://raw.githubusercontent.com/SmileYik/LuaInMinecraftBukkitII/refs/heads/gh-page";

    private static void pluginVersionCheck(Plugin instance) {
        if (!(instance instanceof LuaInMinecraftBukkit)) {
            return;
        }
        String version = ((LuaInMinecraftBukkit)instance).version();
        if (version.startsWith("master")) {
            return;
        }
        File file = new File(instance.getDataFolder(), VERSION_FILE);
        boolean needUpdateNatives = true;
        try {
            if (file.exists()) {
                String prevVersion = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
                boolean bl = needUpdateNatives = !Objects.equals(prevVersion, version);
            }
            if (needUpdateNatives) {
                File nativeFolder = new File(instance.getDataFolder(), "natives");
                File[] files = nativeFolder.listFiles();
                if (files != null) {
                    for (File f : files) {
                        if (!f.isFile()) continue;
                        f.delete();
                    }
                }
                Files.write(file.toPath(), version.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                instance.getLogger().info("Native library version need updated, currently: " + version);
            }
        }
        catch (Exception e) {
            instance.getLogger().warning("Failed to check plugin native version: " + e);
        }
    }

    public static void load(Plugin plugin, Config config) throws IOException {
        NativeLoader.pluginVersionCheck(plugin);
        String baseUrl = config.getProjectUrl();
        String luaVer = config.getLuaVersion();
        File baseDir = plugin.getDataFolder();
        File nativeFolder = new File(baseDir, "natives");
        File versionFile = new File(nativeFolder, VERSION_FILE);
        String currentVersion = null;
        if (versionFile.exists()) {
            currentVersion = new String(Files.readAllBytes(versionFile.toPath()));
        }
        NativeLibraryConfig nativeConfig = null;
        try {
            nativeConfig = NativeLoader.getNativeConfig(plugin, baseUrl, nativeFolder);
        }
        catch (Exception e) {
            plugin.getLogger().warning("Failed to download natives.json, try again: " + e.getMessage());
            baseUrl = FALLBACK_BASE_URL;
            nativeConfig = NativeLoader.getNativeConfig(plugin, baseUrl, nativeFolder);
        }
        String[] files = nativeConfig.version(OS, ARCH, luaVer);
        if (files == null) {
            throw new RuntimeException("Sorry, this plugin is not supported on this platform");
        }
        if (!Objects.equals(luaVer, currentVersion)) {
            NativeLoader.clean(nativeFolder);
            Files.write(versionFile.toPath(), luaVer.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        for (String file : files) {
            File lib = new File(nativeFolder, file);
            NativeLoader.checkFile(plugin, lib, config, nativeConfig, config.getLuaVersion());
            System.load(lib.getAbsolutePath());
        }
        Collection<String> availableModules = nativeConfig.availableModules(OS, ARCH);
        for (String module : config.getEnableModules()) {
            NativeModule nativeModule = NativeModule.MODULES.get(module);
            if (nativeModule == null) {
                plugin.getLogger().warning(String.format("Skipping module '%s' because not found.", module));
                continue;
            }
            String realModule = null;
            if (availableModules.contains(module)) {
                realModule = module;
            } else if (availableModules.contains(module + "-" + config.getLuaVersion())) {
                realModule = module + "-" + config.getLuaVersion();
            } else {
                plugin.getLogger().warning(String.format("Skipping module '%s' because not available.", module));
                continue;
            }
            if (!nativeModule.isInitialized()) {
                try {
                    File nativeBaseDir = nativeModule.baseDir();
                    String[] moduleFiles = nativeConfig.module(OS, ARCH, realModule);
                    LinkedList<String> paths = new LinkedList<String>();
                    if (moduleFiles != null) {
                        for (String file : moduleFiles) {
                            if (file == null) continue;
                            File lib = new File(nativeBaseDir, file);
                            NativeLoader.checkFile(plugin, lib, config, nativeConfig, realModule);
                            paths.add(lib.getAbsolutePath());
                        }
                    }
                    nativeModule.initialize(paths);
                }
                catch (Exception e) {
                    plugin.getLogger().warning(String.format("Load module '%s' failed: %s", module, e.getMessage()));
                    continue;
                }
            }
            plugin.getLogger().warning(String.format("Loaded module '%s'(%s) %s.", module, realModule, nativeModule.isInitialized() ? "successfully" : "failed"));
        }
    }

    public static String[] getDynamicFileType() {
        switch (OS) {
            case "windows": {
                return DYNAMIC_FILE_TYPE_WINDOWS;
            }
            case "macos": {
                return DYNAMIC_FILE_TYPE_MACOS;
            }
            case "linux": {
                return DYNAMIC_FILE_TYPE_LINUX;
            }
        }
        return new String[0];
    }

    private static void clean(File nativeFolder) {
        if (!nativeFolder.exists()) {
            return;
        }
        File[] files = nativeFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName().toLowerCase();
                if (!fileName.endsWith(".dll") && !fileName.endsWith(".so") && !fileName.endsWith(".dylib")) continue;
                file.delete();
            }
        }
    }

    private static NativeLibraryConfig getNativeConfig(Plugin plugin, String baseUrl, File nativeFolder) throws IOException {
        File nativeConfigFile = new File(nativeFolder, "natives.json");
        if (!nativeConfigFile.exists()) {
            NativeLoader.downloadLibraryConfig(plugin, baseUrl, nativeConfigFile);
        }
        return (NativeLibraryConfig)new Gson().fromJson((Reader)new FileReader(nativeConfigFile), NativeLibraryConfig.class);
    }

    private static void downloadLibraryConfig(Plugin plugin, String baseUrl, File nativeConfigFile) {
        baseUrl = baseUrl + "/natives/natives.json";
        plugin.getLogger().info(String.format("Not found natives.json, download from %s", baseUrl));
        try {
            byte[] bytes = NativeLoader.downloadFile(baseUrl);
            if (nativeConfigFile.getParent() != null && !nativeConfigFile.getParentFile().exists()) {
                nativeConfigFile.getParentFile().mkdirs();
            }
            Files.write(nativeConfigFile.toPath(), bytes, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed downloads natives config: " + baseUrl, e);
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] downloadFile(String urlStr) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void checkFile(Plugin plugin, File lib, Config config, NativeLibraryConfig libraryConfig, String module) {
        if (!lib.exists() || config.isAlwaysCheckHashes()) {
            ArrayList<String> urls = new ArrayList<String>();
            urls.add(config.getProjectUrl() + "/natives");
            urls.addAll(Arrays.asList(libraryConfig.getUrls()));
            for (String baseUrl : urls) {
                baseUrl = String.join((CharSequence)"/", baseUrl, OS, ARCH, module);
                String fileUrl = baseUrl + "/" + lib.getName();
                String hashUrl = fileUrl + ".hash";
                try {
                    int retry;
                    for (retry = 3; retry > 0; --retry) {
                        if (!lib.exists()) {
                            plugin.getLogger().info(String.format("Not found library: %s, downloading library from %s", lib.getName(), fileUrl));
                            byte[] fileBytes = NativeLoader.downloadFile(fileUrl);
                            Files.write(lib.toPath(), fileBytes, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                        }
                        plugin.getLogger().info("Downloading library hash file from " + hashUrl);
                        String targetHash = new String(NativeLoader.downloadFile(hashUrl));
                        String downloadedHash = HashUtil.sha256(lib);
                        if (Objects.equals(downloadedHash, targetHash)) break;
                        plugin.getLogger().info(String.format("The file failed hash verification. The current file hash value is %s. The expected hash value is %s.", downloadedHash, targetHash));
                        lib.delete();
                    }
                    if (retry != 0) break;
                    plugin.getLogger().warning("The hash of library file is not correct: " + lib);
                }
                catch (Exception exception) {}
            }
        }
        if (!lib.exists()) {
            throw new RuntimeException("Couldn't find library file: " + lib);
        }
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        String os = "others";
        if (osName.contains(OS_WINDOWS)) {
            os = OS_WINDOWS;
        } else if (osName.contains("mac os x") || osName.contains("darwin")) {
            os = OS_MACOS;
        } else if (osName.contains(OS_LINUX)) {
            os = OS_LINUX;
        }
        OS = os;
        String arch = "others";
        if (osArch.contains(ARCH_X64)) {
            arch = ARCH_X64;
        } else if (osArch.contains("aarch64")) {
            arch = ARCH_ARM64;
        }
        ARCH = arch;
    }
}

