/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.command;

import java.io.File;
import java.io.InvalidClassException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.eu.smileyik.luaInMinecraftBukkitII.LuaInMinecraftBukkit;
import org.eu.smileyik.luaInMinecraftBukkitII.api.ILuaStateManager;
import org.eu.smileyik.luaInMinecraftBukkitII.api.luaState.ILuaStateEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.ILuaStateEnvInner;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.command.LuaCommandRegister;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.ILuacage;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.LuacageCommonMeta;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.LuacageJsonMeta;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.CommandService;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.TabSuggest;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.annotation.Command;
import org.eu.smileyik.luaInMinecraftBukkitII.simpledebug.DebugLogger;

@Command(value="Luacage", permission="LuaInMinecraftBukkitII.Admin")
public class LuacageCommand {
    @Command(value="update", description="Update package index")
    public void update(CommandSender sender, String[] args) {
        this.getLuaState(sender, env -> {
            sender.sendMessage("Updating Luacage index... It will take a while...");
            LuaInMinecraftBukkit.instance().getScheduler().runTaskAsynchronously((Plugin)LuaInMinecraftBukkit.instance(), () -> {
                env.getLuacage().update();
                sender.sendMessage("Luacage updated");
            });
        });
    }

    @Command(value="list", description="List packages")
    public void listFirstPage(CommandSender sender, String[] args) {
        this.list(sender, new String[]{"1"});
    }

    @Command(value="list", args={"page"}, description="List packages")
    public void list(CommandSender sender, String[] args) {
        int pageSize = 5;
        this.getLuaState(sender, env -> {
            int page = 1;
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage("Invalid page number");
            }
            List<LuacageJsonMeta> packages = env.getLuacage().getPackages();
            int size = packages.size();
            int pageCount = size / 5 + (size % 5 == 0 ? 0 : 1);
            if (page > pageCount) {
                page = pageCount;
            }
            if (page < 1) {
                page = 1;
            }
            int numLen = Integer.toString(pageCount).length();
            int i = (page - 1) * 5 + 1;
            List<LuacageJsonMeta> result = packages.subList((page - 1) * 5, Math.min(page * 5, size));
            String msg = this.generatePackageInformation(env.getLuacage(), i, result);
            sender.sendMessage(String.format("\nPage %" + numLen + "d of %" + numLen + "d:\n%s", page, pageCount, msg));
        });
    }

    @Command(value="search", args={"keyword"}, description="Search package")
    public void search(CommandSender sender, String[] args) {
        this.getLuaState(sender, env -> {
            String msg = this.generatePackageInformation(env.getLuacage(), 1, env.getLuacage().findPackages(args[0]));
            sender.sendMessage("Search result:\n" + msg);
        });
    }

    @Command(value="installed", args={"lua-env"}, description="List installed packages")
    public void installed(CommandSender sender, String[] args) {
        this.getLuaState(args[0], sender, env -> {
            List<LuacageJsonMeta> installed = env.getLuacage().installedPackages();
            if (installed.isEmpty()) {
                sender.sendMessage("No installed packages.");
            } else {
                sender.sendMessage("Installed " + installed.size() + " packages:\n" + this.generatePackageInformation(env.getLuacage(), 1, installed));
            }
        });
    }

    @Command(value="install", args={"lua-env", "package-name"}, description="Install package")
    public void install(CommandSender sender, String[] args) {
        this.update(sender, args);
        this.getLuaState(args[0], sender, ienv -> {
            ILuaStateEnvInner env = (ILuaStateEnvInner)ienv;
            String source = null;
            String packageFullName = args[1];
            String packageName = packageFullName;
            if (packageName.contains("/")) {
                int idx = packageName.indexOf("/");
                source = packageName.substring(0, idx);
                packageName = packageName.substring(idx + 1);
            }
            String fSource = source;
            String fPackageName = packageName;
            sender.sendMessage("Installing " + packageName + "... It will take a while...");
            LuaInMinecraftBukkit.instance().getScheduler().runTaskAsynchronously((Plugin)LuaInMinecraftBukkit.instance(), () -> {
                LuacageJsonMeta target;
                List<LuacageJsonMeta> results = env.getLuacage().findPackages(fPackageName, null, (short)3);
                if ((fSource == null || Objects.equals("local", fSource)) && results.isEmpty()) {
                    File[] files;
                    File dir = LuaInMinecraftBukkit.instance().getFile("package", "packages");
                    File packageDir = null;
                    if (dir.exists() && (files = dir.listFiles()) != null) {
                        for (File file : files) {
                            if (!file.isDirectory() || !file.getName().equalsIgnoreCase(fPackageName)) continue;
                            packageDir = file;
                            break;
                        }
                    }
                    if (packageDir != null) {
                        env.getLuacage().installPackage(packageDir);
                        sender.sendMessage("Finished installing " + packageFullName + ".");
                        return;
                    }
                }
                if (results.isEmpty()) {
                    sender.sendMessage("No packages named " + fPackageName);
                    return;
                }
                if (results.size() > 1) {
                    String msg;
                    if (fSource == null) {
                        msg = this.generatePackageInformation(env.getLuacage(), 1, results);
                        sender.sendMessage("Multiple packages named " + fPackageName + ":\n" + msg);
                        return;
                    }
                    target = results.stream().filter(it -> Objects.equals(it.getSource(), fSource)).findFirst().orElse(null);
                    if (target == null) {
                        msg = this.generatePackageInformation(env.getLuacage(), 1, results);
                        sender.sendMessage("No packages named " + packageFullName + ":\n" + msg);
                        return;
                    }
                } else {
                    target = results.get(0);
                }
                try {
                    env.getLuacage().installPackage(target, true);
                    sender.sendMessage("Finished installing " + packageFullName + ".");
                }
                catch (Exception e) {
                    sender.sendMessage("Failed to install package `" + fPackageName + "`: " + e);
                    DebugLogger.debug(e);
                }
            });
        });
    }

    @Command(value="uninstall", args={"lua-env", "package-name"}, description="Uninstall package")
    public void uninstall(CommandSender sender, String[] args) {
        this.getLuaState(args[0], sender, env -> {
            String packageFullName = args[1];
            String packageName = packageFullName.contains("/") ? packageFullName.substring(0, packageFullName.indexOf("/")) : packageFullName;
            env.getLuacage().installedPackages().stream().filter(it -> Objects.equals(it.getName(), packageName)).findAny().ifPresent(it -> {
                if (env.getLuacage().uninstallPackage((LuacageJsonMeta)it)) {
                    sender.sendMessage("Uninstalled " + packageFullName + ".");
                } else {
                    sender.sendMessage("Failed uninstalled " + packageFullName + ". You can see details in you console.");
                }
            });
        });
    }

    @Command(value="autoRemove", args={"lua-env"}, description="Auto remove useless packages")
    public void autoRemove(CommandSender sender, String[] args) {
        this.getLuaState(args[0], sender, env -> {
            List<LuacageJsonMeta> removed = env.getLuacage().removeUselessPackages();
            if (removed.isEmpty()) {
                sender.sendMessage("No useless packages found.");
            } else {
                String msg = this.generatePackageInformation(env.getLuacage(), 1, removed);
                sender.sendMessage(String.format("Removed %s packages:\n%s", removed.size(), msg));
            }
        });
    }

    protected String generatePackageInformation(ILuacage luacage, int startIdx, List<LuacageJsonMeta> packages) {
        int len = String.valueOf(startIdx + packages.size()).length();
        StringBuilder msg = new StringBuilder();
        for (LuacageJsonMeta pkg : packages) {
            boolean installed = luacage.installedPackages().parallelStream().anyMatch(it -> Objects.equals(it.getName(), pkg.getName()));
            msg.append(String.format("\n%" + len + "d. %s/%s %s %s:\n  %s", startIdx++, pkg.getSource(), pkg.getName(), pkg.getVersion(), installed ? "\u00a72[\u00a7nInstalled]\u00a7r" : "", pkg.getDescription()));
        }
        return msg.length() == 0 ? "" : msg.substring(1);
    }

    protected boolean getLuaState(CommandSender sender, Consumer<ILuaStateEnv> consumer) {
        LuaInMinecraftBukkit plugin = LuaInMinecraftBukkit.instance();
        ILuaStateManager manager = plugin.getLuaStateManager();
        if (manager == null) {
            sender.sendMessage("No Lua state manager available");
            return false;
        }
        Optional<ILuaStateEnv> result = manager.getScriptEnvs().stream().findFirst();
        if (!result.isPresent()) {
            sender.sendMessage("No Lua state environment available");
            return false;
        }
        consumer.accept(result.get());
        return true;
    }

    protected boolean getLuaState(String envId, CommandSender sender, Consumer<ILuaStateEnv> consumer) {
        LuaInMinecraftBukkit plugin = LuaInMinecraftBukkit.instance();
        ILuaStateManager manager = plugin.getLuaStateManager();
        if (manager == null) {
            sender.sendMessage("No Lua state manager available");
            return false;
        }
        ILuaStateEnv env = manager.getEnv(envId);
        if (env == null) {
            sender.sendMessage("No Lua state environment available: " + envId);
            return false;
        }
        consumer.accept(env);
        return true;
    }

    public static void register(final LuaInMinecraftBukkit plugin) throws InvalidClassException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        CommandService commandService = CommandService.newInstance(LuaCommandRegister.DEFAULT_TRANSLATOR, LuaCommandRegister.DEFAULT_FORMAT, LuacageCommand.class);
        commandService.registerTabSuggest(new TabSuggest(){

            @Override
            public String getKeyword() {
                return "lua-env";
            }

            @Override
            public List<String> suggest() {
                return new ArrayList<String>(plugin.getLuaStateManager().getScriptEnvIds());
            }
        });
        commandService.registerTabSuggest(new TabSuggest(){

            @Override
            public String getKeyword() {
                return "package-name";
            }

            @Override
            public List<String> suggest(String[] args, int commandIdx) {
                String envId = args[1];
                ILuaStateEnv env = plugin.getLuaStateManager().getEnv(envId);
                List<String> suggestions = Collections.emptyList();
                if (env != null) {
                    String command = args[0];
                    if ("install".equalsIgnoreCase(command)) {
                        String[] list;
                        HashSet<String> checked = new HashSet<String>();
                        suggestions = env.getLuacage().getPackages().stream().map(it -> {
                            checked.add(it.getName());
                            return it.getSource() + "/" + it.getName();
                        }).collect(Collectors.toList());
                        File dir = LuaInMinecraftBukkit.instance().getFile("package", "packages");
                        if (dir.exists() && (list = dir.list()) != null) {
                            for (String s : list) {
                                if (!checked.add(s)) continue;
                                suggestions.add("local/" + s);
                            }
                        }
                    } else if ("uninstall".equalsIgnoreCase(command)) {
                        suggestions = env.getLuacage().installedPackages().stream().map(LuacageCommonMeta::getName).collect(Collectors.toList());
                    }
                }
                return suggestions;
            }
        });
        commandService.registerToBukkit((Plugin)plugin);
    }
}

