/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;

public class LuacageConfig {
    private static final Source DEFAULT_SOURCE = new Source();
    private boolean enable = true;
    private Source[] sources;

    public Source[] getSources() {
        if (this.sources == null) {
            this.sources = new Source[]{DEFAULT_SOURCE};
            return this.sources;
        }
        HashSet<String> checked = new HashSet<String>();
        ArrayList<Source> list = new ArrayList<Source>();
        for (Source source : this.sources) {
            if (source == null || source.name == null || source.url == null || Objects.equals("local", source.name) || !checked.add(source.name)) continue;
            String url = source.url;
            if (!url.endsWith("/")) {
                Source source2 = source;
                source2.url = source2.url + "/";
            }
            list.add(source);
        }
        if (!checked.contains("default")) {
            list.add(DEFAULT_SOURCE);
        }
        return list.toArray(new Source[0]);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setSources(Source[] sources) {
        this.sources = sources;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LuacageConfig)) {
            return false;
        }
        LuacageConfig other = (LuacageConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        return Arrays.deepEquals(this.getSources(), other.getSources());
    }

    protected boolean canEqual(Object other) {
        return other instanceof LuacageConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getSources());
        return result;
    }

    public String toString() {
        return "LuacageConfig(enable=" + this.isEnable() + ", sources=" + Arrays.deepToString(this.getSources()) + ")";
    }

    static {
        DEFAULT_SOURCE.name = "default";
        DEFAULT_SOURCE.url = "https://raw.githubusercontent.com/SmileYik/LuaInMinecraftBukkitII-Luacage/refs/heads/repo/";
    }

    public static final class Source {
        private String name;
        private String url;

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Source)) {
                return false;
            }
            Source other = (Source)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        public String toString() {
            return "LuacageConfig.Source(name=" + this.getName() + ", url=" + this.getUrl() + ")";
        }
    }
}

