/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.luaState;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.eu.smileyik.luaInMinecraftBukkitII.LuaInMinecraftBukkit;
import org.eu.smileyik.luaInMinecraftBukkitII.NativeLoader;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.ILuaEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.LuaHelper;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.LuaIOHelper;
import org.eu.smileyik.luaInMinecraftBukkitII.api.luaState.ILuaStateEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.config.LuaInitConfig;
import org.eu.smileyik.luaInMinecraftBukkitII.config.LuaStateConfig;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.ILuaStateEnvInner;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.SimpleLuaEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.WrapperedRequireFunction;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.autoReload.AutoReloadManager;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.event.LuaEventListener;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.ILuacage;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.Luacage;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.pool.LuaPool;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.CommandService;
import org.eu.smileyik.luaInMinecraftBukkitII.simpledebug.DebugLogger;
import org.eu.smileyik.luajava.LuaException;
import org.eu.smileyik.luajava.LuaObject;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.LuaStateFactory;
import org.eu.smileyik.luajava.exception.Result;
import org.eu.smileyik.luajava.type.ILuaCallable;
import org.eu.smileyik.luajava.type.LuaTable;
import org.jetbrains.annotations.NotNull;

public class LuaStateEnv
implements AutoCloseable,
ILuaStateEnv,
ILuaStateEnvInner {
    private final Logger log = LuaInMinecraftBukkit.instance().getLogger();
    private final ILuaEnv luaEnv = new SimpleLuaEnv(this);
    private LuaPool luaPool;
    private final String id;
    private final LuaStateConfig config;
    private final long[] initFileLoadedTimestamps;
    private final Object[] initFileLoadedLock;
    private final File rootDir;
    private final AutoReloadManager autoReloadManager;
    private final Map<String, Listener> listeners = new HashMap<String, Listener>();
    private final Map<String, CommandService> commandServices = new HashMap<String, CommandService>();
    private final List<ILuaCallable> cleaners = new LinkedList<ILuaCallable>();
    private final List<ILuaCallable> softReloadCallables = new LinkedList<ILuaCallable>();
    private LuaStateFacade lua;
    private ILuacage luacage;
    private boolean initialized = false;

    public LuaStateEnv(String id, LuaStateConfig config) {
        this.id = id;
        this.config = config;
        this.initFileLoadedTimestamps = new long[config.getInitialization().length];
        this.initFileLoadedLock = new Object[config.getInitialization().length];
        for (int i = 0; i < this.initFileLoadedLock.length; ++i) {
            this.initFileLoadedLock[i] = new Object();
        }
        this.rootDir = new File(LuaInMinecraftBukkit.instance().getLuaStateFolder(), this.config.getRootDir());
        if (!this.rootDir.exists() && !this.rootDir.mkdirs()) {
            DebugLogger.debug("Cannot create new directory: %s", this.rootDir);
        }
        this.autoReloadManager = this.createAutoReloadManager();
        DebugLogger.debug("Create Lua environment '%s' from config: %s", id, config);
    }

    private AutoReloadManager createAutoReloadManager() {
        if (this.config.getAutoReload() != null && this.config.getAutoReload().isEnable()) {
            return new AutoReloadManager(this.id, this.rootDir, this.config);
        }
        return null;
    }

    @Override
    public synchronized void createEnv() {
        if (this.lua != null && !this.lua.isClosed()) {
            return;
        }
        this.lua = this.createLuaState();
        this.luaPool = this.createLuaPool();
        LuaInMinecraftBukkit instance = LuaInMinecraftBukkit.instance();
        this.luacage = new Luacage(this, instance.getLuaStateManager().getConfig().getLuacage(), new File(instance.getDataFolder(), "package"), instance.getLogger());
    }

    protected LuaPool createLuaPool() {
        LuaPool luaPool = null;
        if (this.config.getPool() != null && this.config.getPool().isEnable()) {
            try {
                luaPool = LuaPool.create(this, this.config.getPool());
            }
            catch (ClassNotFoundException e) {
                this.log.warning("Not found Lua pool type: " + this.config.getPool().getType());
                DebugLogger.debug(e);
            }
            catch (NoSuchMethodException e) {
                this.log.warning("Cannot found construction in Lua pool type: " + this.config.getPool().getType());
                DebugLogger.debug(e);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                this.log.warning("Cannot instantiate Lua pool type: " + this.config.getPool().getType());
                DebugLogger.debug(e);
            }
        }
        return luaPool;
    }

    @Override
    public LuaStateFacade createLuaState() {
        LuaStateFacade lua = LuaStateFactory.newLuaState(!this.config.isIgnoreAccessLimit());
        String luaLibrary = new File(LuaInMinecraftBukkit.instance().getDataFolder(), "luaLibrary").getAbsolutePath();
        lua.lock(l -> {
            lua.openLibs();
            lua.setThrowableHook(exp -> {
                DebugLogger.debug(exp);
                while (exp.getCause() != null) {
                    exp = exp.getCause();
                }
                return exp;
            });
            lua.getGlobal("package", LuaTable.class).mapResultValue(table -> table.get("cpath").mapValue(path -> {
                for (String fileType : NativeLoader.getDynamicFileType()) {
                    path = path + ";" + this.rootDir.getAbsolutePath() + "/?" + fileType;
                    path = path + ";" + luaLibrary + "/?" + fileType;
                }
                return path;
            }).mapResultValue(cpath -> table.put("cpath", cpath)).mapResultValue(it -> table.get("path").mapValue(path -> path + ";" + this.rootDir.getAbsolutePath() + "/?.lua;" + luaLibrary + "/?.lua;?.lua").mapResultValue(path -> table.put("path", path)))).ifFailureThen(it -> {
                DebugLogger.debug(1, "Error initializing lua package path: %s", it.getMessage());
                DebugLogger.debug(2, it);
            });
            lua.getGlobal("require", ILuaCallable.class).mapResultValue(callable -> lua.setGlobal("require", new WrapperedRequireFunction(lua, (ILuaCallable)callable, this.rootDir, this))).ifFailureThen(it -> {
                DebugLogger.debug(1, "Error initializing lua package path: %s", it.getMessage());
                DebugLogger.debug(2, it);
            });
            LuaInMinecraftBukkit plugin = LuaInMinecraftBukkit.instance();
            lua.newTable();
            lua.toJavaObject(-1).mapResultValue(obj -> {
                LuaTable table = ((LuaTable)obj).asTable();
                return table.put("env", this.luaEnv).mapResultValue(it -> table.put("helper", LuaHelper.class)).mapResultValue(it -> table.put("io", LuaIOHelper.class)).mapResultValue(it -> table.put("bukkit", Bukkit.class)).mapResultValue(it -> table.put("plugin", (Object)plugin)).mapResultValue(it -> table.put("server", plugin.getServer())).mapResultValue(it -> table.put("log", plugin.getLogger())).mapResultValue(it -> table.put("out", System.out)).mapResultValue(it -> Result.success(table));
            }).mapResultValue(table -> lua.setGlobal("luaBukkit", (LuaObject)table)).ifFailureThen(err -> {
                DebugLogger.debug(1, "Error initializing global variable 'luaBukkit': %s", err.getMessage());
                DebugLogger.debug(2, err);
            });
            lua.setJustUseFirstMethod(this.config.isJustUseFirstMethod());
            lua.setTop(0);
        });
        return lua;
    }

    @Override
    public LuaStateFacade getLuaState() {
        return this.lua;
    }

    @Override
    public synchronized void initialization() {
        this.luacage.loadPackages();
        if (this.initialized) {
            return;
        }
        boolean initialized = true;
        LuaInMinecraftBukkit plugin = LuaInMinecraftBukkit.instance();
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        for (int i = 0; i < this.initFileLoadedTimestamps.length; ++i) {
            if (this.initFileLoadedTimestamps[i] != 0L) continue;
            LuaInitConfig luaInitConfig = this.config.getInitialization()[i];
            boolean flag = true;
            for (String pluginName : luaInitConfig.getDepends()) {
                if (pluginManager.isPluginEnabled(pluginName)) continue;
                flag = false;
                break;
            }
            if (flag) {
                int finalI = i;
                if (luaInitConfig.isAsyncLoad()) {
                    plugin.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> this.evalInitFile(luaInitConfig, finalI));
                    continue;
                }
                this.evalInitFile(luaInitConfig, finalI);
                continue;
            }
            initialized = false;
        }
        this.initialized = initialized;
        if (initialized) {
            DebugLogger.debug("[Lua env %s] lua file all initialized", this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalInitFile(LuaInitConfig luaInitConfig, int idx) {
        Object object = this.initFileLoadedLock[idx];
        synchronized (object) {
            this.evalFile(luaInitConfig.getFile()).ifSuccessThen(it -> {
                this.initFileLoadedTimestamps[idx] = System.currentTimeMillis();
                DebugLogger.debug("[Lua env %s] lua file initialized: %s", this.id, luaInitConfig.getFile());
            });
        }
    }

    @Override
    public void checkScriptFilesUpdate() {
        for (int i = 0; i < this.initFileLoadedTimestamps.length; ++i) {
            LuaInitConfig luaInitConfig;
            File file;
            long lasted;
            if (this.initFileLoadedTimestamps[i] == 0L || (lasted = (file = this.luaEnv.file((luaInitConfig = this.config.getInitialization()[i]).getFile())).lastModified()) <= this.initFileLoadedTimestamps[i]) continue;
            this.initFileLoadedTimestamps[i] = System.currentTimeMillis();
        }
    }

    @Override
    public Result<Integer, LuaException> evalFile(String file) {
        File scriptFile = new File(file);
        if (!scriptFile.exists()) {
            scriptFile = new File(this.rootDir, file);
        }
        String absolutePath = scriptFile.toString();
        if (scriptFile.exists()) {
            return this.lua.evalFile(absolutePath).ifFailureThen(err -> {
                this.log.warning(String.format("Failed to eval lua file '%s', because: %s", file, err.getMessage()));
                DebugLogger.debug(2, err);
            });
        }
        this.log.warning(String.format("Cannot find file: %s", file));
        return Result.success(-1);
    }

    @Override
    public Result<Integer, LuaException> evalLua(@NotNull String luaScript) {
        return this.lua.evalString(luaScript).ifFailureThen(err -> {
            this.log.warning(String.format("Failed to eval lua script '%s', because: %s", luaScript, err.getMessage()));
            DebugLogger.debug(2, err);
        });
    }

    @Override
    public Result<Object, Exception> callClosure(String globalClosureName, Object ... params) {
        return this.lua.getGlobal(globalClosureName).mapResultValue(it -> it instanceof ILuaCallable ? Result.success((ILuaCallable)it) : Result.failure(new ClassCastException(String.format("Cannot cast type '%s' to type: ILuaCallable", it == null ? null : it.getClass())))).mapResultValue(callable -> callable.call(params)).justCast();
    }

    @Override
    public synchronized void close() {
        this.close(false);
    }

    private synchronized void close(boolean isReload) {
        if (!isReload && this.autoReloadManager != null) {
            this.autoReloadManager.shutdown();
        }
        this.softReloadCallables.clear();
        for (ILuaCallable cleaner : this.cleaners) {
            cleaner.call(new Object[0]);
        }
        this.cleaners.clear();
        this.listeners.forEach((name, listener) -> {
            HandlerList.unregisterAll((Listener)listener);
            if (listener instanceof LuaEventListener) {
                ((LuaEventListener)listener).clear();
            }
        });
        this.listeners.clear();
        this.commandServices.forEach((name, commandService) -> commandService.shutdown());
        this.commandServices.clear();
        if (this.luaPool != null) {
            this.luaPool.close();
            this.luaPool = null;
        }
        if (this.lua != null) {
            this.lua.close();
            this.lua = null;
        }
        this.initialized = false;
        Arrays.fill(this.initFileLoadedTimestamps, 0L);
    }

    @Override
    public synchronized void reload() {
        this.close(true);
        this.createEnv();
        this.initialization();
    }

    protected synchronized void registerSoftReload(@NotNull ILuaCallable luaCallable) {
        this.softReloadCallables.add(luaCallable);
    }

    @Override
    public synchronized void softReload() {
        this.softReloadCallables.forEach(it -> {
            try {
                it.call(new Object[0]);
            }
            catch (Exception err) {
                this.log.severe(String.format("Failed when calling soft reload callable: %s", err.getMessage()));
                DebugLogger.debug(2, err);
            }
        });
    }

    public void setJustUseFirstMethod(boolean flag) {
        this.lua.setJustUseFirstMethod(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<Object, LuaException> ignoreMultiResultRun(ILuaCallable callable) {
        this.lua.lock();
        try {
            boolean flag = this.lua.isJustUseFirstMethod();
            this.lua.setJustUseFirstMethod(true);
            Result<Object, LuaException> result = callable.call(new Object[0]).justCast();
            this.lua.setJustUseFirstMethod(flag);
            Result<Object, LuaException> result2 = result;
            return result2;
        }
        finally {
            this.lua.unlock();
        }
    }

    protected LuaPool getLuaPool() {
        return this.luaPool;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public LuaStateConfig getConfig() {
        return this.config;
    }

    @Override
    public File getRootDir() {
        return this.rootDir;
    }

    protected AutoReloadManager getAutoReloadManager() {
        return this.autoReloadManager;
    }

    protected Map<String, Listener> getListeners() {
        return this.listeners;
    }

    protected Map<String, CommandService> getCommandServices() {
        return this.commandServices;
    }

    protected List<ILuaCallable> getCleaners() {
        return this.cleaners;
    }

    @Override
    public ILuacage getLuacage() {
        return this.luacage;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }
}

