/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.luaState;

import java.io.File;
import org.bukkit.Bukkit;
import org.eu.smileyik.luaInMinecraftBukkitII.LuaInMinecraftBukkit;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.LuaHelper;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.LuaIOHelper;
import org.eu.smileyik.luaInMinecraftBukkitII.api.luaState.ILuaStateEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.api.luaState.ILuaStatePluginEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.ILuaStateEnvInner;
import org.eu.smileyik.luaInMinecraftBukkitII.simpledebug.DebugLogger;
import org.eu.smileyik.luajava.LuaException;
import org.eu.smileyik.luajava.LuaObject;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.LuaStateFactory;
import org.eu.smileyik.luajava.exception.Result;
import org.eu.smileyik.luajava.type.ILuaCallable;
import org.eu.smileyik.luajava.type.LuaTable;
import org.jetbrains.annotations.NotNull;

public class PluginLuaEnv
implements ILuaStateEnvInner,
ILuaStateEnv,
ILuaStatePluginEnv {
    private final boolean ignoreAccessLimit;
    private LuaStateFacade lua;

    public PluginLuaEnv(boolean ignoreAccessLimit) {
        this.ignoreAccessLimit = ignoreAccessLimit;
    }

    @Override
    public void createEnv() {
        if (this.lua != null && !this.lua.isClosed()) {
            return;
        }
        this.lua = this.createLuaState();
    }

    @Override
    public LuaStateFacade createLuaState() {
        LuaStateFacade lua = LuaStateFactory.newLuaState(!this.ignoreAccessLimit);
        String luaLibrary = new File(LuaInMinecraftBukkit.instance().getLuaStateFolder(), "luaLibrary").getAbsolutePath();
        lua.openLibs();
        lua.setThrowableHook(exp -> {
            DebugLogger.debug(exp);
            while (exp.getCause() != null) {
                exp = exp.getCause();
            }
            return exp;
        });
        lua.getGlobal("package", LuaTable.class).mapResultValue(table -> table.get("path").mapValue(path -> path + ";" + luaLibrary + "/?.lua").mapResultValue(path -> table.put("path", path))).ifFailureThen(it -> {
            DebugLogger.debug(1, "Error initializing lua package path: %s", it.getMessage());
            DebugLogger.debug(2, it);
        });
        LuaInMinecraftBukkit plugin = LuaInMinecraftBukkit.instance();
        lua.newTable();
        lua.toJavaObject(-1).mapResultValue(obj -> {
            LuaTable table = ((LuaTable)obj).asTable();
            return table.put("helper", LuaHelper.class).mapResultValue(it -> table.put("io", LuaIOHelper.class)).mapResultValue(it -> table.put("bukkit", Bukkit.class)).mapResultValue(it -> table.put("plugin", (Object)plugin)).mapResultValue(it -> table.put("server", plugin.getServer())).mapResultValue(it -> table.put("log", plugin.getLogger())).mapResultValue(it -> table.put("out", System.out)).mapResultValue(it -> Result.success(table));
        }).mapResultValue(table -> lua.setGlobal("luaBukkit", (LuaObject)table)).ifFailureThen(err -> {
            DebugLogger.debug(1, "Error initializing global variable 'luaBukkit': %s", err.getMessage());
            DebugLogger.debug(2, err);
        });
        return lua;
    }

    @Override
    public void initialization() {
    }

    @Override
    public LuaStateFacade getLuaState() {
        return this.lua;
    }

    @Override
    public void checkScriptFilesUpdate() {
    }

    @Override
    public synchronized void close() {
        if (this.lua != null) {
            this.callClosure("onClose", new Object[0]);
            this.lua.close();
            this.lua = null;
        }
    }

    @Override
    public synchronized void reload() {
        this.close();
        this.createEnv();
    }

    @Override
    public void softReload() {
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public Result<Integer, LuaException> evalFile(String file) {
        return this.lua.evalFile(file).ifFailureThen(err -> {
            LuaInMinecraftBukkit.instance().getLogger().warning(String.format("Failed to eval lua file '%s', because: %s", file, err.getMessage()));
            DebugLogger.debug(2, err);
        });
    }

    @Override
    public Result<Integer, LuaException> evalLua(@NotNull String luaScript) {
        return this.lua.evalString(luaScript).ifFailureThen(err -> {
            LuaInMinecraftBukkit.instance().getLogger().warning(String.format("Failed to eval lua script '%s', because: %s", luaScript, err.getMessage()));
            DebugLogger.debug(2, err);
        });
    }

    @Override
    public Result<Object, Exception> callClosure(String globalClosureName, Object ... params) {
        return this.lua.getGlobal(globalClosureName).mapResultValue(it -> it instanceof ILuaCallable ? Result.success((ILuaCallable)it) : Result.failure(new ClassCastException(String.format("Cannot cast type '%s' to type: ILuaCallable", it == null ? null : it.getClass())))).mapResultValue(callable -> callable.call(params)).justCast();
    }

    @Override
    public boolean isIgnoreAccessLimit() {
        return this.ignoreAccessLimit;
    }

    @Override
    public LuaStateFacade getLua() {
        return this.lua;
    }
}

