/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.luaState;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.eu.smileyik.luaInMinecraftBukkitII.LuaInMinecraftBukkit;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.ILuaEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.command.ILuaCommandClassBuilder;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.event.ILuaEventListenerBuilder;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.LuaStateEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.command.LuaCommandClassBuilder;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.command.LuaCommandRegister;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.event.LuaEventListener;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.event.LuaEventListenerBuilder;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.pool.PooledLuaCallable;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.CommandService;
import org.eu.smileyik.luaInMinecraftBukkitII.simpledebug.DebugLogger;
import org.eu.smileyik.luajava.LuaException;
import org.eu.smileyik.luajava.exception.Result;
import org.eu.smileyik.luajava.type.ILuaCallable;

public class SimpleLuaEnv
implements ILuaEnv {
    private final LuaStateEnv env;

    public SimpleLuaEnv(LuaStateEnv env) {
        this.env = env;
    }

    @Override
    public void registerEventListener(String name, Listener listener) {
        Listener oldOne = this.env.getListeners().put(name, listener);
        LuaInMinecraftBukkit.instance().getServer().getPluginManager().registerEvents(listener, (Plugin)LuaInMinecraftBukkit.instance());
        if (oldOne != null) {
            HandlerList.unregisterAll((Listener)oldOne);
        }
    }

    @Override
    public void unregisterEventListener(String name) {
        Listener remove = this.env.getListeners().remove(name);
        if (remove != null) {
            HandlerList.unregisterAll((Listener)remove);
            if (remove instanceof LuaEventListener) {
                ((LuaEventListener)remove).clear();
            }
        }
    }

    @Override
    public ILuaEventListenerBuilder listenerBuilder() {
        return new LuaEventListenerBuilder(this);
    }

    @Override
    public ILuaCommandClassBuilder commandClassBuilder() {
        return new LuaCommandClassBuilder();
    }

    @Override
    public Result<Boolean, Exception> registerCommand(String rootCommand, Class<?> ... classes) {
        return this.registerCommand(rootCommand, (String[])null, classes);
    }

    @Override
    public void registerRawCommand(String command, ILuaCallable callable) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        LuaCommandRegister.register(command, callable);
    }

    @Override
    public Result<Boolean, Exception> registerCommand(String rootCommand, String[] aliases, Class<?> ... classes) {
        try {
            CommandService commandService = LuaCommandRegister.register(rootCommand, aliases, classes);
            CommandService oldOne = this.env.getCommandServices().put(rootCommand, commandService);
            if (oldOne != null) {
                oldOne.shutdown();
            }
            return Result.success(true);
        }
        catch (Exception e) {
            LuaInMinecraftBukkit.instance().getLogger().warning("Failed to register command " + rootCommand + ": " + e.getMessage());
            DebugLogger.debug(e);
            return Result.failure(e);
        }
    }

    @Override
    public void registerCleaner(ILuaCallable cleaner) {
        this.env.getCleaners().add(cleaner);
    }

    @Override
    public Result<Void, String> registerSoftReload(ILuaCallable luaCallable) {
        if (luaCallable == null) {
            return Result.failure("lua callable is null");
        }
        this.env.registerSoftReload(luaCallable);
        return Result.success(null);
    }

    @Override
    public ILuaCallable pooledCallable(ILuaCallable callable) {
        if (this.env.getLuaPool() == null) {
            LuaInMinecraftBukkit.instance().getLogger().warning(String.format("Lua environment '%s' don't enable lua pool, will using current lua state to call this closure.", this.env.getId()));
            return callable;
        }
        return PooledLuaCallable.of(callable, this.env.getLuaPool());
    }

    @Override
    public String path(String path) {
        return this.file(path).toString();
    }

    @Override
    public String path(String ... paths) {
        return this.file(paths).toString();
    }

    @Override
    public File file(String path) {
        return new File(this.env.getRootDir(), path);
    }

    @Override
    public File file(String ... paths) {
        return new File(this.env.getRootDir(), String.join((CharSequence)File.separator, paths));
    }

    @Override
    public void setJustUseFirstMethod(boolean flag) {
        this.env.setJustUseFirstMethod(flag);
    }

    @Override
    public Result<Object, LuaException> ignoreMultiResultRun(ILuaCallable callable) {
        return this.env.ignoreMultiResultRun(callable);
    }
}

