/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.luaState;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.LuaIOHelper;
import org.eu.smileyik.luaInMinecraftBukkitII.api.luaState.ILuaStateEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.ILuacage;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.LuacageJsonMeta;
import org.eu.smileyik.luaInMinecraftBukkitII.simpledebug.DebugLogger;
import org.eu.smileyik.luajava.JavaFunction;
import org.eu.smileyik.luajava.LuaException;
import org.eu.smileyik.luajava.LuaState;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.exception.Result;
import org.eu.smileyik.luajava.type.ILuaCallable;

public class WrapperedRequireFunction
extends JavaFunction {
    private static int COUNTER = 0;
    private static final char[] CHARS = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private final ILuaCallable originRequire;
    private final File tempDir;
    private final File rootDir;
    private final ILuaStateEnv env;

    public WrapperedRequireFunction(LuaStateFacade L, ILuaCallable originRequire, File rootDir, ILuaStateEnv env) {
        super(L);
        this.originRequire = originRequire;
        this.rootDir = rootDir;
        this.tempDir = new File(rootDir, "temp");
        this.env = env;
        if (!this.tempDir.exists()) {
            this.tempDir.mkdirs();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int execute() throws LuaException {
        LuaState l = this.L.getLuaState();
        int top = l.getTop();
        if (top <= 1) {
            throw new LuaException("Attempted to call require() on an empty state");
        }
        if (!l.isString(-1)) {
            throw new LuaException("Attempted to call require() on an invalid state, the first param type should be a string");
        }
        String module = l.toString(-1);
        if (module.startsWith("http")) {
            DebugLogger.debug("Requesting module: " + module);
            File downloaded = null;
            try {
                downloaded = this.download(module);
                String str1 = this.rootDir.getAbsolutePath();
                String str2 = downloaded.getAbsolutePath();
                module = str2.substring(str1.length() + 1);
                Result result = this.originRequire.call(module).mapResultValue(this.L::rawPushObjectValue);
                if (!result.isError()) return 1;
                this.originRequire.call(module.replaceAll("[/\\\\]", ".")).mapResultValue(this.L::rawPushObjectValue).justThrow(LuaException.class);
                return 1;
            }
            catch (IOException e) {
                DebugLogger.debug(e);
                throw new LuaException("Failed to download file: " + module + ": " + e.getMessage(), e);
            }
            finally {
                DebugLogger.debug("Finished requesting module: " + module);
            }
        } else {
            if (module.startsWith("@")) {
                String finalModule = module.substring(1);
                ILuacage luacage = this.env.getLuacage();
                LuacageJsonMeta pkg = luacage.installedPackages().parallelStream().filter(it -> finalModule.startsWith(it.getName() + ".") || finalModule.startsWith(it.getName() + "/")).findAny().orElse(null);
                if (pkg != null) {
                    File parentFile = luacage.getInstallDir(pkg).getParentFile();
                    module = parentFile.getAbsolutePath() + "/" + module.substring(1);
                    module = module.substring(new File(".").getAbsolutePath().length() - 1);
                }
            }
            this.originRequire.call(module).mapResultValue(this.L::rawPushObjectValue).justThrow(LuaException.class);
        }
        return 1;
    }

    private synchronized File download(String urlStr) throws IOException {
        String fileName = urlStr.replaceAll("[/\\\\]", "/");
        if (fileName.contains("/")) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        String fileNameWithSuffix = fileName;
        if (fileName.contains(".")) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        File out = new File(this.tempDir, fileNameWithSuffix);
        URL url = new URL(urlStr);
        URLConnection urlConnection = url.openConnection();
        try (BufferedInputStream bis = new BufferedInputStream(urlConnection.getInputStream());
             BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(out.toPath(), new OpenOption[0]));){
            LuaIOHelper.transfer(bis, bos, 2048);
        }
        return new File(this.tempDir, fileName);
    }
}

