/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.luaState.event;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.event.EventPriority;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.ILuaEnv;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.event.ILuaEventListenerBuilder;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.event.LuaEventListenerProperty;
import org.eu.smileyik.luaInMinecraftBukkitII.api.lua.luaState.event.LuaUnregisteredListener;
import org.eu.smileyik.luaInMinecraftBukkitII.reflect.LuaTable2Object;
import org.eu.smileyik.luajava.type.ILuaCallable;
import org.eu.smileyik.luajava.type.LuaTable;
import org.jetbrains.annotations.NotNull;

public class LuaEventListenerBuilder
implements ILuaEventListenerBuilder {
    private static final String[] EVENT_CLASS_PREFIX = new String[]{"org.bukkit.event.", "org.bukkit.event.player.", "org.bukkit.event.event.", "org.bukkit.event.world.", "org.bukkit.event.inventory."};
    private final List<EventConfig> eventConfigs = new LinkedList<EventConfig>();
    private final ILuaEnv luaEnv;

    public LuaEventListenerBuilder(ILuaEnv luaEnv) {
        this.luaEnv = luaEnv;
    }

    @Override
    public ILuaEventListenerBuilder subscribe(@NotNull String eventClassName, @NotNull ILuaCallable closure) throws ClassNotFoundException {
        Class<?> eventClass = LuaEventListenerBuilder.findEventClass(eventClassName);
        return this.doSubscribe(eventClass, closure, null, null);
    }

    @Override
    public ILuaEventListenerBuilder subscribe(@NotNull String eventClassName, @NotNull EventPriority eventPriority, @NotNull ILuaCallable closure) throws ClassNotFoundException {
        Class<?> eventClass = LuaEventListenerBuilder.findEventClass(eventClassName);
        return this.doSubscribe(eventClass, closure, eventPriority, null);
    }

    @Override
    public ILuaEventListenerBuilder subscribe(@NotNull String eventClassName, @NotNull String eventPriority, @NotNull ILuaCallable closure) throws ClassNotFoundException {
        EventPriority priority = EventPriority.valueOf((String)eventPriority.toUpperCase());
        return this.subscribe(eventClassName, priority, closure);
    }

    @Override
    public ILuaEventListenerBuilder subscribe(@NotNull String eventClassName, @NotNull EventPriority eventPriority, boolean ignoreCancelled, @NotNull ILuaCallable closure) throws ClassNotFoundException {
        Class<?> eventClass = LuaEventListenerBuilder.findEventClass(eventClassName);
        return this.doSubscribe(eventClass, closure, eventPriority, ignoreCancelled);
    }

    @Override
    public ILuaEventListenerBuilder subscribe(@NotNull String eventClassName, @NotNull String eventPriority, boolean ignoreCancelled, @NotNull ILuaCallable closure) throws ClassNotFoundException {
        EventPriority priority = EventPriority.valueOf((String)eventPriority.toUpperCase());
        return this.subscribe(eventClassName, priority, ignoreCancelled, closure);
    }

    @Override
    public ILuaEventListenerBuilder subscribe(@NotNull String eventClassName, boolean ignoreCancelled, @NotNull ILuaCallable closure) throws ClassNotFoundException {
        Class<?> eventClass = LuaEventListenerBuilder.findEventClass(eventClassName);
        return this.doSubscribe(eventClass, closure, null, ignoreCancelled);
    }

    @Override
    public ILuaEventListenerBuilder subscribe(@NotNull LuaTable table) throws Exception {
        LuaEventListenerProperty property = LuaTable2Object.covert(table, LuaEventListenerProperty.class).getOrThrow();
        if (property.getEvent() == null) {
            throw new IllegalArgumentException("'event' property must not be nil'");
        }
        if (property.getHandler() == null) {
            throw new IllegalArgumentException("'handler' property must not be nil'");
        }
        Class<?> eventClass = LuaEventListenerBuilder.findEventClass(property.getEvent());
        ILuaCallable callable = property.getHandler();
        boolean ignoreCancelled = property.isIgnoreCancelled();
        EventPriority priority = property.getPriority() == null ? null : EventPriority.valueOf((String)property.getPriority());
        return this.doSubscribe(eventClass, callable, priority, ignoreCancelled);
    }

    @Override
    public ILuaEventListenerBuilder subscribes(LuaTable ... tables) throws Exception {
        for (LuaTable t : tables) {
            this.subscribe(t);
        }
        return this;
    }

    private ILuaEventListenerBuilder doSubscribe(Class<?> eventClass, ILuaCallable closure, EventPriority eventPriority, Boolean ignoreCancelled) {
        this.eventConfigs.add(new EventConfig(eventClass, closure, eventPriority, ignoreCancelled));
        return this;
    }

    /*
     * Exception decompiling
     */
    @Override
    public LuaUnregisteredListener build() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private static Class<?> findEventClass(String eventClassName) throws ClassNotFoundException {
        Class<?> eventClass;
        block5: {
            eventClass = null;
            try {
                eventClass = Class.forName(eventClassName);
            }
            catch (ClassNotFoundException e) {
                for (String prefix : EVENT_CLASS_PREFIX) {
                    try {
                        eventClass = Class.forName(prefix + eventClassName);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
                if (eventClass != null) break block5;
                throw e;
            }
        }
        return eventClass;
    }

    public static class EventConfig {
        private final Class<?> eventClass;
        private final ILuaCallable closure;
        private final EventPriority eventPriority;
        private final Boolean ignoreCancelled;

        public EventConfig(Class<?> eventClass, ILuaCallable closure, EventPriority eventPriority, Boolean ignoreCancelled) {
            this.eventClass = eventClass;
            this.closure = closure;
            this.eventPriority = eventPriority;
            this.ignoreCancelled = ignoreCancelled;
        }

        public Class<?> getEventClass() {
            return this.eventClass;
        }

        public ILuaCallable getClosure() {
            return this.closure;
        }

        public EventPriority getEventPriority() {
            return this.eventPriority;
        }

        public Boolean getIgnoreCancelled() {
            return this.ignoreCancelled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventConfig)) {
                return false;
            }
            EventConfig other = (EventConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$ignoreCancelled = this.getIgnoreCancelled();
            Boolean other$ignoreCancelled = other.getIgnoreCancelled();
            if (this$ignoreCancelled == null ? other$ignoreCancelled != null : !((Object)this$ignoreCancelled).equals(other$ignoreCancelled)) {
                return false;
            }
            Class<?> this$eventClass = this.getEventClass();
            Class<?> other$eventClass = other.getEventClass();
            if (this$eventClass == null ? other$eventClass != null : !this$eventClass.equals(other$eventClass)) {
                return false;
            }
            ILuaCallable this$closure = this.getClosure();
            ILuaCallable other$closure = other.getClosure();
            if (this$closure == null ? other$closure != null : !this$closure.equals(other$closure)) {
                return false;
            }
            EventPriority this$eventPriority = this.getEventPriority();
            EventPriority other$eventPriority = other.getEventPriority();
            return !(this$eventPriority == null ? other$eventPriority != null : !this$eventPriority.equals(other$eventPriority));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EventConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $ignoreCancelled = this.getIgnoreCancelled();
            result = result * 59 + ($ignoreCancelled == null ? 43 : ((Object)$ignoreCancelled).hashCode());
            Class<?> $eventClass = this.getEventClass();
            result = result * 59 + ($eventClass == null ? 43 : $eventClass.hashCode());
            ILuaCallable $closure = this.getClosure();
            result = result * 59 + ($closure == null ? 43 : $closure.hashCode());
            EventPriority $eventPriority = this.getEventPriority();
            result = result * 59 + ($eventPriority == null ? 43 : $eventPriority.hashCode());
            return result;
        }

        public String toString() {
            return "LuaEventListenerBuilder.EventConfig(eventClass=" + this.getEventClass() + ", closure=" + this.getClosure() + ", eventPriority=" + this.getEventPriority() + ", ignoreCancelled=" + this.getIgnoreCancelled() + ")";
        }

        static /* synthetic */ EventPriority access$000(EventConfig x0) {
            return x0.eventPriority;
        }

        static /* synthetic */ Boolean access$100(EventConfig x0) {
            return x0.ignoreCancelled;
        }

        static /* synthetic */ Class access$200(EventConfig x0) {
            return x0.eventClass;
        }

        static /* synthetic */ ILuaCallable access$300(EventConfig x0) {
            return x0.closure;
        }
    }
}

