/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.ILuacageRepository;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.luacage.LuacageJsonMeta;
import org.jetbrains.annotations.NotNull;

public class LuacageRepository
implements ILuacageRepository {
    private final List<LuacageJsonMeta> list;

    public LuacageRepository(File file) throws FileNotFoundException {
        List list = (List)new Gson().fromJson((Reader)new FileReader(file), new TypeToken<List<LuacageJsonMeta>>(){}.getType());
        if (list == null) {
            list = Collections.emptyList();
        }
        this.list = list;
    }

    public LuacageRepository(String repoName, File file) throws FileNotFoundException {
        this(Objects.requireNonNull(file));
        this.list.parallelStream().forEach(l -> l.setSource(repoName));
    }

    @Override
    public List<LuacageJsonMeta> getPackages() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    @NotNull
    public List<LuacageJsonMeta> findPackages(String packageName, String desc, short searchType) {
        return this.list.parallelStream().filter(it -> {
            if (searchType == 3 && Objects.equals(packageName, it.getName())) {
                return true;
            }
            if (searchType == 0 && this.hasString(packageName) && it.getName().toLowerCase(Locale.ENGLISH).contains(packageName.toLowerCase(Locale.ENGLISH))) {
                return true;
            }
            if (searchType == 1 && this.hasString(desc) && it.getDescription().toLowerCase(Locale.ENGLISH).contains(desc.toLowerCase(Locale.ENGLISH))) {
                return true;
            }
            if (searchType == 2) {
                if (this.hasString(packageName) && it.getName().toLowerCase(Locale.ENGLISH).contains(packageName.toLowerCase(Locale.ENGLISH))) {
                    return true;
                }
                return this.hasString(desc) && it.getDescription().toLowerCase(Locale.ENGLISH).contains(desc.toLowerCase(Locale.ENGLISH));
            }
            return false;
        }).collect(Collectors.toList());
    }

    private boolean hasString(String text) {
        return text != null && !text.isEmpty();
    }
}

