/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.luaState.pool.simplePool;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eu.smileyik.luaInMinecraftBukkitII.LuaInMinecraftBukkit;
import org.eu.smileyik.luaInMinecraftBukkitII.config.LuaPoolConfig;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.ILuaStateEnvInner;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.pool.LuaPool;
import org.eu.smileyik.luaInMinecraftBukkitII.luaState.pool.simplePool.LuaPoolEntity;
import org.eu.smileyik.luaInMinecraftBukkitII.simpledebug.DebugLogger;
import org.eu.smileyik.luajava.LuaException;
import org.eu.smileyik.luajava.LuaObject;
import org.eu.smileyik.luajava.LuaState;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.exception.Result;
import org.eu.smileyik.luajava.type.ILuaCallable;
import org.eu.smileyik.luajava.type.ILuaObject;

public class SimpleLuaPool
implements LuaPool,
AutoCloseable {
    private final ScheduledExecutorService scheduled = Executors.newSingleThreadScheduledExecutor();
    private final ILuaStateEnvInner env;
    private final LuaPoolConfig config;
    private int currentPoolSize = 0;
    private final PriorityQueue<LuaPoolEntity> queue;
    private final Set<LuaPoolEntity> running;
    private final Lock poolLock = new ReentrantLock();
    private final Condition freeCondition = this.poolLock.newCondition();
    private volatile boolean closed = false;

    public SimpleLuaPool(ILuaStateEnvInner env, LuaPoolConfig config) {
        this.env = env;
        this.config = config;
        this.queue = new PriorityQueue<LuaPoolEntity>(this.config.getMaxSize(), Comparator.comparingLong(LuaPoolEntity::getLatestRun));
        this.running = new HashSet<LuaPoolEntity>(this.config.getMaxSize());
        this.scheduled.scheduleAtFixedRate(() -> {
            long time = System.currentTimeMillis();
            this.poolLock.lock();
            try {
                LuaPoolEntity peek;
                while (!this.queue.isEmpty() && time - (peek = this.queue.peek()).getLatestRun() >= config.getIdleTimeout()) {
                    this.queue.poll();
                    --this.currentPoolSize;
                    DebugLogger.debug("Removing idle lua state, this lua state be called %d times, latest run at %d", peek.getRunCount(), peek.getLatestRun());
                    peek.getLuaStateFacade().close();
                }
            }
            finally {
                this.poolLock.unlock();
            }
        }, config.getIdleTimeout(), config.getIdleTimeout() >> 1, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transferClosure(LuaStateFacade srcF, LuaStateFacade destF, ILuaCallable callable, Object ... params) {
        LuaState srcL = srcF.getLuaState();
        LuaState destL = destF.getLuaState();
        srcF.lock();
        try {
            callable.push();
            try {
                if (srcL.copyValue(-1, destL)) {
                    String firstUpValue = srcL.getUpValue(-1, 1);
                    if (Objects.equals("_ENV", firstUpValue)) {
                        destL.getUpValue(-1, 1);
                        srcL.copyTableIfNotExists(-1, destL);
                        srcL.pop(1);
                        destL.pop(1);
                    } else {
                        if (firstUpValue != null) {
                            srcL.pop(1);
                        }
                        srcL.getGlobal("_G");
                        destL.getGlobal("_G");
                        srcL.copyTableIfNotExists(-1, destL);
                        srcL.pushString("_LUAJAVA_G_REF");
                        srcL.getTable(-2);
                        destL.pushString("_LUAJAVA_G_REF");
                        destL.getTable(-2);
                        if (!srcL.isNil(-1) && !destL.isNil(-1)) {
                            int srcRef = srcL.toInteger(-1);
                            int destRef = destL.toInteger(-1);
                            srcL.rawGetI(LuaState.LUA_REGISTRYINDEX, srcRef);
                            destL.rawGetI(LuaState.LUA_REGISTRYINDEX, destRef);
                            srcL.copyTableIfNotExists(-1, destL);
                            srcL.pop(1);
                            destL.pop(1);
                        }
                        srcL.pop(2);
                        destL.pop(2);
                    }
                    for (Object param : params) {
                        if (param instanceof LuaObject) {
                            ((LuaObject)param).rawPush();
                            if (srcL.copyValue(-1, destL)) continue;
                            destL.pushNil();
                            continue;
                        }
                        destF.rawPushObjectValue(param).ifFailureThen(e -> destL.pushNil());
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                srcL.pop(1);
            }
        }
        finally {
            srcF.unlock();
        }
        return false;
    }

    @Override
    public Result<Object[], LuaException> submit(ILuaCallable luaCallable, int _nres, Object ... params) {
        return this.doSubmit(luaCallable, _nres, params);
    }

    @Override
    public void execute(ILuaCallable luaCallable, Object ... params) {
        this.doSubmit(luaCallable, 0, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result<Object[], LuaException> doSubmit(ILuaCallable luaCallable, int _nres, Object ... params) {
        if (this.closed) {
            return Result.failure(new LuaException("Pool is closed"));
        }
        if (params == null) {
            params = new Object[]{};
        }
        LuaPoolEntity poolEntity = this.getLuaState();
        LuaStateFacade srcF = luaCallable.getLuaState();
        LuaStateFacade destF = poolEntity.getLuaStateFacade();
        LuaState srcL = srcF.getLuaState();
        LuaState destL = destF.getLuaState();
        destF.lock();
        try {
            int top = destL.getTop();
            if (this.transferClosure(srcF, destF, luaCallable, params)) {
                Result<Object[], LuaException> result = destF.doPcall(params.length, _nres, 0).mapResultValue(v -> {
                    if (_nres == 0) {
                        return Result.success();
                    }
                    int nres = _nres;
                    int currentTop = destL.getTop();
                    if (nres == -1) {
                        nres = currentTop - top;
                    }
                    if (currentTop - top < nres) {
                        return Result.failure(new LuaException("Invalid Number of Results .")).justCast();
                    }
                    Object[] res = new Object[nres];
                    srcF.lock();
                    try {
                        for (int i = nres - 1; i >= 0; --i) {
                            Result<Object, ? extends LuaException> ret = destF.rawToJavaObject(-1);
                            if (ret.isError()) {
                                Result result = ret.justCast();
                                return result;
                            }
                            res[i] = ret.getValue();
                            if (res[i] instanceof ILuaObject) {
                                try (LuaObject obj = (LuaObject)res[i];){
                                    if (destL.copyValue(-1, srcL)) {
                                        res[i] = srcF.rawToJavaObject(-1).getOrSneakyThrow();
                                        srcL.pop(1);
                                    } else {
                                        res[i] = null;
                                    }
                                }
                            }
                            destL.pop(1);
                        }
                    }
                    finally {
                        srcF.unlock();
                    }
                    return Result.success(res);
                });
                return result;
            }
        }
        finally {
            destL.setTop(0);
            destF.unlock();
            this.returnLuaState(poolEntity);
        }
        return Result.success();
    }

    protected LuaStateFacade newLuaState() {
        return this.env.createLuaState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LuaPoolEntity getLuaState() {
        this.poolLock.lock();
        try {
            LuaPoolEntity poolEntity = null;
            while (this.queue.isEmpty()) {
                if (this.currentPoolSize < this.config.getMaxSize()) {
                    ++this.currentPoolSize;
                    LuaStateFacade facade = this.newLuaState();
                    poolEntity = new LuaPoolEntity(facade);
                    break;
                }
                try {
                    this.freeCondition.await();
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    LuaPoolEntity luaPoolEntity = null;
                    this.poolLock.unlock();
                    return luaPoolEntity;
                }
            }
            if (poolEntity == null) {
                poolEntity = this.queue.poll();
            }
            this.running.add(poolEntity);
            LuaPoolEntity luaPoolEntity = poolEntity;
            return luaPoolEntity;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    protected void returnLuaState(LuaPoolEntity poolEntity) {
        this.poolLock.lock();
        try {
            if (this.running.remove(poolEntity) && this.queue.add(poolEntity)) {
                this.freeCondition.signal();
            }
        }
        finally {
            poolEntity.returned();
            this.poolLock.unlock();
        }
    }

    @Override
    public void close() {
        this.scheduled.shutdown();
        this.poolLock.lock();
        this.closed = true;
        try {
            this.running.forEach(it -> {
                try {
                    new Thread(() -> {
                        LuaInMinecraftBukkit.instance().getLogger().warning("Waiting for LuaPool state to close: " + it.getStateId());
                        LuaInMinecraftBukkit.instance().getLogger().warning("This process will running on another thread until LuaPool state closed! Please make sure your task is not infinity task!");
                        it.close();
                        DebugLogger.debug("Closed lua state %d, this lua state be called %d times, %d milliseconds, latest run at %d", it.getStateId(), it.getRunCount(), it.getTotalMilliseconds(), it.getLatestRun());
                    }).start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            this.running.clear();
            while (!this.queue.isEmpty()) {
                LuaPoolEntity poll = this.queue.poll();
                try {
                    poll.getLuaStateFacade().close();
                    DebugLogger.debug("Closed lua state %d, this lua state be called %d times, %d milliseconds, latest run at %d", poll.getStateId(), poll.getRunCount(), poll.getTotalMilliseconds(), poll.getLatestRun());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }
}

