/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.reflect;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eu.smileyik.luaInMinecraftBukkitII.reflect.AbstractFastReflection;
import org.eu.smileyik.luaInMinecraftBukkitII.reflect.fastReflection.ConstructorGenerator;
import org.eu.smileyik.luaInMinecraftBukkitII.reflect.fastReflection.ExecutorAccessor;
import org.eu.smileyik.luaInMinecraftBukkitII.reflect.fastReflection.FieldAccessor;
import org.eu.smileyik.luaInMinecraftBukkitII.reflect.fastReflection.FieldGenerator;
import org.eu.smileyik.luaInMinecraftBukkitII.reflect.fastReflection.MethodGenerator;
import org.eu.smileyik.luaInMinecraftBukkitII.simpledebug.DebugLogger;
import org.eu.smileyik.luajava.reflect.IExecutable;
import org.eu.smileyik.luajava.reflect.IFieldAccessor;

public class MixedFastReflection
extends AbstractFastReflection {
    public MixedFastReflection(int cacheCapacity) {
        super(cacheCapacity);
    }

    @Override
    protected <T extends Executable> IExecutable<T> newExecutableAccessorWrapper(IExecutable<T> executable) throws IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return new FastExecutorAccessor<T>(executable);
    }

    @Override
    protected IFieldAccessor newFieldAccessorWrapper(IFieldAccessor field) throws IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return new FastFieldAccessor(field);
    }

    private static class FastExecutorAccessor<T extends Executable>
    implements IExecutable<T> {
        private final IExecutable<T> fallback;
        private final ExecutorAccessor accessor;

        public FastExecutorAccessor(IExecutable<T> executable) throws IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
            this.fallback = executable;
            T t = executable.getExecutable();
            this.accessor = t instanceof Method ? MethodGenerator.INSTANCE.generate((Method)t) : ConstructorGenerator.INSTANCE.generate((Constructor)t);
        }

        @Override
        public Object invoke(Object instance, Object[] params) {
            try {
                return this.accessor.invoke(instance, params);
            }
            catch (Exception e) {
                DebugLogger.debug("Failed to invoke method %s", ((Executable)this.fallback.getExecutable()).getName());
                DebugLogger.debug(e);
                try {
                    return this.fallback.invoke(instance, params);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        @Override
        public T getExecutable() {
            return this.fallback.getExecutable();
        }
    }

    private static class FastFieldAccessor
    implements IFieldAccessor {
        private final IFieldAccessor fallback;
        private final FieldAccessor accessor;

        public FastFieldAccessor(IFieldAccessor fallback) throws IOException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
            this.fallback = fallback;
            this.accessor = FieldGenerator.INSTANCE.generate(fallback.getField());
        }

        @Override
        public Object get(Object instance) {
            try {
                return this.accessor.get(instance);
            }
            catch (Exception e) {
                DebugLogger.debug(e);
                try {
                    return this.fallback.get(instance);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        @Override
        public void set(Object instance, Object value) {
            try {
                this.accessor.set(instance, value);
            }
            catch (Exception e) {
                DebugLogger.debug(e);
                try {
                    this.fallback.set(instance, value);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        @Override
        public Field getField() {
            return this.fallback.getField();
        }
    }
}

