/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.simplecommand;

import java.io.InvalidClassException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.CommandMessageFormat;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.CommandMethod;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.CommandService;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.CommandTranslator;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.DefaultTabSuggest;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.Result;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.TabSuggest;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.annotation.Command;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.annotation.CommandI18N;
import org.eu.smileyik.luaInMinecraftBukkitII.simplecommand.exception.NoRootCommandException;

public class CommandServiceImpl
implements CommandService,
CommandExecutor,
TabExecutor {
    private final Map<String, CommandMethod> commandMethodMap = new HashMap<String, CommandMethod>();
    private final Map<String, TabSuggest> tabSuggestMap = new HashMap<String, TabSuggest>();
    private final List<DefaultTabSuggest> defaultTabSuggests = new LinkedList<DefaultTabSuggest>();
    private final CommandTranslator translator;
    private final CommandMessageFormat format;

    public CommandServiceImpl(CommandTranslator translator, CommandMessageFormat format, Class<?> ... classes) throws InvalidClassException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        this.translator = translator;
        this.format = format;
        this.registerCommands(classes);
    }

    @Override
    public void registerToBukkit(Plugin plugin) {
        this.commandMethodMap.forEach((s, commandMethod) -> {
            plugin.getServer().getPluginCommand(commandMethod.getCommand()).setExecutor((CommandExecutor)this);
            plugin.getServer().getPluginCommand(commandMethod.getCommand()).setTabCompleter((TabCompleter)this);
        });
    }

    @Override
    public void registerTabSuggest(TabSuggest tabSuggest) {
        if (tabSuggest instanceof DefaultTabSuggest) {
            this.defaultTabSuggests.add((DefaultTabSuggest)tabSuggest);
            return;
        }
        this.tabSuggestMap.put(tabSuggest.getKeyword().toLowerCase(), tabSuggest);
    }

    @Override
    public void shutdown() {
        for (CommandMethod value : this.commandMethodMap.values()) {
            value.clear();
        }
        this.tabSuggestMap.clear();
        this.commandMethodMap.clear();
        this.defaultTabSuggests.clear();
    }

    private void registerCommands(Class<?> ... classes) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException, InvalidClassException {
        HashMap<String, CommandMethod> map = new HashMap<String, CommandMethod>();
        ArrayList<String> rootCommands = new ArrayList<String>();
        for (Class<?> clazz : classes) {
            Method[] declaredMethods;
            boolean root;
            Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            boolean bl = root = !clazz.isAnnotationPresent(Command.class);
            if (root) {
                Method[] declaredMethods2;
                for (Method method : declaredMethods2 = clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(Command.class)) continue;
                    Command sub = method.getAnnotation(Command.class);
                    CommandI18N subCommandI18N = null;
                    if (method.isAnnotationPresent(CommandI18N.class)) {
                        subCommandI18N = method.getAnnotation(CommandI18N.class);
                    }
                    CommandMethod commandMethod = new CommandMethod(sub, subCommandI18N, instance, method);
                    map.put(sub.value(), commandMethod);
                    rootCommands.add(sub.value());
                }
                continue;
            }
            Command command = clazz.getAnnotation(Command.class);
            CommandI18N commandI18N = null;
            if (clazz.isAnnotationPresent(CommandI18N.class)) {
                commandI18N = clazz.getAnnotation(CommandI18N.class);
            }
            CommandMethod commandMethod = new CommandMethod(command, commandI18N, instance, null);
            map.put(command.value(), commandMethod);
            if (command.parentCommand().isEmpty()) {
                rootCommands.add(command.value());
            }
            for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Command.class)) continue;
                Command sub = method.getAnnotation(Command.class);
                CommandI18N subCommandI18N = null;
                if (method.isAnnotationPresent(CommandI18N.class)) {
                    subCommandI18N = method.getAnnotation(CommandI18N.class);
                }
                commandMethod.addChild(new CommandMethod(sub, subCommandI18N, instance, method));
            }
        }
        if (rootCommands.isEmpty()) {
            throw new NoRootCommandException();
        }
        map.forEach((key, cmd) -> {
            if (cmd.hasParentCommand()) {
                CommandMethod commandMethod = (CommandMethod)map.get(cmd.getParentCommand());
                if (commandMethod == null) {
                    throw new RuntimeException(key + " need parent command: " + cmd.getParentCommand());
                }
                commandMethod.addChild((CommandMethod)cmd);
            }
        });
        for (String root : rootCommands) {
            CommandMethod cmd2 = (CommandMethod)map.get(root);
            this.commandMethodMap.put(root.toLowerCase(), cmd2);
            cmd2.spawnHelp(this.translator);
            for (String alias : cmd2.getAliases()) {
                this.commandMethodMap.put(alias.toLowerCase(), cmd2);
            }
        }
        map.clear();
    }

    public void execute(CommandSender sender, String label, String[] args) {
        try {
            Result result = this.doExecute(sender, label, args);
            switch (result.getResult()) {
                case Succeed: {
                    break;
                }
                case NotFound: {
                    if (result.getSuggestion() == null) {
                        sender.sendMessage(this.format.notFound());
                        break;
                    }
                    StringBuilder sb = new StringBuilder();
                    for (CommandMethod suggestion = result.getSuggestion(); suggestion != null; suggestion = suggestion.getNext()) {
                        sb.append('\n').append(suggestion.getHelp(sender, label));
                    }
                    sender.sendMessage(this.format.notFound(sb.substring(1)));
                    break;
                }
                case CommandError: {
                    if (result.getSuggestion() == null) {
                        sender.sendMessage(this.format.commandError());
                        break;
                    }
                    StringBuilder sb = new StringBuilder();
                    for (CommandMethod suggestion = result.getSuggestion(); suggestion != null; suggestion = suggestion.getNext()) {
                        sb.append('\n').append(suggestion.getHelp(sender, label));
                    }
                    sender.sendMessage(this.format.commandError(sb.substring(1)));
                    break;
                }
                case NotPlayer: {
                    sender.sendMessage(this.format.notPlayer());
                    break;
                }
                case NoPermission: {
                    sender.sendMessage(this.format.notPermission());
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            sender.sendMessage(this.format.commandError());
            e.printStackTrace();
        }
    }

    private Result doExecute(CommandSender sender, String label, String[] args) throws InvocationTargetException, IllegalAccessException {
        CommandMethod commandMethod = this.commandMethodMap.get(label.toLowerCase());
        if (commandMethod != null) {
            if (!commandMethod.hasPermission(sender)) {
                return Result.RESULT_NO_PERMISSION;
            }
            if (args.length == 0 && !commandMethod.canExecute()) {
                return this.doExecute(sender, label, new String[]{"help"});
            }
            return commandMethod.execute(sender, label, args, 0);
        }
        return Result.RESULT_NOT_FIND;
    }

    public boolean onCommand(CommandSender commandSender, org.bukkit.command.Command command, String s, String[] strings) {
        this.execute(commandSender, s, strings);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, org.bukkit.command.Command command, String s, String[] strings) {
        if (!this.commandMethodMap.containsKey(s)) {
            return Collections.emptyList();
        }
        CommandMethod commandMethod = this.commandMethodMap.get(s);
        if (!commandMethod.hasPermission(sender)) {
            return Collections.emptyList();
        }
        return commandMethod.getTabSuggest(this.defaultTabSuggests, this.tabSuggestMap, sender, strings, 0, 0);
    }
}

