/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.simpledebug;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import org.eu.smileyik.luaInMinecraftBukkitII.simpledebug.Object2String;

public class DebugLogger
implements Closeable {
    public static final List<String> SIMPLE_TYPES = Arrays.asList("INFO", "WARN", "ERROR");
    public static final int INFO = 0;
    public static final int WARN = 1;
    public static final int ERROR = 2;
    private static DebugLogger instance;
    private final Logger logger;
    private final BufferedWriter logWriter;
    private final int mask;
    private final List<String> typeNames;
    private final int typeNameSize;

    private DebugLogger(Logger logger, File debugFile, int mask, List<String> typeNames) throws IOException {
        this.logger = logger;
        this.logWriter = debugFile == null ? null : new BufferedWriter(new FileWriter(debugFile));
        this.mask = mask;
        this.typeNames = typeNames;
        this.typeNameSize = typeNames == null ? 0 : typeNames.size();
    }

    public static synchronized void init(Logger logger, File debugFile, int mask) throws IOException, IllegalStateException {
        if (instance != null) {
            throw new IllegalStateException("DebugLogger has already been initialized");
        }
        instance = new DebugLogger(logger, debugFile, mask, null);
    }

    public static synchronized void init(Logger logger, File debugFile, int mask, List<String> typeNames) throws IOException, IllegalStateException {
        if (instance == null) {
            instance = new DebugLogger(logger, debugFile, mask, typeNames);
        }
    }

    public static synchronized void init(Logger logger, File debugFile) throws IOException, IllegalStateException {
        DebugLogger.init(logger, debugFile, -1);
    }

    private static String getTime() {
        Calendar instance = Calendar.getInstance();
        instance.setTime(new Date());
        return String.format("[%04d-%02d-%02d %02d:%02d:%02d] ", instance.get(1), instance.get(2) + 1, instance.get(5), instance.get(11), instance.get(12), instance.get(13));
    }

    private static boolean debuggable(int type) {
        return instance != null && (1 << type & DebugLogger.instance.mask) != 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String throwableToString(Throwable throwable) {
        try (StringWriter stringWriter = new StringWriter();){
            throwable.printStackTrace(new PrintWriter(stringWriter));
            stringWriter.flush();
            String string = stringWriter.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void debug(int type, Throwable obj) {
        if (!DebugLogger.debuggable(type)) {
            return;
        }
        DebugLogger.debug(type, Thread.currentThread().getStackTrace()[2], "%s", DebugLogger.throwableToString(obj));
    }

    public static void debug(Throwable obj) {
        if (instance == null) {
            return;
        }
        DebugLogger.debug(Thread.currentThread().getStackTrace()[2], "%s", DebugLogger.throwableToString(obj));
    }

    public static void debug(int type, Object obj) {
        if (!DebugLogger.debuggable(type)) {
            return;
        }
        DebugLogger.debug(type, Thread.currentThread().getStackTrace()[2], "%s", Objects.toString(obj));
    }

    public static void debug(Object obj) {
        if (instance == null) {
            return;
        }
        DebugLogger.debug(Thread.currentThread().getStackTrace()[2], "%s", Objects.toString(obj));
    }

    public static void debugObject(int type, Object obj) {
        if (!DebugLogger.debuggable(type)) {
            return;
        }
        DebugLogger.debugObject(type, Thread.currentThread().getStackTrace()[2], "%s", obj, 0);
    }

    public static void debugObject(int type, String format, Object obj) {
        if (!DebugLogger.debuggable(type)) {
            return;
        }
        DebugLogger.debugObject(type, Thread.currentThread().getStackTrace()[2], format, obj, 0);
    }

    public static void debugObject(int type, String format, Object obj, int maxDeep) {
        if (!DebugLogger.debuggable(type)) {
            return;
        }
        DebugLogger.debugObject(type, Thread.currentThread().getStackTrace()[2], format, obj, maxDeep);
    }

    public static void debugObjectDeep(int type, String format, Object obj) {
        if (!DebugLogger.debuggable(type)) {
            return;
        }
        DebugLogger.debugObject(type, Thread.currentThread().getStackTrace()[2], format, obj, Integer.MAX_VALUE);
    }

    public static void debugObject(int type, StackTraceElement element, String format, Object obj, int maxDeep) {
        if (DebugLogger.debuggable(type)) {
            String str = Object2String.toString(obj, maxDeep);
            DebugLogger.debug(type, element, format, str);
        }
    }

    public static void debugObject(Object obj) {
        if (instance == null) {
            return;
        }
        DebugLogger.debugObject(Thread.currentThread().getStackTrace()[2], "%s", obj, 0);
    }

    public static void debugObject(String format, Object obj) {
        if (instance == null) {
            return;
        }
        DebugLogger.debugObject(Thread.currentThread().getStackTrace()[2], format, obj, 0);
    }

    public static void debugObject(String format, Object obj, int maxDeep) {
        if (instance == null) {
            return;
        }
        DebugLogger.debugObject(Thread.currentThread().getStackTrace()[2], format, obj, maxDeep);
    }

    public static void debugObjectDeep(String format, Object obj) {
        if (instance == null) {
            return;
        }
        DebugLogger.debugObject(Thread.currentThread().getStackTrace()[2], format, obj, Integer.MAX_VALUE);
    }

    public static void debugObject(StackTraceElement element, String format, Object obj, int maxDeep) {
        if (instance == null) {
            return;
        }
        String str = Object2String.toString(obj, maxDeep);
        DebugLogger.debug(element, format, str);
    }

    public static void debug(int type, String message, Object ... args) {
        if (!DebugLogger.debuggable(type)) {
            return;
        }
        DebugLogger.debug(type, Thread.currentThread().getStackTrace()[2], message, args);
    }

    public static void debug(String message, Object ... args) {
        if (instance == null) {
            return;
        }
        DebugLogger.debug(Thread.currentThread().getStackTrace()[2], message, args);
    }

    public static void debug(int type, StackTraceElement element, String message, Object ... args) {
        if (!DebugLogger.debuggable(type)) {
            return;
        }
        if (DebugLogger.debuggable(type)) {
            String name = DebugLogger.instance.typeNameSize > type + 1 ? DebugLogger.instance.typeNames.get(type) : String.valueOf(type);
            DebugLogger.debug(String.format("[%s] ", name), element, message, args);
        }
    }

    public static void debug(StackTraceElement element, String message, Object ... args) {
        DebugLogger.debug("", element, message, args);
    }

    public static synchronized void debug(String prefix, StackTraceElement element, String message, Object ... args) {
        if (instance == null) {
            return;
        }
        try {
            String format = String.format(message, args);
            String method = String.format("[%s#%s:%d] ", element.getClassName(), element.getMethodName(), element.getLineNumber());
            if (DebugLogger.instance.logWriter != null) {
                DebugLogger.instance.logWriter.write(DebugLogger.getTime());
                DebugLogger.instance.logWriter.write(prefix);
                DebugLogger.instance.logWriter.write(method);
                DebugLogger.instance.logWriter.write(format);
                DebugLogger.instance.logWriter.newLine();
                DebugLogger.instance.logWriter.flush();
            }
            DebugLogger.instance.logger.info(prefix + method + format);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void debug(int type, Consumer<StackTraceElement> consumer) {
        if (!DebugLogger.debuggable(type)) {
            return;
        }
        consumer.accept(Thread.currentThread().getStackTrace()[2]);
    }

    public static void debug(Consumer<StackTraceElement> consumer) {
        if (instance != null) {
            consumer.accept(Thread.currentThread().getStackTrace()[2]);
        }
    }

    public static void debugNanoTime(int type, Consumer<Void> consumer) {
        if (DebugLogger.debuggable(type)) {
            DebugLogger.debugNanoTime(Thread.currentThread().getStackTrace()[2], consumer);
        } else {
            consumer.accept(null);
        }
    }

    public static <T> T debugNanoTime(int type, Function<StackTraceElement, T> function) {
        return DebugLogger.debuggable(type) ? DebugLogger.debugNanoTime(Thread.currentThread().getStackTrace()[2], function) : function.apply(null);
    }

    public static void debugNanoTime(Consumer<Void> consumer) {
        if (instance != null) {
            DebugLogger.debugNanoTime(Thread.currentThread().getStackTrace()[2], consumer);
        } else {
            consumer.accept(null);
        }
    }

    public static <T> T debugNanoTime(Function<StackTraceElement, T> function) {
        return instance != null ? DebugLogger.debugNanoTime(Thread.currentThread().getStackTrace()[2], function) : function.apply(null);
    }

    private static void debugNanoTime(StackTraceElement element, Consumer<Void> consumer) {
        long nanos = System.nanoTime();
        consumer.accept(null);
        nanos = System.nanoTime() - nanos;
        DebugLogger.debug(element, "run this function spends %dns (%fms)", nanos, (double)nanos / 1000000.0);
    }

    public static <T> T debugNanoTime(StackTraceElement element, Function<StackTraceElement, T> function) {
        long nanos = System.nanoTime();
        T apply = function.apply(element);
        nanos = System.nanoTime() - nanos;
        DebugLogger.debug(element, "run this function spends %dns (%fms)", nanos, (double)nanos / 1000000.0);
        return apply;
    }

    public static void debugTime(int type, Consumer<Void> consumer) {
        if (DebugLogger.debuggable(type)) {
            DebugLogger.debugTime(Thread.currentThread().getStackTrace()[2], consumer);
        } else {
            consumer.accept(null);
        }
    }

    public static <T> T debugTime(int type, Function<StackTraceElement, T> function) {
        return DebugLogger.debuggable(type) ? DebugLogger.debugTime(Thread.currentThread().getStackTrace()[2], function) : function.apply(null);
    }

    public static void debugTime(Consumer<Void> consumer) {
        if (instance == null) {
            consumer.accept(null);
            return;
        }
        DebugLogger.debugTime(Thread.currentThread().getStackTrace()[2], consumer);
    }

    public static <T> T debugTime(Function<StackTraceElement, T> function) {
        return instance != null ? DebugLogger.debugTime(Thread.currentThread().getStackTrace()[2], function) : function.apply(null);
    }

    private static void debugTime(StackTraceElement element, Consumer<Void> consumer) {
        long time = System.currentTimeMillis();
        consumer.accept(null);
        time = System.currentTimeMillis() - time;
        DebugLogger.debug(element, "run this function spends %dms", time);
    }

    public static <T> T debugTime(StackTraceElement element, Function<StackTraceElement, T> function) {
        long time = System.currentTimeMillis();
        T apply = function.apply(element);
        time = System.currentTimeMillis() - time;
        DebugLogger.debug(element, "run this function spends %dms", time);
        return apply;
    }

    public static StackTraceElement getStackTraceElement(int deep) {
        return Thread.currentThread().getStackTrace()[deep];
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.logWriter != null) {
            this.logWriter.flush();
            this.logWriter.close();
        }
    }

    public static synchronized void closeLogger() throws IOException {
        if (instance == null) {
            return;
        }
        instance.close();
        instance = null;
    }
}

