/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luaInMinecraftBukkitII.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.eu.smileyik.luaInMinecraftBukkitII.simpledebug.DebugLogger;

public class ResourcesExtractor {
    public static void extractResources(String resourceName, File targetDir) {
        Class<ResourcesExtractor> clazz = ResourcesExtractor.class;
        try (InputStream listIs = clazz.getResourceAsStream("/resources/" + resourceName + ".list");){
            if (listIs == null) {
                return;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(listIs));){
                reader.lines().forEach(fileName -> {
                    File file = new File(targetDir, (String)fileName);
                    if (file.exists()) {
                        return;
                    }
                    File parentFile = file.getParentFile();
                    if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
                        return;
                    }
                    try (InputStream is = clazz.getResourceAsStream("/resources/" + resourceName + "/" + fileName);
                         BufferedInputStream in = new BufferedInputStream(Objects.requireNonNull(is));
                         BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = in.read(buffer)) != -1) {
                            out.write(buffer, 0, len);
                        }
                        out.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            DebugLogger.debug(2, "Failed to extract resources '%s' to '%s'", resourceName, targetDir);
            DebugLogger.debug(e);
        }
    }
}

