/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eu.smileyik.luajava.LuaStateFacade;

public interface ILuaReadWriteEntity {
    public int bufferSize();

    public void setDataPtr(long var1);

    public long getDataPtr();

    public void luaWrite(LuaStateFacade var1, ByteBuffer var2) throws IOException;

    public int luaRead(LuaStateFacade var1, ByteBuffer var2) throws IOException;

    public static final class SimpleRead
    implements ILuaReadWriteEntity,
    Closeable {
        private final InputStream in;
        private final int bufferSize;
        private long dataPtr = 0L;

        public SimpleRead(InputStream in, int bufferSize) {
            this.in = in;
            this.bufferSize = bufferSize;
        }

        @Override
        public int bufferSize() {
            return this.bufferSize;
        }

        @Override
        public void setDataPtr(long dataPtr) {
            this.dataPtr = dataPtr;
        }

        @Override
        public long getDataPtr() {
            return this.dataPtr;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public void luaWrite(LuaStateFacade facade, ByteBuffer in) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int luaRead(LuaStateFacade facade, ByteBuffer out) throws IOException {
            int capacity = out.capacity();
            byte[] bytes = new byte[capacity];
            int len = this.in.read(bytes);
            out.put(bytes);
            return len;
        }
    }

    public static final class SimpleWrite
    implements ILuaReadWriteEntity,
    Closeable {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();

        @Override
        public int bufferSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDataPtr(long ptr) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getDataPtr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void luaWrite(LuaStateFacade facade, ByteBuffer in) throws IOException {
            int capacity = in.capacity();
            byte[] data = new byte[capacity];
            in.get(data);
            this.out.write(data, 0, capacity);
            this.out.flush();
        }

        @Override
        public int luaRead(LuaStateFacade facade, ByteBuffer out) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        public OutputStream getOutputStream() {
            return this.out;
        }
    }
}

