/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.eu.smileyik.luajava.LuaException;
import org.eu.smileyik.luajava.LuaObject;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.type.ILuaCallable;
import org.eu.smileyik.luajava.type.ILuaFieldGettable;
import org.eu.smileyik.luajava.util.BoxedTypeHelper;

public class LuaInvocationHandler
implements InvocationHandler {
    private final LuaObject obj;

    public LuaInvocationHandler(LuaObject obj) {
        this.obj = obj;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws LuaException {
        LuaStateFacade facade = this.obj.getLuaState();
        return facade.lockThrow(l -> {
            String methodName = method.getName();
            LuaObject func = ((ILuaFieldGettable)((Object)this.obj)).getField(methodName).getOrThrow(LuaException.class);
            if (func == null || func.isNil()) {
                return null;
            }
            if (!func.isCallable()) {
                throw new LuaException("Method " + methodName + " is not a callable");
            }
            Class<?> retType = method.getReturnType();
            Object ret = null;
            if (retType.equals(Void.class) || retType.equals(Void.TYPE)) {
                facade.doPcall((ILuaCallable)((Object)func), args, 0).justThrow(LuaException.class);
            } else {
                ret = facade.doPcall((ILuaCallable)((Object)func), args, 1).mapValue(it -> {
                    Object o = it[0];
                    if (o instanceof Double) {
                        return BoxedTypeHelper.covertNumberTo((Double)o, retType);
                    }
                    return o;
                }).getOrThrow(LuaException.class);
            }
            return ret;
        }).getOrThrow(LuaException.class);
    }
}

