/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.eu.smileyik.luajava.ILuaReadWriteEntity;
import org.eu.smileyik.luajava.LuaException;
import org.eu.smileyik.luajava.LuaObject;
import org.eu.smileyik.luajava.LuaState;
import org.eu.smileyik.luajava.LuaStateFacade;
import org.eu.smileyik.luajava.LuaStateFactory;
import org.eu.smileyik.luajava.debug.LuaDebug;
import org.eu.smileyik.luajava.exception.Result;
import org.eu.smileyik.luajava.reflect.ConvertablePriority;
import org.eu.smileyik.luajava.reflect.IExecutable;
import org.eu.smileyik.luajava.reflect.IFieldAccessor;
import org.eu.smileyik.luajava.reflect.LuaInvokedMethod;
import org.eu.smileyik.luajava.reflect.ReflectUtil;
import org.eu.smileyik.luajava.reflect.SimpleReflectUtil;
import org.eu.smileyik.luajava.util.ArrayIterator;
import org.eu.smileyik.luajava.util.BoxedTypeHelper;
import org.eu.smileyik.luajava.util.IndexableIterator;
import org.eu.smileyik.luajava.util.IteratorWrapper;
import org.eu.smileyik.luajava.util.ParamRef;

public final class LuaJavaAPI {
    private static ReflectUtil reflectUtil = new SimpleReflectUtil(1024);
    private static final String METATABLE_KEY_ITERATOR = "__JavaIterator";
    private static final String FORCE_ACCESS_METHOD_PREFIX = "_m_";

    private LuaJavaAPI() {
    }

    public static void setReflectUtil(ReflectUtil reflectUtil) {
        if (reflectUtil == null) {
            return;
        }
        LuaJavaAPI.reflectUtil = reflectUtil;
    }

    public static ReflectUtil getReflectUtil() {
        return reflectUtil;
    }

    public static int objectIter(int luaState) throws LuaException {
        LuaStateFacade facade = LuaStateFactory.getExistingState(luaState);
        LuaState l = facade.getLuaState();
        if (!l.getMetaTable(1) || !l.isTable(-1)) {
            throw new LuaException("This object has no meta table");
        }
        l.pushString(METATABLE_KEY_ITERATOR);
        l.rawGet(-2);
        IndexableIterator iterator = null;
        if (l.isObject(-1)) {
            iterator = (IndexableIterator)facade.rawToJavaObject(-1).getOrThrow(LuaException.class);
        } else {
            Object obj = facade.rawToJavaObject(1).getOrThrow(LuaException.class);
            if (obj instanceof Iterable) {
                iterator = new IteratorWrapper(((Iterable)obj).iterator());
            } else if (obj.getClass().isArray()) {
                iterator = new ArrayIterator(obj);
            } else {
                throw new LuaException("Cannot use pairs to " + obj.getClass());
            }
            l.getMetaTable(1);
            l.pushString(METATABLE_KEY_ITERATOR);
            facade.rawPushObjectValue(iterator).getOrThrow(LuaException.class);
            l.rawSet(-3);
        }
        l.pop(1);
        if (iterator.hasNext()) {
            Object next = iterator.next();
            l.pushInteger(iterator.getIndex());
            facade.rawPushObjectValue(next).getOrThrow(LuaException.class);
            return 2;
        }
        l.getMetaTable(1);
        l.pushString(METATABLE_KEY_ITERATOR);
        l.pushNil();
        l.rawSet(-3);
        l.pop(1);
        return 0;
    }

    public static int objectConcat(int luaState) throws LuaException {
        LuaStateFacade facade = LuaStateFactory.getExistingState(luaState);
        Object a = facade.rawToJavaObject(1).getOrThrow(LuaException.class);
        Object b = facade.rawToJavaObject(2).getOrThrow(LuaException.class);
        String ret = null;
        if (a instanceof String) {
            ret = a + BoxedTypeHelper.toString(b);
        } else if (b instanceof String) {
            ret = BoxedTypeHelper.toString(a) + b;
        } else {
            throw new LuaException("In the concat operation, at least one string type is required. left: " + a + ", right: " + b);
        }
        facade.rawPushObjectValue(ret).justThrow(LuaException.class);
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int objectIndex(int luaState, Object obj, String methodName, boolean classIndex) throws Exception {
        Class clazz;
        if (methodName != null && methodName.startsWith(FORCE_ACCESS_METHOD_PREFIX) && (methodName = methodName.substring(FORCE_ACCESS_METHOD_PREFIX.length())).isEmpty()) {
            return 0;
        }
        if (classIndex) {
            if (!(obj instanceof Class)) throw new LuaException("Object is not a class: " + obj);
            clazz = (Class)obj;
        } else {
            clazz = obj.getClass();
        }
        LuaStateFacade luaStateFacade = LuaStateFactory.getExistingState(luaState);
        LuaState L = luaStateFacade.getLuaState();
        int top = L.getTop();
        Object[] objs = new Object[top - 1];
        IExecutable<Method> methodWrapper = LuaJavaAPI.findMethod(luaStateFacade, clazz, methodName, objs, top);
        if (methodWrapper == null) {
            throw new LuaException(String.format("Invalid method call. No such method named '%s' in class %s", methodName, clazz.getName()));
        }
        Method method = methodWrapper.getExecutable();
        Object ret = methodWrapper.invoke(Modifier.isStatic(method.getModifiers()) ? null : obj, objs);
        if (ret == null) {
            return 0;
        }
        luaStateFacade.rawPushObjectValue(ret).justThrow(LuaException.class);
        return 1;
    }

    public static int arrayIndex(int luaState, Object obj, int index) throws LuaException {
        LuaStateFacade luaStateFacade = LuaStateFactory.getExistingState(luaState);
        if (!obj.getClass().isArray()) {
            throw new LuaException("Object indexed is not an array.");
        }
        if (Array.getLength(obj) < index) {
            throw new LuaException("Index out of bounds.");
        }
        luaStateFacade.rawPushObjectValue(Array.get(obj, index - 1)).justThrow(LuaException.class);
        return 1;
    }

    public static int classIndex(int luaState, Class<?> clazz, String searchName) throws LuaException {
        int res = LuaJavaAPI.checkField(luaState, clazz, searchName);
        if (res != 0) {
            return 1;
        }
        if (LuaJavaAPI.checkClassMethod(luaState, clazz, searchName)) {
            return 2;
        }
        return 0;
    }

    public static int objectNewIndex(int luaState, Object obj, String fieldName) throws LuaException {
        LuaStateFacade luaStateFacade;
        Class<?> targetClass = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        IFieldAccessor fieldAccessor = reflectUtil.findFieldByName(targetClass, fieldName, false, false, false, (luaStateFacade = LuaStateFactory.getExistingState(luaState)).isIgnoreNotPublic());
        if (fieldAccessor == null) {
            throw new LuaException(String.format("Error accessing field '%s' in class %s", fieldName, targetClass.getName()));
        }
        Class<?> type = fieldAccessor.getField().getType();
        Result<Object, Object> setObjRet = LuaJavaAPI.compareTypes(luaStateFacade, luaStateFacade.getLuaState(), type, 3);
        if (setObjRet.isError()) {
            throw new LuaException("Invalid type.");
        }
        try {
            fieldAccessor.set(obj, setObjRet.getValue());
        }
        catch (IllegalAccessException e) {
            throw new LuaException("Field not accessible.", e);
        }
        return 0;
    }

    public static int arrayNewIndex(int luaState, Object obj, int index) throws LuaException {
        LuaState l;
        if (!obj.getClass().isArray()) {
            throw new LuaException("Object indexed is not an array.");
        }
        if (Array.getLength(obj) < index) {
            throw new LuaException("Index out of bounds.");
        }
        Class<?> type = obj.getClass().getComponentType();
        LuaStateFacade luaStateFacade = LuaStateFactory.getExistingState(luaState);
        Result<Object, Object> result = LuaJavaAPI.compareTypes(luaStateFacade, l = luaStateFacade.getLuaState(), type, 3);
        if (result.isError()) {
            throw new LuaException("Invalid type.");
        }
        Object setObj = result.getValue();
        Array.set(obj, index - 1, setObj);
        return 0;
    }

    public static int javaNewInstance(int luaState, String className) throws Exception {
        return LuaJavaAPI.javaNew(luaState, Class.forName(className));
    }

    public static int javaNew(int luaState, Class<?> clazz) throws LuaException {
        LuaStateFacade luaStateFacade = LuaStateFactory.getExistingState(luaState);
        Object ret = LuaJavaAPI.getObjInstance(luaStateFacade, luaStateFacade.getLuaState(), clazz);
        luaStateFacade.rawPushObjectValue(ret);
        return 1;
    }

    public static int javaLoadLib(int luaState, String className, String methodName) throws Exception {
        Class<?> clazz = Class.forName(className);
        LuaStateFacade luaStateFacade = LuaStateFactory.getExistingState(luaState);
        try {
            Method mt = clazz.getMethod(methodName, LuaState.class);
            Object obj = mt.invoke(null, luaStateFacade.getLuaState());
            if (obj instanceof Integer) {
                return (Integer)obj;
            }
            return 0;
        }
        catch (Exception e) {
            throw new LuaException("Error on calling method. Library could not be loaded. " + e.getMessage());
        }
    }

    public static int checkField(int luaState, Object obj, String fieldName) throws LuaException {
        LuaStateFacade luaStateFacade;
        boolean isStatic;
        if (obj == null) {
            return 0;
        }
        if (fieldName == null || fieldName.startsWith(FORCE_ACCESS_METHOD_PREFIX)) {
            return 0;
        }
        Class<?> targetClass = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        IFieldAccessor fieldAccessor = reflectUtil.findFieldByName(targetClass, fieldName, false, false, isStatic = targetClass == obj, (luaStateFacade = LuaStateFactory.getExistingState(luaState)).isIgnoreNotPublic());
        if (fieldAccessor == null) {
            return 0;
        }
        try {
            Object ret = fieldAccessor.get(obj);
            luaStateFacade.rawPushObjectValue(ret).justThrow(LuaException.class);
            return 1;
        }
        catch (IllegalAccessException illegalAccessException) {
            return 0;
        }
    }

    public static boolean checkMethod(int luaState, Object obj, String methodName) {
        if (obj == null) {
            return false;
        }
        if (methodName != null && methodName.startsWith(FORCE_ACCESS_METHOD_PREFIX) && (methodName = methodName.substring(FORCE_ACCESS_METHOD_PREFIX.length())).isEmpty()) {
            return false;
        }
        Class<?> clazz = obj.getClass();
        LuaStateFacade luaStateFacade = LuaStateFactory.getExistingState(luaState);
        return reflectUtil.existsMethodByName(clazz, methodName, luaStateFacade.isIgnoreNotPublic(), false, false);
    }

    private static boolean checkClassMethod(int luaState, Object obj, String methodName) {
        if (obj == null) {
            return false;
        }
        Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        LuaStateFacade luaStateFacade = LuaStateFactory.getExistingState(luaState);
        return reflectUtil.existsMethodByName(clazz, methodName, luaStateFacade.isIgnoreNotPublic(), false, true);
    }

    public static int createProxyObject(int luaState, String implem) throws LuaException {
        LuaStateFacade luaStateFacade = LuaStateFactory.getExistingState(luaState);
        LuaState L = luaStateFacade.getLuaState();
        if (!L.isTable(2)) {
            throw new LuaException("Parameter is not a table. Can't create proxy.");
        }
        luaStateFacade.getLuaObject(2).thenMap(it -> it.createProxy(implem)).ifSuccessThen(L::pushJavaObject).justThrow(LuaException.class);
        return 1;
    }

    private static Result<Object, Object> compareTypes(LuaStateFacade luaStateFacade, LuaState L, Class<?> parameter, int idx) throws LuaException {
        ParamRef<Object> paramRef = ParamRef.wrapper();
        Object luaObj = luaStateFacade.rawToJavaObject(idx).getOrThrow(LuaException.class);
        byte ret = ConvertablePriority.isConvertableType(Integer.MAX_VALUE, luaObj, parameter, paramRef);
        if (ret == -1) {
            return Result.failure("");
        }
        if (paramRef.isEmpty()) {
            return Result.success(luaObj);
        }
        return Result.success(paramRef.getParam());
    }

    private static Object[] getLuaParams(LuaStateFacade luaStateFacade, int paramsCount) throws LuaException {
        Object[] objs = new Object[paramsCount];
        for (int i = 0; i < paramsCount; ++i) {
            objs[i] = luaStateFacade.rawToJavaObject(i + 2).getOrThrow(LuaException.class);
        }
        return objs;
    }

    private static Object getObjInstance(LuaStateFacade luaStateFacade, LuaState L, Class<?> clazz) throws LuaException {
        Object ret;
        int top = L.getTop();
        int paramsCount = top - 1;
        Object[] objs = LuaJavaAPI.getLuaParams(luaStateFacade, paramsCount);
        LuaInvokedMethod<IExecutable<Constructor<?>>> result = reflectUtil.findConstructorByParams(clazz, objs, luaStateFacade.isIgnoreNotPublic(), false, false);
        if (result == null) {
            throw new LuaException("Couldn't instantiate java Object");
        }
        result.getOverwriteParams().forEach((idx, obj) -> {
            Object old = objs[idx];
            try {
                objs[idx.intValue()] = obj;
            }
            finally {
                LuaJavaAPI.closeParamsObject(old);
            }
        });
        try {
            ret = result.getExecutable().invoke(null, objs);
        }
        catch (Exception e) {
            throw new LuaException(e);
        }
        return ret;
    }

    private static IExecutable<Method> findMethod(LuaStateFacade luaStateFacade, Class<?> clazz, String methodName, Object[] retObjs, int top) throws LuaException {
        int paramsCount = top - 1;
        Object[] objs = LuaJavaAPI.getLuaParams(luaStateFacade, paramsCount);
        LinkedList<LuaInvokedMethod<IExecutable<Method>>> list = reflectUtil.findMethodByParams(clazz, methodName, objs, luaStateFacade.isJustUseFirstMethod(), luaStateFacade.isIgnoreNotPublic(), false, false);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new LuaException("Found multi result for method " + methodName + " in class " + clazz);
        }
        LuaInvokedMethod<IExecutable<Method>> invokedMethod = list.getFirst();
        invokedMethod.getOverwriteParams().forEach((idx, obj) -> {
            Object old = objs[idx];
            try {
                objs[idx.intValue()] = obj;
            }
            finally {
                LuaJavaAPI.closeParamsObject(old);
            }
        });
        System.arraycopy(objs, 0, retObjs, 0, objs.length);
        return invokedMethod.getExecutable();
    }

    private static void closeParamsObject(Object obj) {
        if (obj instanceof LuaObject) {
            ((LuaObject)obj).close();
        }
    }

    private static void closeParamsObject(Object[] objs) {
        for (Object obj : objs) {
            LuaJavaAPI.closeParamsObject(obj);
        }
    }

    public static void debugLuaHook(int luaState, LuaDebug luaDebug) {
        LuaStateFacade luaStateFacade = LuaStateFactory.getExistingState(luaState);
        luaStateFacade.debugHook(luaDebug);
    }

    public static LuaDebug newLuaDebug(long ptr, ByteBuffer buffer, String name, String nameWhat, String what, String source) {
        return LuaDebug.newInstance(ptr, buffer, name, nameWhat, what, source);
    }

    public static void luaWrite(int luaState, ByteBuffer in, ILuaReadWriteEntity entity) throws IOException {
        LuaStateFacade luaStateFacade = LuaStateFactory.getExistingState(luaState);
        entity.luaWrite(luaStateFacade, in);
    }

    public static int luaRead(int luaState, ByteBuffer out, ILuaReadWriteEntity entity) throws IOException {
        LuaStateFacade luaStateFacade = LuaStateFactory.getExistingState(luaState);
        return entity.luaRead(luaStateFacade, out);
    }

    public static Throwable throwsByC(int luaState, Throwable throwable) {
        try {
            LuaStateFacade luaStateFacade = LuaStateFactory.getExistingState(luaState);
            Throwable newOne = luaStateFacade.throwsByC(throwable);
            return newOne == null ? throwable : newOne;
        }
        catch (Throwable e) {
            try {
                e.printStackTrace(System.err);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return throwable;
        }
    }
}

