/*
 * Decompiled with CFR 0.152.
 */
package org.eu.smileyik.luajava;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eu.smileyik.luajava.CPtr;
import org.eu.smileyik.luajava.ILuaReadWriteEntity;
import org.eu.smileyik.luajava.JavaFunction;
import org.eu.smileyik.luajava.LuaException;
import org.eu.smileyik.luajava.debug.LuaDebug;

public class LuaState {
    public static final int LONG_SIZE = LuaState._longSize();
    public static final String LUA_VERSION = LuaState._luaVersion();
    public static final int LUA_GLOBALSINDEX = LuaState._luaGlobalsIndex();
    public static final int LUA_REGISTRYINDEX = LuaState._luaRegistryIndex();
    public static final int LUA_TNONE = -1;
    public static final int LUA_TNIL = 0;
    public static final int LUA_TBOOLEAN = 1;
    public static final int LUA_TLIGHTUSERDATA = 2;
    public static final int LUA_TNUMBER = 3;
    public static final int LUA_TSTRING = 4;
    public static final int LUA_TTABLE = 5;
    public static final int LUA_TFUNCTION = 6;
    public static final int LUA_TUSERDATA = 7;
    public static final int LUA_TTHREAD = 8;
    public static final int LUA_MULTRET = -1;
    public static final int LUA_YIELD = 1;
    public static final int LUA_OK = 0;
    public static final int LUA_ERRRUN = 2;
    public static final int LUA_ERRSYNTAX = 3;
    public static final int LUA_ERRMEM = 4;
    public static final int LUA_ERRERR = 5;
    public static final int LUA_GCSTOP = 0;
    public static final int LUA_GCRESTART = 1;
    public static final int LUA_GCCOLLECT = 2;
    public static final int LUA_GCCOUNT = 3;
    public static final int LUA_GCCOUNTB = 4;
    public static final int LUA_GCSTEP = 5;
    public static final int LUA_GCSETPAUSE = 6;
    public static final int LUA_GCSETSTEPMUL = 7;
    public static final int LUA_HOOKCALL = 0;
    public static final int LUA_HOOKRET = 1;
    public static final int LUA_HOOKLINE = 2;
    public static final int LUA_HOOKCOUNT = 3;
    public static final int LUA_HOOKTAILCALL = 4;
    public static final int LUA_MASKCALL = 1;
    public static final int LUA_MASKRET = 2;
    public static final int LUA_MASKLINE = 4;
    public static final int LUA_MASKCOUNT = 8;
    public static final int LUA_OPADD;
    public static final int LUA_OPSUB;
    public static final int LUA_OPMUL;
    public static final int LUA_OPDIV;
    public static final int LUA_OPMOD;
    public static final int LUA_OPPOW;
    public static final int LUA_OPUNM;
    public static final int LUA_OPIDI;
    public static final int LUA_OPBAN;
    public static final int LUA_OPBOR;
    public static final int LUA_OPBXO;
    public static final int LUA_OPSHL;
    public static final int LUA_OPSHR;
    public static final int LUA_OPBNO;
    public static final int LUA_OPEQ = 0;
    public static final int LUA_OPLT = 1;
    public static final int LUA_OPLE = 2;
    private CPtr luaState;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    protected LuaState(int stateId) {
        this.luaState = this._open();
        this.luajava_open(this.luaState, stateId);
    }

    protected LuaState(CPtr luaState, int stateId) {
        this.luaState = luaState;
        this.luajava_open(luaState, stateId);
    }

    private static native int _LdoFile(CPtr var0, String var1);

    protected void clearRef() {
        if (!this.isClosed() && this.closed.compareAndSet(false, true)) {
            this._close(this.luaState);
            this.luaState = null;
        }
    }

    public boolean isClosed() {
        return this.luaState == null || this.luaState.getPeer() == 0L || this.closed.get();
    }

    public long getCPtrPeer() {
        return this.luaState != null ? this.luaState.getPeer() : 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LuaState luaState1 = (LuaState)object;
        return Objects.equals(this.luaState, luaState1.luaState);
    }

    public int hashCode() {
        return Objects.hashCode(this.luaState);
    }

    private static native String _luaVersion();

    private static native int _luaRegistryIndex();

    private static native int _luaGlobalsIndex();

    private static native int _longSize();

    private native CPtr _open();

    private native void _close(CPtr var1);

    private native CPtr _newthread(CPtr var1);

    private native int _getTop(CPtr var1);

    private native void _setTop(CPtr var1, int var2);

    private native void _pushValue(CPtr var1, int var2);

    private native void _remove(CPtr var1, int var2);

    private native void _insert(CPtr var1, int var2);

    private native void _replace(CPtr var1, int var2);

    private native int _checkStack(CPtr var1, int var2);

    private native void _xmove(CPtr var1, CPtr var2, int var3);

    private native int _isNumber(CPtr var1, int var2);

    private native int _isString(CPtr var1, int var2);

    private native int _isCFunction(CPtr var1, int var2);

    private native int _isUserdata(CPtr var1, int var2);

    private native int _type(CPtr var1, int var2);

    private native String _typeName(CPtr var1, int var2);

    private native int _equal(CPtr var1, int var2, int var3);

    private native int _rawequal(CPtr var1, int var2, int var3);

    private native int _lessthan(CPtr var1, int var2, int var3);

    private native double _toNumber(CPtr var1, int var2);

    private native int _toInteger(CPtr var1, int var2);

    private native int _toBoolean(CPtr var1, int var2);

    private native String _toString(CPtr var1, int var2);

    private native long _toPointer(CPtr var1, int var2);

    private native int _objlen(CPtr var1, int var2);

    private native CPtr _toThread(CPtr var1, int var2);

    private native void _pushNil(CPtr var1);

    private native void _pushNumber(CPtr var1, double var2);

    private native void _pushInteger(CPtr var1, int var2);

    private native void _pushString(CPtr var1, String var2);

    private native void _pushString(CPtr var1, byte[] var2, int var3);

    private native void _pushBoolean(CPtr var1, int var2);

    private native void _getTable(CPtr var1, int var2);

    private native void _getField(CPtr var1, int var2, String var3);

    private native void _rawGet(CPtr var1, int var2);

    private native void _rawGetI(CPtr var1, int var2, int var3);

    private native void _createTable(CPtr var1, int var2, int var3);

    private native int _getMetaTable(CPtr var1, int var2);

    private native void _getFEnv(CPtr var1, int var2);

    private native void _setTable(CPtr var1, int var2);

    private native void _setField(CPtr var1, int var2, String var3);

    private native void _rawSet(CPtr var1, int var2);

    private native void _rawSetI(CPtr var1, int var2, int var3);

    private native int _setMetaTable(CPtr var1, int var2);

    private native int _setFEnv(CPtr var1, int var2);

    private native void _call(CPtr var1, int var2, int var3);

    private native int _pcall(CPtr var1, int var2, int var3, int var4);

    private native int _yield(CPtr var1, int var2);

    private native int _resume(CPtr var1, int var2);

    private native int _status(CPtr var1);

    private native int _gc(CPtr var1, int var2, int var3);

    private native int _error(CPtr var1);

    private native int _next(CPtr var1, int var2);

    private native void _concat(CPtr var1, int var2);

    private native void _pop(CPtr var1, int var2);

    private native void _newTable(CPtr var1);

    private native int _strlen(CPtr var1, int var2);

    private native int _isFunction(CPtr var1, int var2);

    private native int _isTable(CPtr var1, int var2);

    private native int _isNil(CPtr var1, int var2);

    private native int _isBoolean(CPtr var1, int var2);

    private native int _isThread(CPtr var1, int var2);

    private native int _isNone(CPtr var1, int var2);

    private native int _isNoneOrNil(CPtr var1, int var2);

    private native void _setGlobal(CPtr var1, String var2);

    private native void _getGlobal(CPtr var1, String var2);

    private native int _getGcCount(CPtr var1);

    private native int _LdoString(CPtr var1, String var2);

    private native int _LgetMetaField(CPtr var1, int var2, String var3);

    private native int _LcallMeta(CPtr var1, int var2, String var3);

    private native int _Ltyperror(CPtr var1, int var2, String var3);

    private native int _LargError(CPtr var1, int var2, String var3);

    private native String _LcheckString(CPtr var1, int var2);

    private native String _LoptString(CPtr var1, int var2, String var3);

    private native double _LcheckNumber(CPtr var1, int var2);

    private native double _LoptNumber(CPtr var1, int var2, double var3);

    private native int _LcheckInteger(CPtr var1, int var2);

    private native int _LoptInteger(CPtr var1, int var2, int var3);

    private native void _LcheckStack(CPtr var1, int var2, String var3);

    private native void _LcheckType(CPtr var1, int var2, int var3);

    private native void _LcheckAny(CPtr var1, int var2);

    private native int _LnewMetatable(CPtr var1, String var2);

    private native void _LgetMetatable(CPtr var1, String var2);

    private native void _Lwhere(CPtr var1, int var2);

    private native int _Lref(CPtr var1, int var2);

    private native void _LunRef(CPtr var1, int var2, int var3);

    private native int _LloadFile(CPtr var1, String var2);

    private native int _LloadBuffer(CPtr var1, byte[] var2, long var3, String var5);

    private native int _LloadString(CPtr var1, String var2);

    private native String _Lgsub(CPtr var1, String var2, String var3, String var4);

    private native String _LfindTable(CPtr var1, int var2, String var3, int var4);

    private native void _openBase(CPtr var1);

    private native void _openTable(CPtr var1);

    private native void _openIo(CPtr var1);

    private native void _openOs(CPtr var1);

    private native void _openString(CPtr var1);

    private native void _openMath(CPtr var1);

    private native void _openDebug(CPtr var1);

    private native void _openPackage(CPtr var1);

    private native int _luaDump(CPtr var1, ILuaReadWriteEntity var2, int var3);

    private native int _luaLoad(CPtr var1, ILuaReadWriteEntity var2, String var3, String var4);

    private native int _copyValue(CPtr var1, int var2, CPtr var3);

    private native int _copyTableIfNotExists(CPtr var1, int var2, CPtr var3);

    private native int _newGlobalEnv(CPtr var1);

    private native void _setHook(CPtr var1, int var2, int var3);

    private native int _getHookMask(CPtr var1);

    private native int _getHookCount(CPtr var1);

    private native LuaDebug _getStack(CPtr var1, int var2);

    private native LuaDebug _getInfo(CPtr var1, long var2, String var4);

    private native String _getLocal(CPtr var1, long var2, int var4);

    private native String _setLocal(CPtr var1, long var2, int var4);

    private native String _getUpValue(CPtr var1, int var2, int var3);

    private native String _setUpValue(CPtr var1, int var2, int var3);

    private native void _freeLuaDebug(long var1);

    private native void _getGlobalTable(CPtr var1);

    private native int _rawlen(CPtr var1, int var2);

    private native int _compare(CPtr var1, int var2, int var3, int var4);

    private native void _arith(CPtr var1, int var2);

    private native void _len(CPtr var1, int var2);

    private native int _resume(CPtr var1, CPtr var2, int var3);

    private native int _pushthread(CPtr var1, CPtr var2);

    private native void _setuservalue(CPtr var1, int var2);

    private native void _getuservalue(CPtr var1, int var2);

    private native int _absindex(CPtr var1, int var2);

    private native void _openCoroutine(CPtr var1);

    private native void _rotate(CPtr var1, int var2, int var3);

    private native void _openUtf8(CPtr var1);

    public int getIUserValue(int idx, int n) {
        return this._getiuservalue(this.luaState, idx, n);
    }

    public int setIUserValue(int idx, int n) {
        return this._setiuservalue(this.luaState, idx, n);
    }

    public void warning(String msg, int tocont) {
        this._warning(this.luaState, msg, tocont);
    }

    public int resume(LuaState threadL, int nargs, int nrets) {
        return this._resume(this.luaState, threadL.luaState, nargs, nrets);
    }

    private native void _openLibs(CPtr var1);

    public CPtr newThread() {
        return this._newthread(this.luaState);
    }

    public int getTop() {
        return this._getTop(this.luaState);
    }

    public void setTop(int idx) {
        this._setTop(this.luaState, idx);
    }

    public void pushValue(int idx) {
        this._pushValue(this.luaState, idx);
    }

    public void remove(int idx) {
        this._remove(this.luaState, idx);
    }

    public void insert(int idx) {
        this._insert(this.luaState, idx);
    }

    public void replace(int idx) {
        this._replace(this.luaState, idx);
    }

    public int checkStack(int sz) {
        return this._checkStack(this.luaState, sz);
    }

    protected void xmove(LuaState to, int n) {
        this._xmove(this.luaState, to.luaState, n);
    }

    public boolean isNumber(int idx) {
        return this._isNumber(this.luaState, idx) != 0;
    }

    public boolean isString(int idx) {
        return this._isString(this.luaState, idx) != 0;
    }

    public boolean isFunction(int idx) {
        return this._isFunction(this.luaState, idx) != 0;
    }

    public boolean isCFunction(int idx) {
        return this._isCFunction(this.luaState, idx) != 0;
    }

    public boolean isUserdata(int idx) {
        return this._isUserdata(this.luaState, idx) != 0;
    }

    public boolean isTable(int idx) {
        return this._isTable(this.luaState, idx) != 0;
    }

    public boolean isBoolean(int idx) {
        return this._isBoolean(this.luaState, idx) != 0;
    }

    public boolean isNil(int idx) {
        return this._isNil(this.luaState, idx) != 0;
    }

    public boolean isThread(int idx) {
        return this._isThread(this.luaState, idx) != 0;
    }

    public boolean isNone(int idx) {
        return this._isNone(this.luaState, idx) != 0;
    }

    public boolean isNoneOrNil(int idx) {
        return this._isNoneOrNil(this.luaState, idx) != 0;
    }

    public int type(int idx) {
        return this._type(this.luaState, idx);
    }

    public String typeName(int tp) {
        return this._typeName(this.luaState, tp);
    }

    public int equal(int idx1, int idx2) {
        return this._equal(this.luaState, idx1, idx2);
    }

    public boolean rawequal(int idx1, int idx2) {
        return this._rawequal(this.luaState, idx1, idx2) == 1;
    }

    public int lessthan(int idx1, int idx2) {
        return this._lessthan(this.luaState, idx1, idx2);
    }

    public double toNumber(int idx) {
        return this._toNumber(this.luaState, idx);
    }

    public int toInteger(int idx) {
        return this._toInteger(this.luaState, idx);
    }

    public boolean toBoolean(int idx) {
        return this._toBoolean(this.luaState, idx) != 0;
    }

    public String toString(int idx) {
        return this._toString(this.luaState, idx);
    }

    public long toPointer(int idx) {
        return this._toPointer(this.luaState, idx);
    }

    public int strLen(int idx) {
        return this._strlen(this.luaState, idx);
    }

    public int objLen(int idx) {
        return this._objlen(this.luaState, idx);
    }

    public CPtr toThread(int idx) {
        return this._toThread(this.luaState, idx);
    }

    public void pushNil() {
        this._pushNil(this.luaState);
    }

    public void pushNumber(double db) {
        this._pushNumber(this.luaState, db);
    }

    public void pushInteger(int integer) {
        this._pushInteger(this.luaState, integer);
    }

    public void pushString(String str) {
        if (str == null) {
            this._pushNil(this.luaState);
        } else {
            this._pushString(this.luaState, str);
        }
    }

    public void pushString(byte[] bytes) {
        if (bytes == null) {
            this._pushNil(this.luaState);
        } else {
            this._pushString(this.luaState, bytes, bytes.length);
        }
    }

    public void pushBoolean(boolean bool) {
        this._pushBoolean(this.luaState, bool ? 1 : 0);
    }

    public void getTable(int idx) {
        this._getTable(this.luaState, idx);
    }

    public void getField(int idx, String k) {
        this._getField(this.luaState, idx, k);
    }

    public void rawGet(int idx) {
        this._rawGet(this.luaState, idx);
    }

    public void rawGetI(int idx, int n) {
        this._rawGetI(this.luaState, idx, n);
    }

    public void createTable(int narr, int nrec) {
        this._createTable(this.luaState, narr, nrec);
    }

    public void newTable() {
        this._newTable(this.luaState);
    }

    public boolean getMetaTable(int idx) {
        return this._getMetaTable(this.luaState, idx) != 0;
    }

    public void getFEnv(int idx) {
        this._getFEnv(this.luaState, idx);
    }

    public void setTable(int idx) {
        this._setTable(this.luaState, idx);
    }

    public void setField(int idx, String k) {
        this._setField(this.luaState, idx, k);
    }

    public void rawSet(int idx) {
        this._rawSet(this.luaState, idx);
    }

    public void rawSetI(int idx, int n) {
        this._rawSetI(this.luaState, idx, n);
    }

    public int setMetaTable(int idx) {
        return this._setMetaTable(this.luaState, idx);
    }

    public int setFEnv(int idx) {
        return this._setFEnv(this.luaState, idx);
    }

    public void call(int nArgs, int nResults) {
        this._call(this.luaState, nArgs, nResults);
    }

    public int pcall(int nArgs, int nResults, int errFunc) {
        return this._pcall(this.luaState, nArgs, nResults, errFunc);
    }

    public int yield(int nResults) {
        return this._yield(this.luaState, nResults);
    }

    public int resume(int nArgs) {
        return this._resume(this.luaState, nArgs);
    }

    public int status() {
        return this._status(this.luaState);
    }

    public int gc(int what, int data) {
        return this._gc(this.luaState, what, data);
    }

    public int getGcCount() {
        return this._getGcCount(this.luaState);
    }

    public int next(int idx) {
        return this._next(this.luaState, idx);
    }

    public int error() {
        return this._error(this.luaState);
    }

    public void concat(int n) {
        this._concat(this.luaState, n);
    }

    public int LdoFile(String fileName) {
        return LuaState._LdoFile(this.luaState, fileName);
    }

    public int LdoString(String str) {
        return this._LdoString(this.luaState, str);
    }

    public int LgetMetaField(int obj, String e) {
        return this._LgetMetaField(this.luaState, obj, e);
    }

    public int LcallMeta(int obj, String e) {
        return this._LcallMeta(this.luaState, obj, e);
    }

    public int Ltyperror(int nArg, String tName) {
        return this._Ltyperror(this.luaState, nArg, tName);
    }

    public int LargError(int numArg, String extraMsg) {
        return this._LargError(this.luaState, numArg, extraMsg);
    }

    public String LcheckString(int numArg) {
        return this._LcheckString(this.luaState, numArg);
    }

    public String LoptString(int numArg, String def) {
        return this._LoptString(this.luaState, numArg, def);
    }

    public double LcheckNumber(int numArg) {
        return this._LcheckNumber(this.luaState, numArg);
    }

    public double LoptNumber(int numArg, double def) {
        return this._LoptNumber(this.luaState, numArg, def);
    }

    public int LcheckInteger(int numArg) {
        return this._LcheckInteger(this.luaState, numArg);
    }

    public int LoptInteger(int numArg, int def) {
        return this._LoptInteger(this.luaState, numArg, def);
    }

    public void LcheckStack(int sz, String msg) {
        this._LcheckStack(this.luaState, sz, msg);
    }

    public void LcheckType(int nArg, int t) {
        this._LcheckType(this.luaState, nArg, t);
    }

    public void LcheckAny(int nArg) {
        this._LcheckAny(this.luaState, nArg);
    }

    public int LnewMetatable(String tName) {
        return this._LnewMetatable(this.luaState, tName);
    }

    public void LgetMetatable(String tName) {
        this._LgetMetatable(this.luaState, tName);
    }

    public void Lwhere(int lvl) {
        this._Lwhere(this.luaState, lvl);
    }

    public int Lref(int t) {
        return this._Lref(this.luaState, t);
    }

    public void LunRef(int t, int ref) {
        this._LunRef(this.luaState, t, ref);
    }

    public int LloadFile(String fileName) {
        return this._LloadFile(this.luaState, fileName);
    }

    public int LloadString(String s) {
        return this._LloadString(this.luaState, s);
    }

    public int LloadBuffer(byte[] buff, String name) {
        return this._LloadBuffer(this.luaState, buff, buff.length, name);
    }

    public String Lgsub(String s, String p, String r) {
        return this._Lgsub(this.luaState, s, p, r);
    }

    public String LfindTable(int idx, String fname, int szhint) {
        return this._LfindTable(this.luaState, idx, fname, szhint);
    }

    public void pop(int n) {
        this._pop(this.luaState, n);
    }

    public void getGlobal(String global) {
        this._getGlobal(this.luaState, global);
    }

    public void setGlobal(String name) {
        this._setGlobal(this.luaState, name);
    }

    public void openBase() {
        this._openBase(this.luaState);
    }

    public void openTable() {
        this._openTable(this.luaState);
    }

    public void openIo() {
        this._openIo(this.luaState);
    }

    public void openOs() {
        this._openOs(this.luaState);
    }

    public void openString() {
        this._openString(this.luaState);
    }

    public void openMath() {
        this._openMath(this.luaState);
    }

    public void openDebug() {
        this._openDebug(this.luaState);
    }

    public void openPackage() {
        this._openPackage(this.luaState);
    }

    public int dump(ILuaReadWriteEntity userdata, boolean strip) {
        return this._luaDump(this.luaState, userdata, strip ? 1 : 0);
    }

    public int load(ILuaReadWriteEntity userdata, String chunkName, String mode) {
        return this._luaLoad(this.luaState, userdata, chunkName, mode);
    }

    public boolean copyValue(int idx, LuaState dest) {
        return this._copyValue(this.luaState, idx, dest.luaState) == 1;
    }

    public boolean copyTableIfNotExists(int idx, LuaState dest) {
        return this._copyTableIfNotExists(this.luaState, idx, dest.luaState) == 1;
    }

    public boolean newGlobalTable() {
        return this._newGlobalEnv(this.luaState) == 1;
    }

    public void setHook(int mask, int count) {
        this._setHook(this.luaState, mask, count);
    }

    public int getHookMask() {
        return this._getHookMask(this.luaState);
    }

    public int getHookCount() {
        return this._getHookCount(this.luaState);
    }

    public LuaDebug getStack(int level) {
        return this._getStack(this.luaState, level);
    }

    public LuaDebug getInfo(LuaDebug ar, String what) {
        return this._getInfo(this.luaState, ar.getPtr(), what);
    }

    public String getLocal(LuaDebug ar, int n) {
        return this._getLocal(this.luaState, ar.getPtr(), n);
    }

    public String setLocal(LuaDebug ar, int n) {
        return this._setLocal(this.luaState, ar.getPtr(), n);
    }

    public String getUpValue(int funcIndex, int n) {
        return this._getUpValue(this.luaState, funcIndex, n);
    }

    public String setUpValue(int funcIndex, int n) {
        return this._setUpValue(this.luaState, funcIndex, n);
    }

    public void freeLuaDebug(LuaDebug ar) {
        this._freeLuaDebug(ar.getPtr());
    }

    public void pushGlobalTable() {
        this._getGlobalTable(this.luaState);
    }

    public int rawLen(int idx) {
        return this._rawlen(this.luaState, idx);
    }

    public boolean compare(int idx1, int idx2, int op) {
        return 0 != this._compare(this.luaState, idx1, idx2, op);
    }

    public void arith(int op) {
        this._arith(this.luaState, op);
    }

    public void len(int idx) {
        this._len(this.luaState, idx);
    }

    public int resume(LuaState thread, int nargs) {
        return this._resume(this.luaState, thread.luaState, nargs);
    }

    public int pushThread(LuaState thread) {
        return this._pushthread(this.luaState, thread.luaState);
    }

    public void setUserValue(int idx) {
        this._setuservalue(this.luaState, idx);
    }

    public void getUserValue(int idx) {
        this._getuservalue(this.luaState, idx);
    }

    public int absIndex(int idx) {
        return this._absindex(this.luaState, idx);
    }

    public void openCoroutine() {
        this._openCoroutine(this.luaState);
    }

    public void rotate(int idx, int n) {
        this._rotate(this.luaState, idx, n);
    }

    public void openUtf8() {
        this._openUtf8(this.luaState);
    }

    private native int _getiuservalue(CPtr var1, int var2, int var3);

    private native int _setiuservalue(CPtr var1, int var2, int var3);

    private native void _warning(CPtr var1, String var2, int var3);

    private native int _resume(CPtr var1, CPtr var2, int var3, int var4);

    public void openLibs() {
        this._openLibs(this.luaState);
    }

    private native void luajava_open(CPtr var1, int var2);

    private native Object _getObjectFromUserdata(CPtr var1, int var2) throws LuaException;

    private native boolean _isObject(CPtr var1, int var2);

    private native void _pushJavaObject(CPtr var1, Object var2);

    private native void _pushJavaClass(CPtr var1, Class<?> var2);

    private native void _pushJavaArray(CPtr var1, Object var2);

    private native void _pushJavaFunction(CPtr var1, JavaFunction var2) throws LuaException;

    private native boolean _isJavaFunction(CPtr var1, int var2);

    private native int _isLuaArray(CPtr var1, int var2);

    public Object getObjectFromUserdata(int idx) throws LuaException {
        return this._getObjectFromUserdata(this.luaState, idx);
    }

    public boolean isObject(int idx) {
        return this._isObject(this.luaState, idx);
    }

    public void pushJavaClass(Class<?> clazz) {
        this._pushJavaClass(this.luaState, clazz);
    }

    public void pushJavaObject(Object obj) {
        this._pushJavaObject(this.luaState, obj);
    }

    public void pushJavaArray(Object obj) throws LuaException {
        if (!obj.getClass().isArray()) {
            throw new LuaException("Object is not an array.");
        }
        this._pushJavaArray(this.luaState, obj);
    }

    public void pushJavaFunction(JavaFunction func) throws LuaException {
        this._pushJavaFunction(this.luaState, func);
    }

    public boolean isJavaFunction(int idx) {
        return this._isJavaFunction(this.luaState, idx);
    }

    public int isLuaArray(int idx) {
        return this._isLuaArray(this.luaState, idx);
    }

    static {
        switch (LUA_VERSION) {
            case "Lua 5.2": {
                LUA_OPADD = 0;
                LUA_OPSUB = 1;
                LUA_OPMUL = 2;
                LUA_OPDIV = 3;
                LUA_OPMOD = 4;
                LUA_OPPOW = 5;
                LUA_OPUNM = 6;
                LUA_OPIDI = 6;
                LUA_OPBAN = 7;
                LUA_OPBOR = 8;
                LUA_OPBXO = 9;
                LUA_OPSHL = 10;
                LUA_OPSHR = 11;
                LUA_OPBNO = 13;
                break;
            }
            default: {
                LUA_OPADD = 0;
                LUA_OPSUB = 1;
                LUA_OPMUL = 2;
                LUA_OPMOD = 3;
                LUA_OPPOW = 4;
                LUA_OPDIV = 5;
                LUA_OPIDI = 6;
                LUA_OPBAN = 7;
                LUA_OPBOR = 8;
                LUA_OPBXO = 9;
                LUA_OPSHL = 10;
                LUA_OPSHR = 11;
                LUA_OPUNM = 12;
                LUA_OPBNO = 13;
            }
        }
    }
}

